/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.rtf.GroupState;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.CharsetUtils;
import org.xml.sax.SAXException;

final class TextExtractor {
    private byte[] pendingBytes = new byte[16];
    private int pendingByteCount;
    private ByteBuffer pendingByteBuffer = ByteBuffer.wrap(this.pendingBytes);
    private char[] pendingChars = new char[10];
    private int pendingCharCount;
    private byte[] pendingControl = new byte[10];
    private int pendingControlCount;
    private final char[] outputArray = new char[128];
    private final CharBuffer outputBuffer = CharBuffer.wrap(this.outputArray);
    private CharsetDecoder decoder;
    private String lastCharset;
    private String globalCharset = "windows-1252";
    private int globalDefaultFont = -1;
    private int curFontID = -1;
    private final Map<Integer, String> fontToCharset = new HashMap<Integer, String>();
    private final LinkedList<GroupState> groupStates = new LinkedList();
    private GroupState groupState = new GroupState();
    private boolean inHeader = true;
    private int fontTableState;
    private int fontTableDepth;
    private String nextMetaData;
    private boolean inParagraph;
    private final StringBuilder headerBuffer = new StringBuilder();
    private int uprState = -1;
    private final XHTMLContentHandler out;
    private final Metadata metadata;
    int ansiSkip = 0;
    private static final Map<Integer, String> FCHARSET_MAP = new HashMap<Integer, String>();
    private static final Map<Integer, String> ANSICPG_MAP;

    public TextExtractor(XHTMLContentHandler out, Metadata metadata) {
        this.metadata = metadata;
        this.out = out;
    }

    private static boolean isHexChar(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    private static boolean isAlpha(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static int hexValue(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'z') {
            return 10 + (ch - 97);
        }
        assert (ch >= 'A' && ch <= 'Z');
        return 10 + (ch - 65);
    }

    private void pushText() throws IOException, SAXException, TikaException {
        if (this.pendingByteCount != 0) {
            assert (this.pendingCharCount == 0);
            this.pushBytes();
        } else {
            this.pushChars();
        }
    }

    private void addOutputByte(byte b) throws IOException, SAXException, TikaException {
        if (this.pendingCharCount != 0) {
            this.pushChars();
        }
        if (this.pendingByteCount == this.pendingBytes.length) {
            byte[] newArray = new byte[(int)((double)this.pendingBytes.length * 1.25)];
            System.arraycopy(this.pendingBytes, 0, newArray, 0, this.pendingBytes.length);
            this.pendingBytes = newArray;
            this.pendingByteBuffer = ByteBuffer.wrap(this.pendingBytes);
        }
        this.pendingBytes[this.pendingByteCount++] = b;
    }

    private void addControl(byte b) {
        assert (TextExtractor.isAlpha((char)b));
        if (this.pendingControlCount == this.pendingControl.length) {
            byte[] newArray = new byte[(int)((double)this.pendingControl.length * 1.25)];
            System.arraycopy(this.pendingControl, 0, newArray, 0, this.pendingControl.length);
            this.pendingControl = newArray;
        }
        this.pendingControl[this.pendingControlCount++] = b;
    }

    private void addOutputChar(char ch) throws IOException, SAXException, TikaException {
        if (this.pendingByteCount != 0) {
            this.pushBytes();
        }
        if (this.inHeader) {
            this.headerBuffer.append(ch);
        } else {
            if (this.pendingCharCount == this.pendingChars.length) {
                char[] newArray = new char[(int)((double)this.pendingChars.length * 1.25)];
                System.arraycopy(this.pendingChars, 0, newArray, 0, this.pendingChars.length);
                this.pendingChars = newArray;
            }
            this.pendingChars[this.pendingCharCount++] = ch;
        }
    }

    public void extract(InputStream in) throws IOException, SAXException, TikaException {
        block29: {
            this.out.startDocument();
            int state = 0;
            int pushBack = -2;
            boolean negParam = false;
            char hex1 = '\u0000';
            long param = 0L;
            block8: while (true) {
                int b;
                if (pushBack != -2) {
                    b = pushBack;
                    pushBack = -2;
                } else {
                    b = in.read();
                }
                if (b == -1) break block29;
                char ch = (char)b;
                switch (state) {
                    case 0: {
                        if (ch == '\\') {
                            state = 1;
                            continue block8;
                        }
                        if (ch == '{') {
                            this.pushText();
                            this.processGroupStart();
                            continue block8;
                        }
                        if (ch == '}') {
                            this.pushText();
                            this.processGroupEnd();
                            continue block8;
                        }
                        if (ch == '\r' || ch == '\n' || this.groupState.ignore && this.nextMetaData == null) continue block8;
                        if (this.ansiSkip != 0) {
                            --this.ansiSkip;
                            continue block8;
                        }
                        this.addOutputByte((byte)ch);
                        continue block8;
                    }
                    case 1: {
                        if (ch == '\'') {
                            state = 2;
                            continue block8;
                        }
                        if (TextExtractor.isAlpha(ch)) {
                            this.addControl((byte)ch);
                            state = 4;
                            continue block8;
                        }
                        if (ch == '{' || ch == '}' || ch == '\\' || ch == '\r' || ch == '\n') {
                            this.addOutputByte((byte)ch);
                            state = 0;
                            continue block8;
                        }
                        this.processControlSymbol(ch);
                        state = 0;
                        continue block8;
                    }
                    case 2: {
                        if (TextExtractor.isHexChar(ch)) {
                            hex1 = ch;
                            state = 3;
                            continue block8;
                        }
                        state = 0;
                        continue block8;
                    }
                    case 3: {
                        if (TextExtractor.isHexChar(ch)) {
                            if (this.ansiSkip != 0) {
                                --this.ansiSkip;
                            } else {
                                this.addOutputByte((byte)(16 * TextExtractor.hexValue(hex1) + TextExtractor.hexValue(ch)));
                            }
                            state = 0;
                            continue block8;
                        }
                        state = 0;
                        continue block8;
                    }
                    case 4: {
                        if (TextExtractor.isAlpha(ch)) {
                            this.addControl((byte)ch);
                            continue block8;
                        }
                        if (ch == '-') {
                            negParam = true;
                            param = 0L;
                            state = 5;
                            continue block8;
                        }
                        if (TextExtractor.isDigit(ch)) {
                            negParam = false;
                            param = ch - 48;
                            state = 5;
                            continue block8;
                        }
                        if (ch == ' ') {
                            this.processControlWord();
                            this.pendingControlCount = 0;
                            state = 0;
                            continue block8;
                        }
                        this.processControlWord();
                        this.pendingControlCount = 0;
                        pushBack = ch;
                        state = 0;
                        continue block8;
                    }
                    case 5: {
                        if (TextExtractor.isDigit(ch)) {
                            param = 10L * param + (long)(ch - 48);
                            continue block8;
                        }
                        if (negParam) {
                            param = -param;
                        }
                        this.processControlWord(param);
                        this.pendingControlCount = 0;
                        if (ch != ' ') {
                            pushBack = ch;
                        }
                        state = 0;
                        continue block8;
                    }
                }
                break;
            }
            throw new RuntimeException("invalid state");
        }
        this.endParagraph(false);
        this.out.endDocument();
    }

    private void lazyStartParagraph() throws IOException, SAXException, TikaException {
        if (!this.inParagraph) {
            if (this.groupState.italic) {
                this.end("i");
            }
            if (this.groupState.bold) {
                this.end("b");
            }
            this.out.startElement("p");
            if (this.groupState.bold) {
                this.start("b");
            }
            if (this.groupState.italic) {
                this.start("i");
            }
            this.inParagraph = true;
        }
    }

    private void endParagraph(boolean preserveStyles) throws IOException, SAXException, TikaException {
        this.pushText();
        if (this.inParagraph) {
            if (this.groupState.italic) {
                this.end("i");
                this.groupState.italic = preserveStyles;
            }
            if (this.groupState.bold) {
                this.end("b");
                this.groupState.bold = preserveStyles;
            }
            this.out.endElement("p");
            if (preserveStyles && (this.groupState.bold || this.groupState.italic)) {
                this.start("p");
                if (this.groupState.bold) {
                    this.start("b");
                }
                if (this.groupState.italic) {
                    this.start("i");
                }
                this.inParagraph = true;
            } else {
                this.inParagraph = false;
            }
        }
    }

    private void pushChars() throws IOException, SAXException, TikaException {
        if (this.pendingCharCount != 0) {
            this.lazyStartParagraph();
            this.out.characters(this.pendingChars, 0, this.pendingCharCount);
            this.pendingCharCount = 0;
        }
    }

    private void pushBytes() throws IOException, SAXException, TikaException {
        if (!(this.pendingByteCount <= 0 || this.groupState.ignore && this.nextMetaData == null)) {
            int pos;
            CoderResult result;
            CharsetDecoder decoder = this.getDecoder();
            this.pendingByteBuffer.limit(this.pendingByteCount);
            assert (this.pendingByteBuffer.position() == 0);
            assert (this.outputBuffer.position() == 0);
            do {
                result = decoder.decode(this.pendingByteBuffer, this.outputBuffer, true);
                pos = this.outputBuffer.position();
                if (pos <= 0) continue;
                if (this.inHeader) {
                    this.headerBuffer.append(this.outputArray, 0, pos);
                } else {
                    this.lazyStartParagraph();
                    this.out.characters(this.outputArray, 0, pos);
                }
                this.outputBuffer.position(0);
            } while (result != CoderResult.UNDERFLOW);
            do {
                result = decoder.flush(this.outputBuffer);
                pos = this.outputBuffer.position();
                if (pos <= 0) continue;
                if (this.inHeader) {
                    this.headerBuffer.append(this.outputArray, 0, pos);
                } else {
                    this.lazyStartParagraph();
                    this.out.characters(this.outputArray, 0, pos);
                }
                this.outputBuffer.position(0);
            } while (result != CoderResult.UNDERFLOW);
            decoder.reset();
            this.pendingByteBuffer.position(0);
        }
        this.pendingByteCount = 0;
    }

    private boolean equals(String s) {
        if (this.pendingControlCount != s.length()) {
            return false;
        }
        for (int idx = 0; idx < this.pendingControlCount; ++idx) {
            assert (TextExtractor.isAlpha(s.charAt(idx)));
            if ((byte)s.charAt(idx) == this.pendingControl[idx]) continue;
            return false;
        }
        return true;
    }

    private void processControlSymbol(char ch) throws IOException, SAXException, TikaException {
        switch (ch) {
            case '~': {
                this.addOutputChar('\u00a0');
                break;
            }
            case '*': {
                this.groupState.ignore = true;
                break;
            }
            case '-': {
                this.addOutputChar('\u00ad');
                break;
            }
            case '_': {
                this.addOutputChar('\u2011');
                break;
            }
        }
    }

    private CharsetDecoder getDecoder() throws TikaException {
        String charset = this.getCharset();
        if (this.lastCharset == null || !charset.equals(this.lastCharset)) {
            this.decoder = CharsetUtils.forName(charset).newDecoder();
            if (this.decoder == null) {
                throw new TikaException("cannot find decoder for charset=" + charset);
            }
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.lastCharset = charset;
        }
        return this.decoder;
    }

    private String getCharset() throws TikaException {
        String cs;
        if (this.groupState.fontCharset != null) {
            return this.groupState.fontCharset;
        }
        if (this.globalDefaultFont != -1 && !this.inHeader && (cs = this.fontToCharset.get(this.globalDefaultFont)) != null) {
            return cs;
        }
        if (this.globalCharset == null) {
            throw new TikaException("unable to determine charset");
        }
        return this.globalCharset;
    }

    private void processControlWord(long param) throws IOException, SAXException, TikaException {
        if (this.inHeader) {
            String cs;
            if (this.equals("ansicpg")) {
                cs = ANSICPG_MAP.get((int)param);
                if (cs != null) {
                    this.globalCharset = cs;
                }
            } else if (this.equals("deff")) {
                this.globalDefaultFont = (int)param;
            }
            if (this.fontTableState == 1) {
                if (this.groupState.depth < this.fontTableDepth) {
                    this.fontTableState = 2;
                } else if (this.equals("f")) {
                    this.curFontID = (int)param;
                } else if (this.equals("fcharset") && (cs = FCHARSET_MAP.get((int)param)) != null) {
                    this.fontToCharset.put(this.curFontID, cs);
                }
            }
        } else if (this.equals("b")) {
            assert (param == 0L);
            if (this.groupState.bold) {
                this.pushText();
                if (this.groupState.italic) {
                    this.end("i");
                }
                this.end("b");
                if (this.groupState.italic) {
                    this.start("i");
                }
                this.groupState.bold = false;
            }
        } else if (this.equals("i")) {
            assert (param == 0L);
            if (this.groupState.italic) {
                this.pushText();
                this.end("i");
                this.groupState.italic = false;
            }
        } else if (this.equals("f")) {
            String fontCharset = this.fontToCharset.get((int)param);
            this.groupState.fontCharset = fontCharset != null ? fontCharset : null;
        }
        if (this.pendingControl[0] == 117) {
            if (this.pendingControlCount == 1) {
                if (!this.groupState.ignore) {
                    char utf16CodeUnit = (char)((int)param & 0xFFFF);
                    this.addOutputChar(utf16CodeUnit);
                }
                this.ansiSkip = this.groupState.ucSkip;
            } else if (this.pendingControlCount == 2 && this.pendingControl[1] == 99) {
                this.groupState.ucSkip = (int)param;
            }
        }
    }

    private void end(String tag) throws IOException, SAXException, TikaException {
        this.out.endElement(tag);
    }

    private void start(String tag) throws IOException, SAXException, TikaException {
        this.out.startElement(tag);
    }

    private void processControlWord() throws IOException, SAXException, TikaException {
        if (this.inHeader) {
            if (this.equals("ansi")) {
                this.globalCharset = "cp1252";
            } else if (this.equals("pca")) {
                this.globalCharset = "cp850";
            } else if (this.equals("pc")) {
                this.globalCharset = "cp437";
            } else if (this.equals("mac")) {
                this.globalCharset = "MacRoman";
            }
            if (this.equals("colortbl") || this.equals("stylesheet") || this.equals("fonttbl")) {
                this.groupState.ignore = true;
            }
            if (this.uprState == -1) {
                if (this.equals("author")) {
                    this.nextMetaData = "Author";
                } else if (this.equals("title")) {
                    this.nextMetaData = "title";
                } else if (this.equals("subject")) {
                    this.nextMetaData = "subject";
                } else if (this.equals("keywords")) {
                    this.nextMetaData = "Keywords";
                } else if (this.equals("category")) {
                    this.nextMetaData = "Category";
                } else if (this.equals("comment")) {
                    this.nextMetaData = "comment";
                } else if (this.equals("company")) {
                    this.nextMetaData = "Company";
                } else if (this.equals("manager")) {
                    this.nextMetaData = "Manager";
                } else if (this.equals("template")) {
                    this.nextMetaData = "Template";
                }
            }
            if (this.fontTableState == 0) {
                if (this.equals("fonttbl")) {
                    this.fontTableState = 1;
                    this.fontTableDepth = this.groupState.depth;
                }
            } else if (this.fontTableState == 1 && this.groupState.depth < this.fontTableDepth) {
                this.fontTableState = 2;
            }
            if (!this.groupState.ignore && (this.equals("par") || this.equals("pard") || this.equals("sect") || this.equals("sectd") || this.equals("plain") || this.equals("ltrch") || this.equals("rtlch"))) {
                this.inHeader = false;
            }
        } else if (this.equals("b")) {
            if (!this.groupState.bold) {
                this.pushText();
                this.lazyStartParagraph();
                if (this.groupState.italic) {
                    this.end("i");
                }
                this.groupState.bold = true;
                this.start("b");
                if (this.groupState.italic) {
                    this.start("i");
                }
            }
        } else if (this.equals("i") && !this.groupState.italic) {
            this.pushText();
            this.lazyStartParagraph();
            this.groupState.italic = true;
            this.start("i");
        }
        if (this.equals("pard")) {
            this.pushText();
            if (this.groupState.italic) {
                this.end("i");
                this.groupState.italic = false;
            }
            if (this.groupState.bold) {
                this.end("b");
                this.groupState.bold = false;
            }
        } else if (this.equals("par")) {
            this.endParagraph(true);
        } else if (this.equals("shptxt")) {
            this.pushText();
            this.groupState.ignore = false;
        } else if (this.equals("atnid")) {
            this.pushText();
            this.groupState.ignore = false;
        } else if (this.equals("atnauthor")) {
            this.pushText();
            this.groupState.ignore = false;
        } else if (this.equals("annotation")) {
            this.pushText();
            this.groupState.ignore = false;
        } else if (this.equals("cell")) {
            this.endParagraph(true);
        } else if (this.equals("pict")) {
            this.pushText();
            this.groupState.ignore = true;
        } else if (this.equals("line")) {
            this.addOutputChar('\n');
        } else if (this.equals("column")) {
            this.addOutputChar(' ');
        } else if (this.equals("page")) {
            this.addOutputChar('\n');
        } else if (this.equals("softline")) {
            this.addOutputChar('\n');
        } else if (this.equals("softcolumn")) {
            this.addOutputChar(' ');
        } else if (this.equals("softpage")) {
            this.addOutputChar('\n');
        } else if (this.equals("tab")) {
            this.addOutputChar('\t');
        } else if (this.equals("upr")) {
            this.uprState = 0;
        } else if (this.equals("ud") && this.uprState == 1) {
            this.uprState = -1;
            this.groupState.ignore = false;
        } else if (this.equals("bullet")) {
            this.addOutputChar('\u2022');
        } else if (this.equals("endash")) {
            this.addOutputChar('\u2013');
        } else if (this.equals("emdash")) {
            this.addOutputChar('\u2014');
        } else if (this.equals("enspace")) {
            this.addOutputChar('\u2002');
        } else if (this.equals("qmspace")) {
            this.addOutputChar('\u2005');
        } else if (this.equals("emspace")) {
            this.addOutputChar('\u2003');
        } else if (this.equals("lquote")) {
            this.addOutputChar('\u2018');
        } else if (this.equals("rquote")) {
            this.addOutputChar('\u2019');
        } else if (this.equals("ldblquote")) {
            this.addOutputChar('\u201c');
        } else if (this.equals("rdblquote")) {
            this.addOutputChar('\u201d');
        }
    }

    private void processGroupStart() throws IOException {
        this.ansiSkip = 0;
        this.groupStates.add(this.groupState);
        this.groupState = new GroupState(this.groupState);
        assert (this.groupStates.size() == this.groupState.depth) : "size=" + this.groupStates.size() + " depth=" + this.groupState.depth;
        if (this.uprState == 0) {
            this.uprState = 1;
            this.groupState.ignore = true;
        }
    }

    private void processGroupEnd() throws IOException, SAXException, TikaException {
        if (this.inHeader) {
            if (this.nextMetaData != null) {
                this.metadata.add(this.nextMetaData, this.headerBuffer.toString());
                this.nextMetaData = null;
            }
            this.headerBuffer.setLength(0);
        }
        assert (this.groupState.depth > 0);
        this.ansiSkip = 0;
        GroupState outerGroupState = this.groupStates.removeLast();
        if (this.groupState.italic && (!outerGroupState.italic || this.groupState.bold != outerGroupState.bold)) {
            this.end("i");
            this.groupState.italic = false;
        }
        if (this.groupState.bold && !outerGroupState.bold) {
            this.end("b");
        }
        if (!this.groupState.bold && outerGroupState.bold) {
            this.start("b");
        }
        if (!this.groupState.italic && outerGroupState.italic) {
            this.start("i");
        }
        this.groupState = outerGroupState;
        assert (this.groupStates.size() == this.groupState.depth);
    }

    static {
        FCHARSET_MAP.put(0, "windows-1252");
        FCHARSET_MAP.put(77, "MacRoman");
        FCHARSET_MAP.put(78, "Shift_JIS");
        FCHARSET_MAP.put(79, "ms949");
        FCHARSET_MAP.put(80, "GB2312");
        FCHARSET_MAP.put(81, "Big5");
        FCHARSET_MAP.put(82, "johab");
        FCHARSET_MAP.put(83, "MacHebrew");
        FCHARSET_MAP.put(84, "MacArabic");
        FCHARSET_MAP.put(85, "MacGreek");
        FCHARSET_MAP.put(86, "MacTurkish");
        FCHARSET_MAP.put(87, "MacThai");
        FCHARSET_MAP.put(88, "cp1250");
        FCHARSET_MAP.put(89, "cp1251");
        FCHARSET_MAP.put(128, "MS932");
        FCHARSET_MAP.put(129, "ms949");
        FCHARSET_MAP.put(130, "ms1361");
        FCHARSET_MAP.put(134, "ms936");
        FCHARSET_MAP.put(136, "ms950");
        FCHARSET_MAP.put(161, "cp1253");
        FCHARSET_MAP.put(162, "cp1254");
        FCHARSET_MAP.put(163, "cp1258");
        FCHARSET_MAP.put(177, "cp1255");
        FCHARSET_MAP.put(178, "cp1256");
        FCHARSET_MAP.put(186, "cp1257");
        FCHARSET_MAP.put(204, "cp1251");
        FCHARSET_MAP.put(222, "ms874");
        FCHARSET_MAP.put(238, "cp1250");
        FCHARSET_MAP.put(254, "cp437");
        FCHARSET_MAP.put(255, "cp850");
        ANSICPG_MAP = new HashMap<Integer, String>();
        ANSICPG_MAP.put(437, "CP437");
        ANSICPG_MAP.put(708, "ISO-8859-6");
        ANSICPG_MAP.put(709, "windows-709");
        ANSICPG_MAP.put(710, "windows-710");
        ANSICPG_MAP.put(710, "windows-711");
        ANSICPG_MAP.put(710, "windows-720");
        ANSICPG_MAP.put(819, "CP819");
        ANSICPG_MAP.put(819, "CP819");
        ANSICPG_MAP.put(819, "CP819");
        ANSICPG_MAP.put(850, "CP850");
        ANSICPG_MAP.put(852, "CP852");
        ANSICPG_MAP.put(860, "CP860");
        ANSICPG_MAP.put(862, "CP862");
        ANSICPG_MAP.put(863, "CP863");
        ANSICPG_MAP.put(864, "CP864");
        ANSICPG_MAP.put(865, "CP865");
        ANSICPG_MAP.put(866, "CP866");
        ANSICPG_MAP.put(874, "MS874");
        ANSICPG_MAP.put(932, "MS932");
        ANSICPG_MAP.put(936, "MS936");
        ANSICPG_MAP.put(949, "CP949");
        ANSICPG_MAP.put(950, "CP950");
        ANSICPG_MAP.put(1250, "CP1250");
        ANSICPG_MAP.put(1251, "CP1251");
        ANSICPG_MAP.put(1252, "CP1252");
        ANSICPG_MAP.put(1253, "CP1253");
        ANSICPG_MAP.put(1254, "CP1254");
        ANSICPG_MAP.put(1255, "CP1255");
        ANSICPG_MAP.put(1256, "CP1256");
        ANSICPG_MAP.put(1257, "CP1257");
        ANSICPG_MAP.put(1258, "CP1258");
        ANSICPG_MAP.put(1361, "x-Johab");
        ANSICPG_MAP.put(10000, "MacRoman");
        ANSICPG_MAP.put(10001, "Shift_JIS");
        ANSICPG_MAP.put(10004, "MacArabic");
        ANSICPG_MAP.put(10005, "MacHebrew");
        ANSICPG_MAP.put(10006, "MacGreek");
        ANSICPG_MAP.put(10007, "MacCyrillic");
        ANSICPG_MAP.put(10029, "x-MacCentralEurope");
        ANSICPG_MAP.put(10081, "MacTurkish");
        ANSICPG_MAP.put(57002, "x-ISCII91");
        ANSICPG_MAP.put(57003, "windows-57003");
        ANSICPG_MAP.put(57004, "windows-57004");
        ANSICPG_MAP.put(57005, "windows-57005");
        ANSICPG_MAP.put(57006, "windows-57006");
        ANSICPG_MAP.put(57007, "windows-57007");
        ANSICPG_MAP.put(57008, "windows-57008");
        ANSICPG_MAP.put(57009, "windows-57009");
        ANSICPG_MAP.put(57010, "windows-57010");
        ANSICPG_MAP.put(57011, "windows-57011");
    }
}

