/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.util.List;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.MetadataExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOOXMLExtractor
implements OOXMLExtractor {
    static final String RELATION_AUDIO = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/audio";
    static final String RELATION_IMAGE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image";
    static final String RELATION_OLE_OBJECT = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject";
    static final String RELATION_PACKAGE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/package";
    protected POIXMLTextExtractor extractor;
    private final EmbeddedDocumentExtractor embeddedExtractor;
    private final String type;

    public AbstractOOXMLExtractor(ParseContext context, POIXMLTextExtractor extractor, String type) {
        this.extractor = extractor;
        this.type = type;
        EmbeddedDocumentExtractor ex = context.get(EmbeddedDocumentExtractor.class);
        this.embeddedExtractor = ex == null ? new ParsingEmbeddedDocumentExtractor(context) : ex;
    }

    @Override
    public POIXMLDocument getDocument() {
        return this.extractor.getDocument();
    }

    @Override
    public MetadataExtractor getMetadataExtractor() {
        return new MetadataExtractor(this.extractor, this.type);
    }

    @Override
    public void getXHTML(ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, XmlException, IOException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        this.buildXHTML(xhtml);
        xhtml.endDocument();
        List<PackagePart> mainParts = this.getMainDocumentParts();
        for (PackagePart part : mainParts) {
            PackageRelationshipCollection rels;
            try {
                rels = part.getRelationships();
            }
            catch (InvalidFormatException e) {
                throw new TikaException("Corrupt OOXML file", e);
            }
            for (PackageRelationship rel : rels) {
                PackagePartName relName;
                if (!rel.getRelationshipType().equals(RELATION_AUDIO) && !rel.getRelationshipType().equals(RELATION_IMAGE) && !rel.getRelationshipType().equals(RELATION_OLE_OBJECT) && !rel.getRelationshipType().equals(RELATION_PACKAGE) || rel.getTargetMode() != TargetMode.INTERNAL) continue;
                try {
                    relName = PackagingURIHelper.createPartName(rel.getTargetURI());
                }
                catch (InvalidFormatException e) {
                    throw new TikaException("Broken OOXML file", e);
                }
                PackagePart relPart = rel.getPackage().getPart(relName);
                this.handleEmbedded(rel, relPart, handler, context);
            }
        }
    }

    protected void handleEmbedded(PackageRelationship rel, PackagePart part, ContentHandler handler, ParseContext context) throws SAXException, XmlException, IOException, TikaException {
        String name = rel.getTargetURI().toString();
        if (name.indexOf(47) > -1) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        String type = part.getContentType();
        Metadata metadata = new Metadata();
        metadata.set("resourceName", name);
        metadata.set("Content-Type", type);
        if (this.embeddedExtractor.shouldParseEmbedded(metadata)) {
            this.embeddedExtractor.parseEmbedded(TikaInputStream.get(part.getInputStream()), new EmbeddedContentHandler(handler), metadata, false);
        }
    }

    protected abstract void buildXHTML(XHTMLContentHandler var1) throws SAXException, XmlException, IOException;

    protected abstract List<PackagePart> getMainDocumentParts() throws TikaException;
}

