# {%= name %} {%= badge("fury") %}

> {%= description %}

{%= include("install-npm", {save: true}) %}

## Usage

**Lo-Dash**

```js
var _ = require('lodash');

_.template('<%= glob("files/*.txt") %>', {
  glob: require('helper-glob')
});

// glob and read files
var fs = require('fs');
_.template('<%= _.map(glob("files/*.txt"), read) %>', {
  glob: require('helper-glob'),
  read: function(fp) {
    return fs.readFileSync(fp, 'utf8');
  }
});

```

**Handlebars**

```js
var handlebars = require('handlebars');
var fs = require('fs');

handlebars.registerHelper('glob', require('helper-glob'));
handlebars.registerHelper('read', function(fp) {
  return fs.readFileSync(fp, 'utf8');
});
```

```handlebars
{{glob 'files/*.txt'}}

<!-- glob and read files using subexpressions -->
{{#each (glob "files/*.hbs")}}
  {{read .}}
{{/each}}
```

## Author
{%= include("author") %}

## License
{%= copyright() %}
{%= license() %}

***

{%= include("footer") %}

[assemble]: https://github.com/assemble/assemble
[generator-verb]: https://github.com/assemble/generator-verb
[handlebars-helpers]: https://github.com/assemble/handlebars-helpers/
[handlebars]: https://github.com/wycats/handlebars.js/
[helpers]: https://github.com/helpers
[Lo-Dash]: https://lodash.com/
[template]: https://github.com/jonschlinkert/template
[underscore]: https://github.com/jashkenas/underscore
[verb]: https://github.com/assemble/verb
[guide]: https://github.com/helpers/requests