module.exports = // TODO support filter tags like :javascript, support inline HTML
function(hljs) {
  return {
    case_insensitive: true,
    contains: [
      {
        className: 'doctype',
        begin: '^!!!( (5|1\\.1|Strict|Frameset|Basic|Mobile|RDFa|XML\\b.*))?$',
        relevance: 10
      },
      {
        className: 'comment',
        // FIXME these comments should be allowed to span indented lines
        begin: '^\\s*(-#|/).*$',
        relevance: 0
      },
      {
        begin: '^\\s*-(?!#)',
        starts: {
          end: '\\n',
          subLanguage: 'ruby'
        },
        relevance: 0
      },
      {
        className: 'tag',
        begin: '^\\s*%',
        contains: [
          {
            className: 'title',
            begin: '\\w+',
            relevance: 0
          },
          {
            className: 'value',
            begin: '[#\\.]\\w+',
            relevance: 0
          },
          {
            begin: '{\\s*',
            end: '\\s*}',
            excludeEnd: true,
            contains: [
              {
                //className: 'attribute',
                begin: ':\\w+\\s*=>',
                end: ',\\s+',
                returnBegin: true,
                endsWithParent: true,
                relevance: 0,
                contains: [
                  {
                    className: 'symbol',
                    begin: ':\\w+',
                    relevance: 0
                  },
                  {
                    className: 'string',
                    begin: '"',
                    end: '"',
                    relevance: 0
                  },
                  {
                    className: 'string',
                    begin: '\'',
                    end: '\'',
                    relevance: 0
                  },
                  {
                    begin: '\\w+',
                    relevance: 0
                  }
                ]
              },
            ],
            relevance: 0
          },
          {
            begin: '\\(\\s*',
            end: '\\s*\\)',
            excludeEnd: true,
            contains: [
              {
                //className: 'attribute',
                begin: '\\w+\\s*=',
                end: '\\s+',
                returnBegin: true,
                endsWithParent: true,
                relevance: 0,
                contains: [
                  {
                    className: 'attribute',
                    begin: '\\w+',
                    relevance: 0
                  },
                  {
                    className: 'string',
                    begin: '"',
                    end: '"',
                    relevance: 0
                  },
                  {
                    className: 'string',
                    begin: '\'',
                    end: '\'',
                    relevance: 0
                  },
                  {
                    begin: '\\w+',
                    relevance: 0
                  }
                ]
              },
            ],
            relevance: 0
          }
        ],
        relevance: 10
      },
      {
        className: 'bullet',
        begin: '^\\s*[=~]\\s*',
        relevance: 0
      },
      {
        begin: '#{',
        starts: {
          end: '}',
          subLanguage: 'ruby'
        },
        relevance: 0
      }
    ]
  };
};