/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.projectset.data;

import com.openexchange.projectset.data.Repository;
import com.openexchange.projectset.data.RepositoryType;
import org.apache.tools.ant.BuildException;

public class GitRepository
extends Repository {
    private final String remote;
    private final String branch;

    public GitRepository(String remote, String branch, String projectName) {
        super(projectName);
        this.remote = remote;
        this.branch = branch;
    }

    @Override
    public RepositoryType getRepositoryType() {
        return RepositoryType.Git;
    }

    public String getRemote() {
        return this.remote;
    }

    public String getBranch() {
        return this.branch;
    }

    static Repository parseGitReference(String reference) {
        String[] parts = reference.split(",");
        if (4 != parts.length) {
            throw new BuildException("Unknown number of Git reference definition parts.");
        }
        if (!"1.0".equals(parts[0])) {
            throw new BuildException("Unknown CVS reference version " + parts[0]);
        }
        return new GitRepository(parts[1], parts[2], parts[3]);
    }
}

