module.exports = (function() {
  /*
   * Generated by PEG.js 0.8.0.
   *
   * http://pegjs.majda.cz/
   */

  function peg$subclass(child, parent) {
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor();
  }

  function SyntaxError(message, expected, found, offset, line, column) {
    this.message  = message;
    this.expected = expected;
    this.found    = found;
    this.offset   = offset;
    this.line     = line;
    this.column   = column;

    this.name     = "SyntaxError";
  }

  peg$subclass(SyntaxError, Error);

  function parse(input) {
    var options = arguments.length > 1 ? arguments[1] : {},

        peg$FAILED = {},

        peg$startRuleFunctions = { typeExpr: peg$parsetypeExpr },
        peg$startRuleFunction  = peg$parsetypeExpr,

        peg$c0 = peg$FAILED,
        peg$c1 = [],
        peg$c2 = function(prefixModifiersWithWhiteSpaces, modifieeWithWhiteSpaces, postfixModifiersWithWhiteSpaces) {
            var prefixModifiers = lodash.pluck(prefixModifiersWithWhiteSpaces, 0);
            var modifiee = modifieeWithWhiteSpaces;
            var postfixModifiers = lodash.pluck(postfixModifiersWithWhiteSpaces, 0);

            var modifiersOrderedByPriority = postfixModifiers.concat(reverse(prefixModifiers));
            var rootNode = modifiersOrderedByPriority.reduce(function(prevNode, operator) {
              switch (operator.operatorType) {
                case OperatorType.UNION:
                  var unionOperator = operator;
                  return {
                    type: NodeType.UNION,
                    left: prevNode,
                    right: unionOperator.right,
                  };
                case OperatorType.MEMBER:
                  var memberOperator = operator;
                  return {
                    type: NodeType.MEMBER,
                    owner: prevNode,
                    name: memberOperator.memberName,
                  };
                case OperatorType.INNER_MEMBER:
                  var memberOperator = operator;
                  return {
                    type: NodeType.INNER_MEMBER,
                    owner: prevNode,
                    name: memberOperator.memberName,
                  };
                case OperatorType.INSTANCE_MEMBER:
                  var memberOperator = operator;
                  return {
                    type: NodeType.INSTANCE_MEMBER,
                    owner: prevNode,
                    name: memberOperator.memberName,
                  };
                case OperatorType.GENERIC:
                  var genericOperator = operator;
                  return {
                    type: NodeType.GENERIC,
                    subject: prevNode,
                    objects: genericOperator.objects,
                  }
                case OperatorType.ARRAY:
                  var arrayOperator = operator;
                  return {
                    type: NodeType.GENERIC,
                    subject: {
                      type: NodeType.NAME,
                      name: 'Array'
                    },
                    objects: [ prevNode ],
                  };
                case OperatorType.OPTIONAL:
                  return {
                    type: NodeType.OPTIONAL,
                    value: prevNode,
                  };
                case OperatorType.NULLABLE:
                  return {
                    type: NodeType.NULLABLE,
                    value: prevNode,
                  };
                case OperatorType.NOT_NULLABLE:
                  return {
                    type: NodeType.NOT_NULLABLE,
                    value: prevNode,
                  };
                case OperatorType.VARIADIC:
                  return {
                    type: NodeType.VARIADIC,
                    value: prevNode,
                  };
                default:
                  throw Error('Unexpected token: ' + token);
              }
            }, modifiee);


            return rootNode;
          },
        peg$c3 = "(",
        peg$c4 = { type: "literal", value: "(", description: "\"(\"" },
        peg$c5 = ")",
        peg$c6 = { type: "literal", value: ")", description: "\")\"" },
        peg$c7 = function(wrapped) {
            return wrapped;
          },
        peg$c8 = function(name) {
            return {
              type: NodeType.NAME,
              name: name
            };
          },
        peg$c9 = /^[a-zA-Z_$]/,
        peg$c10 = { type: "class", value: "[a-zA-Z_$]", description: "[a-zA-Z_$]" },
        peg$c11 = /^[a-zA-Z0-9_$]/,
        peg$c12 = { type: "class", value: "[a-zA-Z0-9_$]", description: "[a-zA-Z0-9_$]" },
        peg$c13 = "module",
        peg$c14 = { type: "literal", value: "module", description: "\"module\"" },
        peg$c15 = ":",
        peg$c16 = { type: "literal", value: ":", description: "\":\"" },
        peg$c17 = function(filePath) {
            return {
              type: NodeType.MODULE,
              path: filePath
            };
          },
        peg$c18 = /^[a-zA-Z_0-9_$.\/\-]/,
        peg$c19 = { type: "class", value: "[a-zA-Z_0-9_$.\\/\\-]", description: "[a-zA-Z_0-9_$.\\/\\-]" },
        peg$c20 = "*",
        peg$c21 = { type: "literal", value: "*", description: "\"*\"" },
        peg$c22 = function() {
            return { type: NodeType.ANY };
          },
        peg$c23 = "?",
        peg$c24 = { type: "literal", value: "?", description: "\"?\"" },
        peg$c25 = function() {
            return { type: NodeType.UNKNOWN };
          },
        peg$c26 = "function",
        peg$c27 = { type: "literal", value: "function", description: "\"function\"" },
        peg$c28 = null,
        peg$c29 = function(paramParts, returnedTypePart) {
            var modifierGroups = lodash.groupBy(paramParts, lodash.property('modifierType'));

            var params = [];
            var noModifiers = modifierGroups[FunctionModifierType.NONE];
            if (noModifiers) {
              params = noModifiers.map(function(paramPartWithNoModifier) {
                return paramPartWithNoModifier.value;
              });
            }


            var thisValue = null;
            var thisValueModifiers = modifierGroups[FunctionModifierType.THIS];
            if (thisValueModifiers) {
              if (thisValueModifiers.length > 1) {
                reportSemanticIssue('"this" keyword should be declared only once');
              }

              // Enable the only first thisValue modifier.
              thisValue = thisValueModifiers[0].value;
            }


            var newValue = null;
            var newModifiers = modifierGroups[FunctionModifierType.NEW];
            if (newModifiers) {
              if (newModifiers.length > 1) {
                reportSemanticIssue('"new" keyword should be declared only once');
              }

              // Enable the only first new instance modifier.
              newValue = newModifiers[0].value;
            }

            var returnedTypeNode = returnedTypePart ? returnedTypePart[3] : null;

            return {
              type: NodeType.FUNCTION,
              params: params,
              returns: returnedTypeNode,
              thisValue: thisValue,
              newValue: newValue,
            };
          },
        peg$c30 = ",",
        peg$c31 = { type: "literal", value: ",", description: "\",\"" },
        peg$c32 = function(firstParam, restParamsWithComma) {
            var params = buildByFirstAndRest(firstParam, restParamsWithComma, 3);
            return params;
          },
        peg$c33 = "this",
        peg$c34 = { type: "literal", value: "this", description: "\"this\"" },
        peg$c35 = function(value) {
            return {
              modifierType: FunctionModifierType.THIS,
              value: value
            };
          },
        peg$c36 = "new",
        peg$c37 = { type: "literal", value: "new", description: "\"new\"" },
        peg$c38 = function(value) {
            return {
              modifierType: FunctionModifierType.NEW,
              value: value
            };
          },
        peg$c39 = function(value) {
            return {
              modifierType: FunctionModifierType.NONE,
              value: value
            };
          },
        peg$c40 = "{",
        peg$c41 = { type: "literal", value: "{", description: "\"{\"" },
        peg$c42 = "}",
        peg$c43 = { type: "literal", value: "}", description: "\"}\"" },
        peg$c44 = function(firstEntry, restEntriesWithComma) {
            var entries = buildByFirstAndRest(firstEntry, restEntriesWithComma, 3);

            return {
              type: NodeType.RECORD,
              entries: entries
            };
          },
        peg$c45 = function(key, valueWithColon) {
            var hasValue = Boolean(valueWithColon);
            var value = hasValue ? valueWithColon[3] : null;

            return {
              type: NodeType.RECORD_ENTRY,
              key: key,
              value: value,
              hasValue: hasValue,
            };
          },
        peg$c46 = function() {
            return { operatorType: OperatorType.NULLABLE };
          },
        peg$c47 = "!",
        peg$c48 = { type: "literal", value: "!", description: "\"!\"" },
        peg$c49 = function() {
            return { operatorType: OperatorType.NOT_NULLABLE };
          },
        peg$c50 = "=",
        peg$c51 = { type: "literal", value: "=", description: "\"=\"" },
        peg$c52 = function() {
            return { operatorType: OperatorType.OPTIONAL };
          },
        peg$c53 = "...",
        peg$c54 = { type: "literal", value: "...", description: "\"...\"" },
        peg$c55 = function() {
            return { operatorType: OperatorType.VARIADIC };
          },
        peg$c56 = function(right) {
            return {
              operatorType: OperatorType.UNION,
              right: right,
            };
          },
        peg$c57 = "|",
        peg$c58 = { type: "literal", value: "|", description: "\"|\"" },
        peg$c59 = function(memberName) {
            return {
              operatorType: OperatorType.MEMBER,
              memberName: memberName,
            };
          },
        peg$c60 = ".",
        peg$c61 = { type: "literal", value: ".", description: "\".\"" },
        peg$c62 = function(name) {
            return name;
          },
        peg$c63 = function(memberName) {
            return {
              operatorType: OperatorType.INNER_MEMBER,
              memberName: memberName,
            };
          },
        peg$c64 = "~",
        peg$c65 = { type: "literal", value: "~", description: "\"~\"" },
        peg$c66 = function(memberName) {
            return {
              operatorType: OperatorType.INSTANCE_MEMBER,
              memberName: memberName,
            };
          },
        peg$c67 = "#",
        peg$c68 = { type: "literal", value: "#", description: "\"#\"" },
        peg$c69 = function(objects) {
            return {
              operatorType: OperatorType.GENERIC,
              objects: objects,
            };
          },
        peg$c70 = ".<",
        peg$c71 = { type: "literal", value: ".<", description: "\".<\"" },
        peg$c72 = "<",
        peg$c73 = { type: "literal", value: "<", description: "\"<\"" },
        peg$c74 = ">",
        peg$c75 = { type: "literal", value: ">", description: "\">\"" },
        peg$c76 = function(first, restsWithComma) {
            var objects = buildByFirstAndRest(first, restsWithComma, 3);
            return objects;
          },
        peg$c77 = "[]",
        peg$c78 = { type: "literal", value: "[]", description: "\"[]\"" },
        peg$c79 = function() {
            return { operatorType: OperatorType.ARRAY };
          },
        peg$c80 = /^[ \t\r\n ]/,
        peg$c81 = { type: "class", value: "[ \\t\\r\\n ]", description: "[ \\t\\r\\n ]" },

        peg$currPos          = 0,
        peg$reportedPos      = 0,
        peg$cachedPos        = 0,
        peg$cachedPosDetails = { line: 1, column: 1, seenCR: false },
        peg$maxFailPos       = 0,
        peg$maxFailExpected  = [],
        peg$silentFails      = 0,

        peg$result;

    if ("startRule" in options) {
      if (!(options.startRule in peg$startRuleFunctions)) {
        throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
      }

      peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }

    function text() {
      return input.substring(peg$reportedPos, peg$currPos);
    }

    function offset() {
      return peg$reportedPos;
    }

    function line() {
      return peg$computePosDetails(peg$reportedPos).line;
    }

    function column() {
      return peg$computePosDetails(peg$reportedPos).column;
    }

    function expected(description) {
      throw peg$buildException(
        null,
        [{ type: "other", description: description }],
        peg$reportedPos
      );
    }

    function error(message) {
      throw peg$buildException(message, null, peg$reportedPos);
    }

    function peg$computePosDetails(pos) {
      function advance(details, startPos, endPos) {
        var p, ch;

        for (p = startPos; p < endPos; p++) {
          ch = input.charAt(p);
          if (ch === "\n") {
            if (!details.seenCR) { details.line++; }
            details.column = 1;
            details.seenCR = false;
          } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
            details.line++;
            details.column = 1;
            details.seenCR = true;
          } else {
            details.column++;
            details.seenCR = false;
          }
        }
      }

      if (peg$cachedPos !== pos) {
        if (peg$cachedPos > pos) {
          peg$cachedPos = 0;
          peg$cachedPosDetails = { line: 1, column: 1, seenCR: false };
        }
        advance(peg$cachedPosDetails, peg$cachedPos, pos);
        peg$cachedPos = pos;
      }

      return peg$cachedPosDetails;
    }

    function peg$fail(expected) {
      if (peg$currPos < peg$maxFailPos) { return; }

      if (peg$currPos > peg$maxFailPos) {
        peg$maxFailPos = peg$currPos;
        peg$maxFailExpected = [];
      }

      peg$maxFailExpected.push(expected);
    }

    function peg$buildException(message, expected, pos) {
      function cleanupExpected(expected) {
        var i = 1;

        expected.sort(function(a, b) {
          if (a.description < b.description) {
            return -1;
          } else if (a.description > b.description) {
            return 1;
          } else {
            return 0;
          }
        });

        while (i < expected.length) {
          if (expected[i - 1] === expected[i]) {
            expected.splice(i, 1);
          } else {
            i++;
          }
        }
      }

      function buildMessage(expected, found) {
        function stringEscape(s) {
          function hex(ch) { return ch.charCodeAt(0).toString(16).toUpperCase(); }

          return s
            .replace(/\\/g,   '\\\\')
            .replace(/"/g,    '\\"')
            .replace(/\x08/g, '\\b')
            .replace(/\t/g,   '\\t')
            .replace(/\n/g,   '\\n')
            .replace(/\f/g,   '\\f')
            .replace(/\r/g,   '\\r')
            .replace(/[\x00-\x07\x0B\x0E\x0F]/g, function(ch) { return '\\x0' + hex(ch); })
            .replace(/[\x10-\x1F\x80-\xFF]/g,    function(ch) { return '\\x'  + hex(ch); })
            .replace(/[\u0180-\u0FFF]/g,         function(ch) { return '\\u0' + hex(ch); })
            .replace(/[\u1080-\uFFFF]/g,         function(ch) { return '\\u'  + hex(ch); });
        }

        var expectedDescs = new Array(expected.length),
            expectedDesc, foundDesc, i;

        for (i = 0; i < expected.length; i++) {
          expectedDescs[i] = expected[i].description;
        }

        expectedDesc = expected.length > 1
          ? expectedDescs.slice(0, -1).join(", ")
              + " or "
              + expectedDescs[expected.length - 1]
          : expectedDescs[0];

        foundDesc = found ? "\"" + stringEscape(found) + "\"" : "end of input";

        return "Expected " + expectedDesc + " but " + foundDesc + " found.";
      }

      var posDetails = peg$computePosDetails(pos),
          found      = pos < input.length ? input.charAt(pos) : null;

      if (expected !== null) {
        cleanupExpected(expected);
      }

      return new SyntaxError(
        message !== null ? message : buildMessage(expected, found),
        expected,
        found,
        pos,
        posDetails.line,
        posDetails.column
      );
    }

    function peg$parsetypeExpr() {
      var s0;

      s0 = peg$parsenotUnknownTypeExpr();
      if (s0 === peg$FAILED) {
        s0 = peg$parseunknownTypeExpr();
      }

      return s0;
    }

    function peg$parsenotUnknownTypeExpr() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$currPos;
      s3 = peg$parseprefixModifiers();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s3 = [s3, s4];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$c0;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$c0;
      }
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$currPos;
        s3 = peg$parseprefixModifiers();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$c0;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$c0;
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsemodifiee();
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$currPos;
            s6 = peg$parsepostfixModifiers();
            if (s6 !== peg$FAILED) {
              s7 = peg$parse_();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$c0;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$c0;
            }
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$currPos;
              s6 = peg$parsepostfixModifiers();
              if (s6 !== peg$FAILED) {
                s7 = peg$parse_();
                if (s7 !== peg$FAILED) {
                  s6 = [s6, s7];
                  s5 = s6;
                } else {
                  peg$currPos = s5;
                  s5 = peg$c0;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$c0;
              }
            }
            if (s4 !== peg$FAILED) {
              peg$reportedPos = s0;
              s1 = peg$c2(s1, s2, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$c0;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c0;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parseprefixModifiers() {
      var s0;

      s0 = peg$parsenullableTypeOperator();
      if (s0 === peg$FAILED) {
        s0 = peg$parsenotNullableTypeOperator();
        if (s0 === peg$FAILED) {
          s0 = peg$parsevariadicTypeOperator();
          if (s0 === peg$FAILED) {
            s0 = peg$parseoptionalTypeOperator();
          }
        }
      }

      return s0;
    }

    function peg$parsemodifiee() {
      var s0;

      s0 = peg$parsefuncTypeExpr();
      if (s0 === peg$FAILED) {
        s0 = peg$parserecordTypeExpr();
        if (s0 === peg$FAILED) {
          s0 = peg$parseparenthesisTypeExpr();
          if (s0 === peg$FAILED) {
            s0 = peg$parseanyTypeExpr();
            if (s0 === peg$FAILED) {
              s0 = peg$parseunknownTypeExpr();
              if (s0 === peg$FAILED) {
                s0 = peg$parsemoduleNameExpr();
                if (s0 === peg$FAILED) {
                  s0 = peg$parsetypeNameExpr();
                }
              }
            }
          }
        }
      }

      return s0;
    }

    function peg$parsepostfixModifiers() {
      var s0;

      s0 = peg$parseoptionalTypeOperator();
      if (s0 === peg$FAILED) {
        s0 = peg$parsearrayOfGenericTypeOperatorJsDocFlavored();
        if (s0 === peg$FAILED) {
          s0 = peg$parsegenericTypeExpr();
          if (s0 === peg$FAILED) {
            s0 = peg$parsememberTypeExpr();
            if (s0 === peg$FAILED) {
              s0 = peg$parseinnerMemberTypeExpr();
              if (s0 === peg$FAILED) {
                s0 = peg$parseinstanceMemberTypeExpr();
                if (s0 === peg$FAILED) {
                  s0 = peg$parseunionTypeExpr();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parsenullableTypeOperator();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parsenotNullableTypeOperator();
                    }
                  }
                }
              }
            }
          }
        }
      }

      return s0;
    }

    function peg$parseparenthesisTypeExpr() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c3;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c4); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsetypeExpr();
          if (s3 !== peg$FAILED) {
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 41) {
                s5 = peg$c5;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c6); }
              }
              if (s5 !== peg$FAILED) {
                peg$reportedPos = s0;
                s1 = peg$c7(s3);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$c0;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c0;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c0;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parsetypeNameExpr() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = peg$currPos;
      s2 = peg$parsejsIdentifier();
      if (s2 !== peg$FAILED) {
        s2 = input.substring(s1, peg$currPos);
      }
      s1 = s2;
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c8(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parsejsIdentifier() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      if (peg$c9.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c10); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        if (peg$c11.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c12); }
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          if (peg$c11.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c12); }
          }
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parsemoduleNameExpr() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      if (input.substr(peg$currPos, 6) === peg$c13) {
        s1 = peg$c13;
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c14); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s3 = peg$c15;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c16); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
              s5 = peg$currPos;
              s6 = peg$parsemoduleNameFilePathPart();
              if (s6 !== peg$FAILED) {
                s6 = input.substring(s5, peg$currPos);
              }
              s5 = s6;
              if (s5 !== peg$FAILED) {
                peg$reportedPos = s0;
                s1 = peg$c17(s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$c0;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c0;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c0;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parsemoduleNameFilePathPart() {
      var s0, s1;

      s0 = [];
      if (peg$c18.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c19); }
      }
      if (s1 !== peg$FAILED) {
        while (s1 !== peg$FAILED) {
          s0.push(s1);
          if (peg$c18.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c19); }
          }
        }
      } else {
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parseanyTypeExpr() {
      var s0, s1;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 42) {
        s1 = peg$c20;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c21); }
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c22();
      }
      s0 = s1;

      return s0;
    }

    function peg$parseunknownTypeExpr() {
      var s0, s1;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 63) {
        s1 = peg$c23;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c24); }
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c25();
      }
      s0 = s1;

      return s0;
    }

    function peg$parsefuncTypeExpr() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13;

      s0 = peg$currPos;
      if (input.substr(peg$currPos, 8) === peg$c26) {
        s1 = peg$c26;
        peg$currPos += 8;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c27); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 40) {
            s3 = peg$c3;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c4); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
              s5 = peg$parsefuncTypeExprParamsPart();
              if (s5 !== peg$FAILED) {
                s6 = peg$parse_();
                if (s6 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s7 = peg$c5;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c6); }
                  }
                  if (s7 !== peg$FAILED) {
                    s8 = peg$parse_();
                    if (s8 !== peg$FAILED) {
                      s9 = peg$currPos;
                      s10 = peg$parse_();
                      if (s10 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 58) {
                          s11 = peg$c15;
                          peg$currPos++;
                        } else {
                          s11 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c16); }
                        }
                        if (s11 !== peg$FAILED) {
                          s12 = peg$parse_();
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parsetypeExpr();
                            if (s13 !== peg$FAILED) {
                              s10 = [s10, s11, s12, s13];
                              s9 = s10;
                            } else {
                              peg$currPos = s9;
                              s9 = peg$c0;
                            }
                          } else {
                            peg$currPos = s9;
                            s9 = peg$c0;
                          }
                        } else {
                          peg$currPos = s9;
                          s9 = peg$c0;
                        }
                      } else {
                        peg$currPos = s9;
                        s9 = peg$c0;
                      }
                      if (s9 === peg$FAILED) {
                        s9 = peg$c28;
                      }
                      if (s9 !== peg$FAILED) {
                        peg$reportedPos = s0;
                        s1 = peg$c29(s5, s9);
                        s0 = s1;
                      } else {
                        peg$currPos = s0;
                        s0 = peg$c0;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$c0;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c0;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c0;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c0;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c0;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c0;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parsefuncTypeExprParamsPart() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parsefuncTypeExprParam();
      if (s1 === peg$FAILED) {
        s1 = peg$c28;
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 44) {
            s5 = peg$c30;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c31); }
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsefuncTypeExprParam();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$c0;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$c0;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$c0;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$c0;
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 44) {
              s5 = peg$c30;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c31); }
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parse_();
              if (s6 !== peg$FAILED) {
                s7 = peg$parsefuncTypeExprParam();
                if (s7 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$c0;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$c0;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$c0;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$c0;
          }
        }
        if (s2 !== peg$FAILED) {
          peg$reportedPos = s0;
          s1 = peg$c32(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parsefuncTypeExprParam() {
      var s0;

      s0 = peg$parsethisValueTypeModifier();
      if (s0 === peg$FAILED) {
        s0 = peg$parsenewTypeModifier();
        if (s0 === peg$FAILED) {
          s0 = peg$parsenoModifier();
        }
      }

      return s0;
    }

    function peg$parsethisValueTypeModifier() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      if (input.substr(peg$currPos, 4) === peg$c33) {
        s1 = peg$c33;
        peg$currPos += 4;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c34); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s3 = peg$c15;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c16); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
              s5 = peg$parsetypeExpr();
              if (s5 !== peg$FAILED) {
                peg$reportedPos = s0;
                s1 = peg$c35(s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$c0;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c0;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c0;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parsenewTypeModifier() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      if (input.substr(peg$currPos, 3) === peg$c36) {
        s1 = peg$c36;
        peg$currPos += 3;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c37); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s3 = peg$c15;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c16); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
              s5 = peg$parsetypeExpr();
              if (s5 !== peg$FAILED) {
                peg$reportedPos = s0;
                s1 = peg$c38(s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$c0;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c0;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c0;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parsenoModifier() {
      var s0, s1;

      s0 = peg$currPos;
      s1 = peg$parsetypeExpr();
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c39(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parserecordTypeExpr() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 123) {
        s1 = peg$c40;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c41); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          s3 = peg$parserecordEntry();
          if (s3 === peg$FAILED) {
            s3 = peg$c28;
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$currPos;
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 44) {
                s7 = peg$c30;
                peg$currPos++;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c31); }
              }
              if (s7 !== peg$FAILED) {
                s8 = peg$parse_();
                if (s8 !== peg$FAILED) {
                  s9 = peg$parserecordEntry();
                  if (s9 !== peg$FAILED) {
                    s6 = [s6, s7, s8, s9];
                    s5 = s6;
                  } else {
                    peg$currPos = s5;
                    s5 = peg$c0;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$c0;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$c0;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$c0;
            }
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$currPos;
              s6 = peg$parse_();
              if (s6 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 44) {
                  s7 = peg$c30;
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c31); }
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parse_();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parserecordEntry();
                    if (s9 !== peg$FAILED) {
                      s6 = [s6, s7, s8, s9];
                      s5 = s6;
                    } else {
                      peg$currPos = s5;
                      s5 = peg$c0;
                    }
                  } else {
                    peg$currPos = s5;
                    s5 = peg$c0;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$c0;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$c0;
              }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 125) {
                  s6 = peg$c42;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c43); }
                }
                if (s6 !== peg$FAILED) {
                  peg$reportedPos = s0;
                  s1 = peg$c44(s3, s4);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$c0;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c0;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c0;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c0;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parserecordEntry() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      s1 = peg$currPos;
      s2 = peg$parsejsIdentifier();
      if (s2 !== peg$FAILED) {
        s2 = input.substring(s1, peg$currPos);
      }
      s1 = s2;
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        s3 = peg$parse_();
        if (s3 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s4 = peg$c15;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c16); }
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parse_();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsetypeExpr();
              if (s6 !== peg$FAILED) {
                s3 = [s3, s4, s5, s6];
                s2 = s3;
              } else {
                peg$currPos = s2;
                s2 = peg$c0;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$c0;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$c0;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$c0;
        }
        if (s2 === peg$FAILED) {
          s2 = peg$c28;
        }
        if (s2 !== peg$FAILED) {
          peg$reportedPos = s0;
          s1 = peg$c45(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parsenullableTypeOperator() {
      var s0, s1;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 63) {
        s1 = peg$c23;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c24); }
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c46();
      }
      s0 = s1;

      return s0;
    }

    function peg$parsenotNullableTypeOperator() {
      var s0, s1;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 33) {
        s1 = peg$c47;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c48); }
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c49();
      }
      s0 = s1;

      return s0;
    }

    function peg$parseoptionalTypeOperator() {
      var s0, s1;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 61) {
        s1 = peg$c50;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c51); }
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c52();
      }
      s0 = s1;

      return s0;
    }

    function peg$parsevariadicTypeOperator() {
      var s0, s1;

      s0 = peg$currPos;
      if (input.substr(peg$currPos, 3) === peg$c53) {
        s1 = peg$c53;
        peg$currPos += 3;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c54); }
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c55();
      }
      s0 = s1;

      return s0;
    }

    function peg$parseunionTypeExpr() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parseunionTypeOperator();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsetypeExpr();
          if (s3 !== peg$FAILED) {
            peg$reportedPos = s0;
            s1 = peg$c56(s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$c0;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parseunionTypeOperator() {
      var s0;

      if (input.charCodeAt(peg$currPos) === 124) {
        s0 = peg$c57;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c58); }
      }

      return s0;
    }

    function peg$parsememberTypeExpr() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parsememberTypeOperator();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsememberName();
          if (s3 !== peg$FAILED) {
            peg$reportedPos = s0;
            s1 = peg$c59(s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$c0;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parsememberTypeOperator() {
      var s0;

      if (input.charCodeAt(peg$currPos) === 46) {
        s0 = peg$c60;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c61); }
      }

      return s0;
    }

    function peg$parsememberName() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = peg$currPos;
      s2 = peg$parsejsIdentifier();
      if (s2 !== peg$FAILED) {
        s2 = input.substring(s1, peg$currPos);
      }
      s1 = s2;
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c62(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parseinnerMemberTypeExpr() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parseinnerMemberTypeOperator();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsememberName();
          if (s3 !== peg$FAILED) {
            peg$reportedPos = s0;
            s1 = peg$c63(s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$c0;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parseinnerMemberTypeOperator() {
      var s0;

      if (input.charCodeAt(peg$currPos) === 126) {
        s0 = peg$c64;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c65); }
      }

      return s0;
    }

    function peg$parseinstanceMemberTypeExpr() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parseinstanceMemberTypeOperator();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsememberName();
          if (s3 !== peg$FAILED) {
            peg$reportedPos = s0;
            s1 = peg$c66(s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$c0;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parseinstanceMemberTypeOperator() {
      var s0;

      if (input.charCodeAt(peg$currPos) === 35) {
        s0 = peg$c67;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c68); }
      }

      return s0;
    }

    function peg$parsegenericTypeExpr() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parsegenericTypeStartToken();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsegenericTypeExprObjectivePart();
          if (s3 !== peg$FAILED) {
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
              s5 = peg$parsegenericTypeEndToken();
              if (s5 !== peg$FAILED) {
                peg$reportedPos = s0;
                s1 = peg$c69(s3);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$c0;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c0;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c0;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parsegenericTypeStartToken() {
      var s0;

      s0 = peg$parsegenericTypeEcmaScriptFlavoredStartToken();
      if (s0 === peg$FAILED) {
        s0 = peg$parsegenericTypeTypeScriptFlavoredStartToken();
      }

      return s0;
    }

    function peg$parsegenericTypeEcmaScriptFlavoredStartToken() {
      var s0;

      if (input.substr(peg$currPos, 2) === peg$c70) {
        s0 = peg$c70;
        peg$currPos += 2;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c71); }
      }

      return s0;
    }

    function peg$parsegenericTypeTypeScriptFlavoredStartToken() {
      var s0;

      if (input.charCodeAt(peg$currPos) === 60) {
        s0 = peg$c72;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c73); }
      }

      return s0;
    }

    function peg$parsegenericTypeEndToken() {
      var s0;

      if (input.charCodeAt(peg$currPos) === 62) {
        s0 = peg$c74;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c75); }
      }

      return s0;
    }

    function peg$parsegenericTypeExprObjectivePart() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parsetypeExpr();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 44) {
            s5 = peg$c30;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c31); }
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsetypeExpr();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$c0;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$c0;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$c0;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$c0;
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 44) {
              s5 = peg$c30;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c31); }
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parse_();
              if (s6 !== peg$FAILED) {
                s7 = peg$parsetypeExpr();
                if (s7 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$c0;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$c0;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$c0;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$c0;
          }
        }
        if (s2 !== peg$FAILED) {
          peg$reportedPos = s0;
          s1 = peg$c76(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$c0;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c0;
      }

      return s0;
    }

    function peg$parsearrayOfGenericTypeOperatorJsDocFlavored() {
      var s0, s1;

      s0 = peg$currPos;
      if (input.substr(peg$currPos, 2) === peg$c77) {
        s1 = peg$c77;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c78); }
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c79();
      }
      s0 = s1;

      return s0;
    }

    function peg$parse_() {
      var s0, s1;

      s0 = [];
      if (peg$c80.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c81); }
      }
      while (s1 !== peg$FAILED) {
        s0.push(s1);
        if (peg$c80.test(input.charAt(peg$currPos))) {
          s1 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c81); }
        }
      }

      return s0;
    }


      var lodash = require('lodash');
      var NodeType = require('../lib/NodeType.js');

      var OperatorType = {
        UNION: 0,
        MEMBER: 1,
        GENERIC: 2,
        ARRAY: 3,
        OPTIONAL: 4,
        NULLABLE: 5,
        NOT_NULLABLE: 6,
        VARIADIC: 7,
        INNER_MEMBER: 8,
        INSTANCE_MEMBER: 9,
      };

      var FunctionModifierType = {
        NONE: 0,
        CONTEXT: 1,
        NEW: 2,
      };

      function reverse(array) {
        var reversed = [].concat(array);
        reversed.reverse();
        return reversed;
      }

      function buildByFirstAndRest(first, restsWithComma, restIndex) {
        if (!first) return [];

        var rests = restsWithComma ? lodash.pluck(restsWithComma, restIndex) : [];
        return [first].concat(rests);
      }

      function reportSemanticIssue(msg) {
        console.warn(msg);
      }


    peg$result = peg$startRuleFunction();

    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
      return peg$result;
    } else {
      if (peg$result !== peg$FAILED && peg$currPos < input.length) {
        peg$fail({ type: "end", description: "end of input" });
      }

      throw peg$buildException(null, peg$maxFailExpected, peg$maxFailPos);
    }
  }

  return {
    SyntaxError: SyntaxError,
    parse:       parse
  };
})();