/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* Copyright 2012 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

define('io.ox/core/pdf/pdfcustomstyle', [
], function () {

    'use strict';

    // optimised CSS custom property getter/setter
    var CustomStyle = (function CustomStyleClosure() {

        // As noted on: http://www.zachstronaut.com/posts/2009/02/17/
        // animate-css-transforms-firefox-webkit.html
        // in some versions of IE9 it is critical that ms appear in this
        // list
        // before Moz
        var prefixes = ['ms', 'Moz', 'Webkit', 'O'];
        var _cache = {};

        function CustomStyle() {
        }

        CustomStyle.getProp = function get(propName, element) {
            // check cache only when no element is given
            if (arguments.length === 1 && typeof _cache[propName] === 'string') {
                return _cache[propName];
            }

            element = element || document.documentElement;
            var style = element.style, prefixed, uPropName;

            // test standard property first
            if (typeof style[propName] === 'string') {
                return (_cache[propName] = propName);
            }

            // capitalize
            uPropName = propName.charAt(0).toUpperCase() + propName.slice(1);

            // test vendor specific properties
            for (var i = 0, l = prefixes.length; i < l; i++) {
                prefixed = prefixes[i] + uPropName;
                if (typeof style[prefixed] === 'string') {
                    return (_cache[propName] = prefixed);
                }
            }

            // if all fails then set to undefined
            return (_cache[propName] = 'undefined');
        };

        CustomStyle.setProp = function set(propName, element, str) {
            var prop = this.getProp(propName);
            if (prop !== 'undefined') {
                element.style[prop] = str;
            }
        };

        return CustomStyle;
    })();

    return CustomStyle;
});
