/**
 * A specialized version of `_.sum` for arrays without support for iteratees.
 *
 * @private
 * @param {Array} array The array to iterate over.
 * @returns {number} Returns the sum.
 */
function arraySum(array) {
  var length = array.length,
      result = 0;

  while (length--) {
    result += +array[length] || 0;
  }
  return result;
}

module.exports = arraySum;
