(function (root, factory) {
    'use strict';

    /*global define*/
    if (typeof define === 'function' && define.amd) {
        define(['moment'], factory);                 // AMD
    } else if (typeof exports === 'object') {
        module.exports = factory(require('moment')); // Node
    } else {
        factory(root.moment);                        // Browser
    }
}(this, function (moment) {
    'use strict';

    // Do not load moment-interval a second time.
    if (moment.fn.formatInterval !== undefined) { return moment; }

    var regex = /(G+|y+|Y+|M+|w+|W+|D+|d+|F+|E+|u+|a+|H+|k+|K+|h+|m+|s+|S+|z+|Z+|v+|V+)|\[((?:[^\[\]]|\[\])+)\]|(\[\])/g;

    /**
     * get formatstring from locale object
     * @param  { Moment }   end     enddate of the interval
     * @param  { Boolean }  time    force time format
     * @return { String }           moment format string
     */
    function getFormat(end, time) {
        var loc = locale[moment.locale()],
            formats = locale.formats,
            f;

        if (time) {
            var is12h = this.localeData().longDateFormat('LT').toLowerCase().indexOf('a') > -1,
                m = moment.localeData().meridiem;
            f = is12h ? loc.hm : loc.Hm;

            if (is12h && (m(this.hours(), this.minutes(), true) !== m(end.hours(), end.minutes(), true))) {
                return formats[f.a];
            } else if (!this.isSame(end, 'hour')) {
                return formats[is12h ? f.h : f.H];
            } else if (!this.isSame(end, 'minute')) {
                return formats[f.m];
            }
            return 'LT';
        } else {
            f = loc.yMMMd;
            if (!this.isSame(end, 'year')) {
                return formats[f.y];
            } else if (!this.isSame(end, 'month')) {
                return formats[f.M];
            } else if (!this.isSame(end, 'day')) {
                return formats[f.d];
            } else {
                return 'llll';
            }
        }
    }

    /**
     * split formatstring and apply them to moment-format
     * @param  { Moment } end    enddate of the interval
     * @param  { String } format moment date foramt string
     * @return { String }        formated date interval
     */
    function formatInterval(end, format) {
        var fields = {}, match;
        regex.lastIndex = 0;
        while ((match = regex.exec(format))) {
            if (!match[1]) continue;
            var letter = match[1].charAt(0);
            if (fields[letter]) break;
            fields[letter] = true;
        }
        if (regex.lastIndex) {
            return this.format(format.slice(0, match.index)) + end.format(format.slice(match.index));
        } else {
            return this.format(format);
        }
    }

    /**
     * define formatInteravl function
     * @param  { Moment }   end         enddate of the interval
     * @param  { String }   dateOrTime  force date or time format (optinal)
     * @return { String }               formated date interval
     */
    moment.fn.formatInterval = function (endMoment, dateOrTime) {

        if (!endMoment) {
            dateOrTime |= 'date';
            return this.format(dateOrTime === 'date' ? 'l' : 'LT');
        }
        // parse to moment
        endMoment = moment(endMoment);

        if (!dateOrTime) {
            dateOrTime = this.isSame(endMoment, 'day') ? 'time' : 'date';
        }
        var format;
        if (dateOrTime !== 'time' && dateOrTime !== 'date') {
            format = locale[moment.locale()].fallback;
            return format.replace('{0}',this.format(dateOrTime)).replace('{1}', endMoment.format(dateOrTime));
        } else {
            format = getFormat.call(this, endMoment, dateOrTime === 'time');

            return formatInterval.call(this, endMoment, format);
        }

    };

    // locale data
    var locale = {"af":{"hm":{"a":0,"h":1,"m":2},"Hm":{"H":3,"m":3},"yMMMd":{"d":4,"M":5,"y":6},"fallback":"{0} – {1}"},"ar-dz":{"hm":{"a":13,"h":14,"m":15},"Hm":{"H":3,"m":3},"yMMMd":{"d":16,"M":17,"y":18},"fallback":"{0} – {1}"},"ar-kw":{"hm":{"a":19,"h":20,"m":21},"Hm":{"H":3,"m":3},"yMMMd":{"d":22,"M":23,"y":24},"fallback":"{0} – {1}"},"ar-ly":{"hm":{"a":25,"h":26,"m":27},"Hm":{"H":3,"m":3},"yMMMd":{"d":28,"M":29,"y":30},"fallback":"{0} – {1}"},"ar-ma":{"hm":{"a":31,"h":32,"m":33},"Hm":{"H":3,"m":3},"yMMMd":{"d":34,"M":35,"y":36},"fallback":"{0} – {1}"},"ar-sa":{"hm":{"a":37,"h":38,"m":39},"Hm":{"H":3,"m":3},"yMMMd":{"d":40,"M":41,"y":42},"fallback":"{0} – {1}"},"ar-tn":{"hm":{"a":43,"h":44,"m":45},"Hm":{"H":3,"m":3},"yMMMd":{"d":46,"M":47,"y":48},"fallback":"{0} – {1}"},"ar":{"hm":{"a":49,"h":50,"m":51},"Hm":{"H":3,"m":3},"yMMMd":{"d":52,"M":53,"y":54},"fallback":"{0} – {1}"},"az":{"hm":{"a":55,"h":56,"m":57},"Hm":{"H":3,"m":3},"yMMMd":{"d":58,"M":59,"y":60},"fallback":"{0} – {1}"},"be":{"hm":{"a":61,"h":62,"m":63},"Hm":{"H":64,"m":64},"yMMMd":{"d":65,"M":66,"y":67},"fallback":"{0} – {1}"},"bg":{"hm":{"a":68,"h":69,"m":70},"Hm":{"H":71,"m":71},"yMMMd":{"d":72,"M":73,"y":74},"fallback":"{0} – {1}"},"bn":{"hm":{"a":75,"h":76,"m":77},"Hm":{"H":3,"m":3},"yMMMd":{"d":78,"M":79,"y":80},"fallback":"{0} – {1}"},"bo":{"hm":{"a":81,"h":82,"m":83},"Hm":{"H":3,"m":3},"yMMMd":{"d":84,"M":85,"y":86},"fallback":"{0} – {1}"},"br":{"hm":{"a":87,"h":88,"m":89},"Hm":{"H":3,"m":3},"yMMMd":{"d":90,"M":91,"y":92},"fallback":"{0} – {1}"},"bs":{"hm":{"a":93,"h":94,"m":95},"Hm":{"H":96,"m":96},"yMMMd":{"d":97,"M":98,"y":99},"fallback":"{0} - {1}"},"ca":{"hm":{"a":101,"h":102,"m":103},"Hm":{"H":71,"m":71},"yMMMd":{"d":104,"M":105,"y":106},"fallback":"{0} - {1}"},"cs":{"hm":{"a":107,"h":108,"m":109},"Hm":{"H":110,"m":110},"yMMMd":{"d":111,"M":112,"y":113},"fallback":"{0} – {1}"},"cv":{"hm":{"a":114,"h":115,"m":116},"Hm":{"H":3,"m":3},"yMMMd":{"d":117,"M":118,"y":119},"fallback":"{0} – {1}"},"cy":{"hm":{"a":120,"h":121,"m":122},"Hm":{"H":3,"m":3},"yMMMd":{"d":123,"M":124,"y":125},"fallback":"{0} – {1}"},"da":{"hm":{"a":126,"h":127,"m":128},"Hm":{"H":64,"m":64},"yMMMd":{"d":129,"M":130,"y":131},"fallback":"{0} – {1}"},"de-at":{"hm":{"a":132,"h":133,"m":134},"Hm":{"H":135,"m":136},"yMMMd":{"d":137,"M":138,"y":139},"fallback":"{0} – {1}"},"de-ch":{"hm":{"a":140,"h":141,"m":142},"Hm":{"H":143,"m":144},"yMMMd":{"d":145,"M":146,"y":147},"fallback":"{0} – {1}"},"de":{"hm":{"a":148,"h":149,"m":150},"Hm":{"H":151,"m":152},"yMMMd":{"d":153,"M":154,"y":155},"fallback":"{0} – {1}"},"dv":{"hm":{"a":156,"h":157,"m":158},"Hm":{"H":3,"m":3},"yMMMd":{"d":159,"M":160,"y":161},"fallback":"{0} – {1}"},"el":{"hm":{"a":162,"h":163,"m":164},"Hm":{"H":3,"m":3},"yMMMd":{"d":165,"M":166,"y":167},"fallback":"{0} - {1}"},"en-au":{"yMMMd":{"d":168,"M":169,"y":170},"hm":{"a":171,"h":172,"m":173},"Hm":{"H":96,"m":96},"fallback":"{0} – {1}"},"en-ca":{"yMMMd":{"d":174,"M":175,"y":176},"hm":{"a":177,"h":178,"m":179},"Hm":{"H":96,"m":96},"fallback":"{0} – {1}"},"en-gb":{"yMMMd":{"d":180,"M":181,"y":182},"hm":{"a":183,"h":184,"m":185},"Hm":{"H":96,"m":96},"fallback":"{0} – {1}"},"en-ie":{"yMMMd":{"d":186,"M":187,"y":188},"hm":{"a":189,"h":190,"m":191},"Hm":{"H":96,"m":96},"fallback":"{0} – {1}"},"en-nz":{"yMMMd":{"d":192,"M":193,"y":194},"hm":{"a":195,"h":196,"m":197},"Hm":{"H":96,"m":96},"fallback":"{0} – {1}"},"eo":{"hm":{"h":198,"m":199},"Hm":{"H":3,"m":3},"yMMMd":{"d":200,"M":201,"y":202},"fallback":"{0} – {1}"},"es-do":{"yMMMd":{"d":203,"M":204,"y":205},"hm":{"a":206,"h":207,"m":208},"Hm":{"H":110,"m":110},"fallback":"{0}–{1}"},"es":{"hm":{"a":209,"h":210,"m":211},"Hm":{"H":110,"m":110},"yMMMd":{"d":212,"M":213,"y":214},"fallback":"{0}–{1}"},"et":{"hm":{"a":215,"h":216,"m":217},"Hm":{"H":3,"m":3},"yMMMd":{"d":218,"M":219,"y":220},"fallback":"{0}–{1}"},"eu":{"hm":{"a":221,"h":222,"m":223},"Hm":{"H":3,"m":3},"yMMMd":{"d":224,"M":225,"y":226},"fallback":"{0} – {1}"},"fa":{"hm":{"a":227,"h":228,"m":229},"Hm":{"H":230,"m":230},"yMMMd":{"d":231,"M":232,"y":233},"fallback":"{0} تا {1}"},"fi":{"hm":{"a":236,"h":237,"m":238},"Hm":{"H":239,"m":239},"yMMMd":{"d":240,"M":241,"y":242},"fallback":"{0}–{1}"},"fo":{"hm":{"a":243,"h":244,"m":245},"Hm":{"H":3,"m":3},"yMMMd":{"d":246,"M":247,"y":248},"fallback":"{0} – {1}"},"fr-ca":{"Hm":{"H":249,"m":250},"hm":{"a":251,"h":252,"m":253},"yMMMd":{"d":254,"M":255,"y":256},"fallback":"{0} – {1}"},"fr-ch":{"hm":{"a":257,"h":258,"m":259},"Hm":{"H":96,"m":96},"yMMMd":{"d":260,"M":261,"y":262},"fallback":"{0} – {1}"},"fr":{"hm":{"a":263,"h":264,"m":265},"Hm":{"H":96,"m":96},"yMMMd":{"d":266,"M":267,"y":268},"fallback":"{0} – {1}"},"fy":{"hm":{"a":269,"h":270,"m":271},"Hm":{"H":3,"m":3},"yMMMd":{"d":272,"M":273,"y":274},"fallback":"{0} - {1}"},"gd":{"hm":{"a":275,"h":276,"m":277},"Hm":{"H":96,"m":96},"yMMMd":{"d":278,"M":279,"y":280},"fallback":"{0} – {1}"},"gl":{"hm":{"a":281,"h":282,"m":283},"Hm":{"H":3,"m":3},"yMMMd":{"d":284,"M":285,"y":286},"fallback":"{0} – {1}"},"gom-latn":{"hm":{"a":287,"h":288,"m":289},"Hm":{"H":3,"m":3},"yMMMd":{"d":290,"M":291,"y":292},"fallback":"{0} – {1}"},"he":{"hm":{"a":293,"h":294,"m":295},"Hm":{"H":110,"m":110},"yMMMd":{"d":296,"M":297,"y":298},"fallback":"{0} – {1}"},"hi":{"hm":{"a":299,"h":300,"m":301},"Hm":{"H":3,"m":3},"yMMMd":{"d":302,"M":303,"y":304},"fallback":"{0} – {1}"},"hr":{"hm":{"a":305,"h":306,"m":307},"Hm":{"H":96,"m":96},"yMMMd":{"d":308,"M":309,"y":310},"fallback":"{0} – {1}"},"hu":{"hm":{"a":311,"h":312,"m":313},"Hm":{"H":110,"m":110},"yMMMd":{"d":314,"M":315,"y":316},"fallback":"{0} – {1}"},"hy-am":{"hm":{"a":317,"h":318,"m":319},"Hm":{"H":110,"m":110},"yMMMd":{"d":320,"M":321,"y":322},"fallback":"{0} – {1}"},"id":{"hm":{"a":323,"h":324,"m":325},"Hm":{"H":64,"m":64},"yMMMd":{"d":326,"M":327,"y":328},"fallback":"{0} – {1}"},"is":{"hm":{"a":329,"h":330,"m":331},"Hm":{"H":3,"m":3},"yMMMd":{"d":332,"M":333,"y":334},"fallback":"{0} – {1}"},"it":{"hm":{"a":335,"h":336,"m":337},"Hm":{"H":3,"m":3},"yMMMd":{"d":338,"M":339,"y":340},"fallback":"{0} - {1}"},"ja":{"hm":{"a":341,"h":342,"m":343},"Hm":{"H":344,"m":344},"yMMMd":{"d":345,"M":346,"y":347},"fallback":"{0}～{1}"},"jv":{"hm":{"a":349,"h":350,"m":351},"Hm":{"H":3,"m":3},"yMMMd":{"d":352,"M":353,"y":354},"fallback":"{0} – {1}"},"ka":{"hm":{"a":355,"h":356,"m":357},"Hm":{"H":3,"m":3},"yMMMd":{"d":358,"M":359,"y":360},"fallback":"{0} – {1}"},"kk":{"hm":{"a":361,"h":362,"m":363},"Hm":{"H":3,"m":3},"yMMMd":{"d":364,"M":365,"y":366},"fallback":"{0} - {1}"},"km":{"hm":{"a":367,"h":368,"m":369},"Hm":{"H":96,"m":96},"yMMMd":{"d":370,"M":371,"y":372},"fallback":"{0} - {1}"},"kn":{"hm":{"a":373,"h":374,"m":375},"Hm":{"H":96,"m":96},"yMMMd":{"d":376,"M":377,"y":378},"fallback":"{0} – {1}"},"ko":{"hm":{"a":379,"h":380,"m":381},"Hm":{"H":382,"m":382},"yMMMd":{"d":383,"M":384,"y":385},"fallback":"{0} ~ {1}"},"ky":{"hm":{"a":387,"h":388,"m":389},"Hm":{"H":3,"m":3},"yMMMd":{"d":390,"M":391,"y":392},"fallback":"{0} - {1}"},"lb":{"hm":{"a":393,"h":394,"m":395},"Hm":{"H":3,"m":3},"yMMMd":{"d":396,"M":397,"y":398},"fallback":"{0} - {1}"},"lo":{"hm":{"a":399,"h":400,"m":401},"Hm":{"H":3,"m":3},"yMMMd":{"d":402,"M":403,"y":404},"fallback":"{0} – {1}"},"lt":{"hm":{"a":405,"h":406,"m":407},"Hm":{"H":3,"m":3},"yMMMd":{"d":408,"M":409,"y":410},"fallback":"{0} – {1}"},"lv":{"hm":{"a":411,"h":412,"m":413},"Hm":{"H":3,"m":3},"yMMMd":{"d":414,"M":415,"y":416},"fallback":"{0} - {1}"},"me":{"hm":{"a":417,"h":418,"m":419},"Hm":{"H":3,"m":3},"yMMMd":{"d":420,"M":421,"y":422},"fallback":"{0} – {1}"},"mi":{"hm":{"a":423,"h":424,"m":425},"Hm":{"H":3,"m":3},"yMMMd":{"d":426,"M":427,"y":428},"fallback":"{0} – {1}"},"mk":{"hm":{"a":429,"h":430,"m":431},"Hm":{"H":3,"m":3},"yMMMd":{"d":432,"M":433,"y":434},"fallback":"{0} - {1}"},"ml":{"hm":{"a":435,"h":436,"m":437},"Hm":{"H":96,"m":96},"yMMMd":{"d":438,"M":439,"y":440},"fallback":"{0} - {1}"},"mr":{"hm":{"a":441,"h":442,"m":443},"Hm":{"H":96,"m":96},"yMMMd":{"d":444,"M":445,"y":446},"fallback":"{0} – {1}"},"ms-my":{"hm":{"a":447,"h":448,"m":449},"Hm":{"H":3,"m":3},"yMMMd":{"d":450,"M":451,"y":452},"fallback":"{0} – {1}"},"ms":{"hm":{"a":453,"h":454,"m":455},"Hm":{"H":3,"m":3},"yMMMd":{"d":456,"M":457,"y":458},"fallback":"{0} – {1}"},"my":{"hm":{"a":459,"h":460,"m":461},"Hm":{"H":96,"m":96},"yMMMd":{"d":462,"M":463,"y":464},"fallback":"{0} – {1}"},"nb":{"hm":{"a":465,"h":466,"m":467},"Hm":{"H":3,"m":3},"yMMMd":{"d":468,"M":469,"y":470},"fallback":"{0}–{1}"},"ne":{"hm":{"a":471,"h":472,"m":473},"Hm":{"H":3,"m":3},"yMMMd":{"d":474,"M":475,"y":476},"fallback":"{0} – {1}"},"nl-be":{"hm":{"a":477,"h":478,"m":479},"Hm":{"H":3,"m":3},"yMMMd":{"d":480,"M":481,"y":482},"fallback":"{0} - {1}"},"nl":{"hm":{"a":483,"h":484,"m":485},"Hm":{"H":3,"m":3},"yMMMd":{"d":486,"M":487,"y":488},"fallback":"{0} - {1}"},"nn":{"hm":{"a":489,"h":490,"m":491},"Hm":{"H":3,"m":3},"yMMMd":{"d":492,"M":493,"y":494},"fallback":"{0} – {1}"},"pa-in":{"hm":{"a":495,"h":496,"m":497},"Hm":{"H":3,"m":3},"yMMMd":{"d":498,"M":499,"y":500},"fallback":"{0} – {1}"},"pl":{"hm":{"a":501,"h":502,"m":503},"Hm":{"H":3,"m":3},"yMMMd":{"d":504,"M":505,"y":506},"fallback":"{0} – {1}"},"pt-br":{"hm":{"a":507,"h":508,"m":509},"Hm":{"H":96,"m":96},"yMMMd":{"d":510,"M":511,"y":512},"fallback":"{0} - {1}"},"pt":{"hm":{"a":513,"h":514,"m":515},"Hm":{"H":96,"m":96},"yMMMd":{"d":516,"M":517,"y":518},"fallback":"{0} - {1}"},"ro":{"hm":{"a":519,"h":520,"m":521},"Hm":{"H":3,"m":3},"yMMMd":{"d":522,"M":523,"y":524},"fallback":"{0} – {1}"},"ru":{"hm":{"a":525,"h":526,"m":527},"Hm":{"H":110,"m":110},"yMMMd":{"d":528,"M":529,"y":530},"fallback":"{0} – {1}"},"sd":{"hm":{"a":531,"h":532,"m":533},"Hm":{"H":3,"m":3},"yMMMd":{"d":534,"M":535,"y":536},"fallback":"{0} – {1}"},"se":{"hm":{"a":537,"h":538,"m":539},"Hm":{"H":3,"m":3},"yMMMd":{"d":540,"M":541,"y":542},"fallback":"{0} – {1}"},"si":{"hm":{"a":543,"h":544,"m":545},"Hm":{"H":64,"m":64},"yMMMd":{"d":546,"M":547,"y":548},"fallback":"{0} – {1}"},"sk":{"hm":{"a":549,"h":550,"m":551},"Hm":{"H":71,"m":71},"yMMMd":{"d":552,"M":553,"y":554},"fallback":"{0} – {1}"},"sl":{"hm":{"a":555,"h":556,"m":557},"Hm":{"H":3,"m":3},"yMMMd":{"d":558,"M":559,"y":560},"fallback":"{0}–{1}"},"sq":{"hm":{"a":561,"h":562,"m":563},"Hm":{"H":96,"m":96},"yMMMd":{"d":564,"M":565,"y":566},"fallback":"{0} - {1}"},"sr-cyrl":{"hm":{"a":567,"h":568,"m":569},"Hm":{"H":3,"m":3},"yMMMd":{"d":570,"M":571,"y":572},"fallback":"{0} – {1}"},"sr":{"hm":{"a":573,"h":574,"m":575},"Hm":{"H":3,"m":3},"yMMMd":{"d":576,"M":577,"y":578},"fallback":"{0} – {1}"},"ss":{"hm":{"a":579,"h":580,"m":581},"Hm":{"H":3,"m":3},"yMMMd":{"d":582,"M":583,"y":584},"fallback":"{0} – {1}"},"sv":{"hm":{"a":585,"h":586,"m":587},"Hm":{"H":3,"m":3},"yMMMd":{"d":588,"M":589,"y":590},"fallback":"{0} – {1}"},"sw":{"hm":{"a":591,"h":592,"m":593},"Hm":{"H":96,"m":96},"yMMMd":{"d":594,"M":595,"y":596},"fallback":"{0} – {1}"},"ta":{"hm":{"a":597,"h":598,"m":599},"Hm":{"H":96,"m":96},"yMMMd":{"d":600,"M":601,"y":602},"fallback":"{0} – {1}"},"te":{"hm":{"a":603,"h":604,"m":605},"Hm":{"H":3,"m":3},"yMMMd":{"d":606,"M":607,"y":608},"fallback":"{0} – {1}"},"tet":{"hm":{"a":609,"h":610,"m":611},"Hm":{"H":3,"m":3},"yMMMd":{"d":612,"M":613,"y":614},"fallback":"{0} – {1}"},"th":{"hm":{"a":615,"h":616,"m":617},"Hm":{"H":618,"m":618},"yMMMd":{"d":619,"M":620,"y":621},"fallback":"{0} – {1}"},"tl-ph":{"hm":{"a":622,"h":623,"m":624},"Hm":{"H":3,"m":3},"yMMMd":{"d":625,"M":626,"y":627},"fallback":"{0} – {1}"},"tlh":{"hm":{"a":628,"h":629,"m":630},"Hm":{"H":3,"m":3},"yMMMd":{"d":631,"M":632,"y":633},"fallback":"{0} – {1}"},"tr":{"hm":{"a":634,"h":635,"m":636},"Hm":{"H":3,"m":3},"yMMMd":{"d":637,"M":638,"y":639},"fallback":"{0} – {1}"},"tzl":{"hm":{"a":640,"h":641,"m":642},"Hm":{"H":3,"m":3},"yMMMd":{"d":643,"M":644,"y":645},"fallback":"{0} – {1}"},"tzm-latn":{"hm":{"a":646,"h":647,"m":648},"Hm":{"H":3,"m":3},"yMMMd":{"d":649,"M":650,"y":651},"fallback":"{0} – {1}"},"tzm":{"hm":{"a":652,"h":653,"m":654},"Hm":{"H":3,"m":3},"yMMMd":{"d":655,"M":656,"y":657},"fallback":"{0} – {1}"},"uk":{"hm":{"a":658,"h":659,"m":660},"Hm":{"H":3,"m":3},"yMMMd":{"d":661,"M":662,"y":663},"fallback":"{0} – {1}"},"ur":{"hm":{"a":664,"h":665,"m":666},"Hm":{"H":3,"m":3},"yMMMd":{"d":667,"M":668,"y":669},"fallback":"{0} – {1}"},"uz-latn":{"hm":{"a":670,"h":671,"m":672},"Hm":{"H":3,"m":3},"yMMMd":{"d":673,"M":674,"y":675},"fallback":"{0} – {1}"},"uz":{"hm":{"a":676,"h":677,"m":678},"Hm":{"H":3,"m":3},"yMMMd":{"d":679,"M":680,"y":681},"fallback":"{0} – {1}"},"vi":{"hm":{"a":682,"h":683,"m":684},"Hm":{"H":3,"m":3},"yMMMd":{"d":685,"M":686,"y":687},"fallback":"{0} - {1}"},"x-pseudo":{"hm":{"a":688,"h":689,"m":690},"Hm":{"H":3,"m":3},"yMMMd":{"d":691,"M":692,"y":693},"fallback":"{0} – {1}"},"yo":{"hm":{"a":694,"h":695,"m":696},"Hm":{"H":3,"m":3},"yMMMd":{"d":697,"M":698,"y":699},"fallback":"{0} – {1}"},"zh-cn":{"hm":{"a":700,"h":701,"m":702},"Hm":{"H":3,"m":3},"yMMMd":{"d":703,"M":704,"y":705},"fallback":"{0} – {1}"},"zh-hk":{"hm":{"a":706,"h":707,"m":708},"Hm":{"H":3,"m":3},"yMMMd":{"d":709,"M":710,"y":711},"fallback":"{0} – {1}"},"zh-tw":{"hm":{"a":712,"h":713,"m":714},"Hm":{"H":3,"m":3},"yMMMd":{"d":715,"M":716,"y":717},"fallback":"{0} – {1}"},"en":{"hm":{"a":718,"h":719,"m":720},"Hm":{"H":96,"m":96},"yMMMd":{"d":721,"M":722,"y":723},"fallback":"{0} – {1}"},"formats":["h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","HH:mm–HH:mm","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","{","0","}"," ","–","1","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM، YYYY","D MMM – D MMM، YYYY","D MMM، YYYY – D MMM، YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM، YYYY","D MMM – D MMM، YYYY","D MMM، YYYY – D MMM، YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM، YYYY","D MMM – D MMM، YYYY","D MMM، YYYY – D MMM، YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM، YYYY","D MMM – D MMM، YYYY","D MMM، YYYY – D MMM، YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM، YYYY","D MMM – D MMM، YYYY","D MMM، YYYY – D MMM، YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM، YYYY","D MMM – D MMM، YYYY","D MMM، YYYY – D MMM، YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM، YYYY","D MMM – D MMM، YYYY","D MMM، YYYY – D MMM، YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","D MMM YYYY – D MMM","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","HH.mm–HH.mm","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","H:mm – H:mm","D.MM – D.MM.YYYY [г].","D.MM – D.MM.YYYY [г].","D.MM.YYYY [г]. – D.MM.YYYY [г].","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM, YYYY","D MMM – D MMM, YYYY","D MMM, YYYY – D MMM, YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","HH:mm – HH:mm","D. – D. MMM YYYY.","D. MMM – D. MMM YYYY.","D. MMM YYYY. – D. MMM YYYY.","-","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","H:mm–H:mm","D.–D. M. YYYY","D. M. – D. M. YYYY","D. M. YYYY – D. M. YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm h:mm A","h:mm – h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM, YYYY – D MMM YYYY","h.mm A–h.mm A","h.mm–h.mm A","h.mm–h.mm A","D.–D. MMM YYYY","D. MMM.–D. MMM YYYY","D. MMM YYYY–D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","HH:mm–HH:mm [Uhr]","HH:mm–HH:mm [Uhr]","D.–D. MMM YYYY","D. MMM – D. MMM YYYY","D. MMM YYYY – D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","HH:mm–HH:mm [Uhr]","HH:mm–HH:mm [Uhr]","D.–D. MMM YYYY","D. MMM – D. MMM YYYY","D. MMM YYYY – D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","HH:mm–HH:mm [Uhr]","HH:mm–HH:mm [Uhr]","D.–D. MMM YYYY","D. MMM – D. MMM YYYY","D. MMM YYYY – D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","DD–DD MMM YYYY","DD MMM – DD MMM YYYY","DD MMM YYYY – DD MMM YYYY","D – D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","MMM D – D, YYYY","MMM D – MMM D, YYYY","MMM D, YYYY – MMM D, YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D – D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D – D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D – D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY-MMM-DD – YYYY-MMM-DD","YYYY-MMM-DD – YYYY-MMM-DD","YYYY-MMM-DD – YYYY-MMM-DD","D – D [de] MMM [de] YYYY","D [de] MMM – D [de] MMM [de] YYYY","D [de] MMM [de] YYYY – D [de] MMM [de] YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D.–D. MMM YYYY","D. MMM – D. MMM YYYY","D. MMM YYYY – D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY([e])[Ho] MMM D–D","YYYY([e])[Ho] MMM D – MMM D","YYYY([e])[Ho] MMM D – YYYY([e])[Ho] MMM D","h:mm A تا h:mm A","h:mm تا h:mm A","h:mm تا h:mm A","H:mm تا H:mm","D تا D MMM YYYY","D LLL تا D MMM YYYY","D MMM YYYY تا D MMM YYYY","ت","ا","h.mm A – h.mm A","h.mm–h.mm A","h.mm–h.mm A","H.mm–H.mm","D.–D. MMMM YYYY","D. MMMM – D. MMMM YYYY","D. MMMM YYYY – D. MMMM YYYY","h:mm A–h:mm A","h:mm–h:mm A","h:mm–h:mm A","D.–D. MMM YYYY","DD. MMM–DD. MMM YYYY","DD. MMM YYYY–DD. MMM YYYY","H [h] mm – H [h] mm","H [h] mm – H [h] mm","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mmA – h:mmA","h:mm – h:mmA","h:mm – h:mmA","D – D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D [de] MMMM [de] YYYY","D MMM – D MMM [de] YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D בMMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","DD. – DD. MMM YYYY.","DD. MMM – DD. MMM YYYY.","DD. MMM YYYY. – DD. MMM YYYY.","A h:mm – A h:mm","A h:mm–h:mm","A h:mm–h:mm","YYYY. MMM D–D.","YYYY. MMM D. – MMM D.","YYYY. MMM D. – YYYY. MMM D.","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","DD–DD MMM, YYYY թ.","DD MMM – DD MMM, YYYY թ.","DD MMM, YYYY թ․ – DD MMM, YYYY թ.","h.mm A – h.mm A","h.mm–h.mm A","h.mm–h.mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D.–D. MMM YYYY","D. MMM – D. MMM YYYY","D. MMM YYYY – D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","DD–DD MMM YYYY","DD MMM – DD MMM YYYY","DD MMM YYYY – DD MMM YYYY","Ah時mm分～Ah時mm分","Ah時mm分～h時mm分","Ah時mm分～h時mm分","H時mm分～H時mm分","YYYY年M月D日～D日","YYYY年M月D日～M月D日","YYYY年M月D日～YYYY年M月D日","～","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM, YYYY","DD MMM. – DD MMM. YYYY","DD MMM. YYYY – D MMM. YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY [ж]. D–D MMM","YYYY [ж]. D MMM – D MMM","YYYY [ж]. D MMM – YYYY [ж]. D MMM","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D – D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm – h:mm A","MMM D–D,YYYY","D MMM – D MMM, YYYY","D, MMM, YYYY – D, MMM, YYYY","A h:mm ~ A h:mm","A h:mm~h:mm","A h:mm~h:mm","HH:mm ~ HH:mm","YYYY년 M월 D일~D일","YYYY년 M월 D일 ~ M월 D일","YYYY년 M월 D일 ~ YYYY년 M월 D일","~","A h:mm – A h:mm","A h:mm–h:mm","A h:mm–h:mm","D–D-MMM YYYY-[ж].","D-MMM – D-MMM YYYY-[ж].","D-MMM YYYY-[ж]. - D-MMM YYYY-[ж].","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D.–D. MMM YYYY","D. MMM – D. MMM YYYY","D. MMM YYYY – D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D/MM/YYYY – D/MM/YYYY","D/MM/YYYY – D/MM","DD/MM/YYYY – DD/MM/YYYY","hh:mm A–hh:mm A","hh:mm–hh:mm A","hh:mm–hh:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY. [gada] D.–D. MMM","YYYY. [gada] D. MMM – D. MMM","YYYY. [gada] D. MMM – YYYY. [gada] D. MMM","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","DD–DD MMM YYYY","DD MMM – DD MMM YYYY","DD MMM YYYY – DD MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","YYYY MMM D – D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D – D MMM, YYYY","D MMM – D MMM, YYYY","D MMM, YYYY – D MMM, YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM, YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM, YYYY","D MMM YYYY – D MMM YYYY","A h:mm – A h:mm","A h:mm – h:mm","A h:mm – h:mm","YYYY MMM D – D","YYYY MMM D – YYYY MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D.–D. MMM YYYY","D. MMM–D. MMM YYYY","D. MMM YYYY–D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D.–D. MMM YYYY","D. MMM–D. MMM YYYY","D. MMM YYYY–D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D – D [de] MMM [de] YYYY","D [de] MMM – D [de] MMM [de] YYYY","D [de] MMM [de] YYYY – D [de] MMM [de] YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D – D [de] MMM [de] YYYY","D [de] MMM – D [de] MMM [de] YYYY","D [de] MMM [de] YYYY – D [de] MMM [de] YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY [г].","D MMM – D MMM YYYY [г].","D MMM YYYY [г]. – D MMM YYYY [г].","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","A h.mm – A h.mm","A h.mm – h.mm","A h.mm – h.mm","YYYY MMM D – D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D. – D. M. YYYY","D. M. – D. M. YYYY","D. M. YYYY – D. M. YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D.–D. MMM YYYY","D. MMM–D. MMM YYYY","D. MMM YYYY–D. MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D – D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","DD.–DD. MMM YYYY.","DD. MMM – DD. MMM YYYY.","DD. MMM YYYY. – DD. MMM YYYY.","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","DD.–DD. MMM YYYY.","DD. MMM – DD. MMM YYYY.","DD. MMM YYYY. – DD. MMM YYYY.","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM–D MMM YYYY","D MMM YYYY–D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm – h:mm A","MMM D – D, YYYY","MMM D – D, YYYY","MMM D YYYY – MMM D YYYY","A h:mm – A h:mm","A h:mm–h:mm","A h:mm–h:mm","D – D MMM, YYYY","D MMM – D MMM, YYYY","D MMM, YYYY – D MMM, YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM, YYYY","D MMM – D MMM, YYYY","D MMM, YYYY – D MMM, YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","HH:mm น. – HH:mm น.","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","A h:mm – A h:mm","A h:mm–h:mm","A h:mm–h:mm","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","D MMM – D MMM، YYYY","D MMM، YYYY – D MMM، YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D – D-MMM, YYYY","D-MMM – D-MMM, YYYY","D-MMM, YYYY – D-MMM, YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D – D-MMM, YYYY","D-MMM – D-MMM, YYYY","D-MMM, YYYY – D-MMM, YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D – D MMM, YYYY","D MMM – D MMM, YYYY","[Ngày] DD [tháng] M [năm] YYYY - [Ngày] DD [tháng] M [năm] YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","Ah:mm至Ah:mm","Ah:mm至h:mm","Ah:mm至h:mm","YYYY年M月D日至D日","YYYY年M月D日至M月D日","YYYY年M月D日至YYYY年M月D日","Ah:mm至Ah:mm","Ah:mm至h:mm","Ah:mm至h:mm","YYYY年M月D日至D日","YYYY年M月D日至M月D日","YYYY年M月D日至YYYY年M月D日","Ah:mm至Ah:mm","Ah:mm至h:mm","Ah:mm至h:mm","YYYY年M月D日至D日","YYYY年M月D日至M月D日","YYYY年M月D日至YYYY年M月D日","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","MMM D – D, YYYY","MMM D – MMM D, YYYY","MMM D, YYYY – MMM D, YYYY"]};

    return moment;
}));
