/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 */
 /* global blankshield */

define('io.ox/core/pim/actions', [
    'io.ox/core/api/attachment',
    'io.ox/core/download',
    'io.ox/core/yell',
    'io.ox/core/extensions',
    'io.ox/core/extPatterns/actions',
    'io.ox/core/extPatterns/links',
    'gettext!io.ox/core'
], function (attachmentAPI, downloadAPI, yell, ext, actions, links, gt) {

    'use strict';

    var extensions = {

        // view attachment
        view: {
            requires: 'some',
            multiple: function (baton) {
                require(['io.ox/core/viewer/main'], function (Viewer) {
                    var viewer = new Viewer();
                    viewer.launch({ files: baton });
                });
            }
        },

        // open attachment
        open: {
            requires: 'one',
            action: function (baton) {
                var url = attachmentAPI.getUrl(baton.data, 'view');
                blankshield.open(url);
            }
        },

        // download attachment
        download: {
            requires: function (e) {
                // browser support for downloading more than one file at once is pretty bad (see Bug #36212)
                return e.collection.has('one') && _.device('!ios');
            },
            action: function (baton) {
                var url = attachmentAPI.getUrl(baton.data, 'download');
                downloadAPI.url(url);
            }
        },

        // save attachment
        save: {
            capabilities: 'infostore',
            requires: 'some',
            multiple: function (list) {
                // cannot be converted to multiple request because of backend bug (module overides params.module)
                _(list).each(function (data) {
                    attachmentAPI.save(data);
                });
                setTimeout(function () {
                    yell('success', gt('Attachments have been saved!'));
                }, 300);
            }
        }
    };

    var labels = {
        view: gt('View'),
        open: gt('Open in browser'),
        download: gt('Download'),
        //#. %1$s is usually "Drive" (product name; might be customized)
        save: gt('Save to %1$s', gt.pgettext('app', 'Drive'))
    };

    // and let's define all points right now
    var index = 0;

    // see bug 55872
    if (_.device('IE')) { delete extensions.open; }

    _(extensions).each(function (extension, id) {

        // define action
        var ref = 'io.ox/core/tk/actions/' + id + '-attachment';
        new actions.Action(ref, extension);

        // define default link
        ext.point('io.ox/core/tk/attachment/links').extend(new links.Link({
            id: id,
            index: index += 100,
            label: labels[id],
            mobile: 'hi',
            ref: ref
        }));
    });

    return extensions;
});
