'use strict';
var $             = require('./$')
  , has           = require('./$.has')
  , createDesc    = require('./$.property-desc')
  , setDesc       = $.setDesc
  , FunctionProto = Function.prototype
  , NAME          = 'name';
// 19.2.4.2 name
NAME in FunctionProto || require('./$.support-desc') && setDesc(FunctionProto, NAME, {
  configurable: true,
  get: function(){
    var match = String(this).match(/^\s*function ([^ (]*)/)
      , name  = match ? match[1] : '';
    has(this, NAME) || setDesc(this, NAME, createDesc(5, name));
    return name;
  },
  set: function(value){
    has(this, NAME) || setDesc(this, NAME, createDesc(0, value));
  }
});