(function (root, factory) {
    'use strict';

    /*global define*/
    if (typeof define === 'function' && define.amd) {
        define(['moment'], factory);                 // AMD
    } else if (typeof exports === 'object') {
        module.exports = factory(require('moment')); // Node
    } else {
        factory(root.moment);                        // Browser
    }
}(this, function (moment) {
    'use strict';

    // Do not load moment-interval a second time.
    if (moment.fn.formatInterval !== undefined) { return moment; }

    var regex = /(G+|y+|Y+|M+|w+|W+|D+|d+|F+|E+|u+|a+|H+|k+|K+|h+|m+|s+|S+|z+|Z+|v+|V+)|\[((?:[^\[\]]|\[\])+)\]|(\[\])/g;

    /**
     * get formatstring from locale object
     * @param  { Moment }   end     enddate of the interval
     * @param  { Boolean }  time    force time format
     * @return { String }           moment format string
     */
    function getFormat(end, time) {
        var loc = locale[moment.locale()],
            formats = locale.formats;

        if (time) {
            var is12h = this.localeData().longDateFormat('LT').toLowerCase().indexOf('a') > -1,
                f = is12h ? loc.hm : loc.Hm,
                m = moment.localeData().meridiem;

            if (is12h && (m(this.hours(), this.minutes(), true) !== m(end.hours(), end.minutes(), true))) {
                return formats[f.a];
            } else if (!this.isSame(end, 'hour')) {
                return formats[is12h ? f.h : f.H];
            } else if (!this.isSame(end, 'minute')) {
                return formats[f.m];
            }
            return 'LT';
        } else {
            var f = loc.yMMMd;
            if (!this.isSame(end, 'year')) {
                return formats[f.y];
            } else if (!this.isSame(end, 'month')) {
                return formats[f.M];
            } else if (!this.isSame(end, 'day')) {
                return formats[f.d];
            } else {
                return 'llll';
            }
        }
    }

    /**
     * split formatstring and apply them to moment-format
     * @param  { Moment } end    enddate of the interval
     * @param  { String } format moment date foramt string
     * @return { String }        formated date interval
     */
    function formatInterval(end, format) {
        var fields = {}, match;
        regex.lastIndex = 0;
        while ((match = regex.exec(format))) {
            if (!match[1]) continue;
            var letter = match[1].charAt(0);
            if (fields[letter]) break;
            fields[letter] = true;
        }
        if (regex.lastIndex) {
            return this.format(format.slice(0, match.index)) + end.format(format.slice(match.index));
        } else {
            return this.format(format);
        }
    }

    /**
     * define formatInteravl function
     * @param  { Moment }   end         enddate of the interval
     * @param  { String }   dateOrTime  force date or time format (optinal)
     * @return { String }               formated date interval
     */
    moment.fn.formatInterval = function (endMoment, dateOrTime) {

        if (!endMoment) {
            dateOrTime |= 'date';
            return this.format(dateOrTime === 'date' ? 'l' : 'LT');
        }
        // parse to moment
        endMoment = moment(endMoment);

        if (!dateOrTime) {
            dateOrTime = this.isSame(endMoment, 'day') ? 'time' : 'date';
        }

        if (dateOrTime !== 'time' && dateOrTime !== 'date') {
            var format = locale[moment.locale()].fallback;
            return format.replace('{0}',this.format(dateOrTime)).replace('{1}', endMoment.format(dateOrTime));
        } else {
            var format = getFormat.call(this, endMoment, dateOrTime === 'time');

            return formatInterval.call(this, endMoment, format);
        }

    };

    // locale data
    var locale = {"af":{"hm":{"a":0,"h":1,"m":2},"Hm":{"H":3,"m":3},"yMMMd":{"d":4,"M":5,"y":6},"fallback":"{0} – {1}"},"ar-ma":{"hm":{"a":13,"h":14,"m":15},"Hm":{"H":3,"m":3},"yMMMd":{"d":16,"M":17,"y":18},"fallback":"{0} – {1}"},"ar-sa":{"hm":{"a":19,"h":20,"m":21},"Hm":{"H":3,"m":3},"yMMMd":{"d":22,"M":23,"y":24},"fallback":"{0} – {1}"},"ar-tn":{"hm":{"a":25,"h":26,"m":27},"Hm":{"H":3,"m":3},"yMMMd":{"d":28,"M":29,"y":30},"fallback":"{0} – {1}"},"ar":{"hm":{"a":31,"h":32,"m":33},"Hm":{"H":3,"m":3},"yMMMd":{"d":34,"M":35,"y":36},"fallback":"{0} – {1}"},"az":{"hm":{"a":37,"h":38,"m":39},"Hm":{"H":3,"m":3},"yMMMd":{"d":40,"M":41,"y":42},"fallback":"{0} – {1}"},"be":{"hm":{"a":43,"h":44,"m":45},"Hm":{"H":46,"m":46},"yMMMd":{"d":47,"M":48,"y":49},"fallback":"{0} – {1}"},"bg":{"hm":{"a":50,"h":51,"m":52},"Hm":{"H":53,"m":53},"yMMMd":{"d":54,"M":55,"y":56},"fallback":"{0} – {1}"},"bn":{"hm":{"a":57,"h":58,"m":59},"Hm":{"H":3,"m":3},"yMMMd":{"d":60,"M":61,"y":62},"fallback":"{0} – {1}"},"bo":{"hm":{"a":63,"h":64,"m":65},"Hm":{"H":3,"m":3},"yMMMd":{"d":66,"M":67,"y":68},"fallback":"{0} – {1}"},"br":{"hm":{"a":69,"h":70,"m":71},"Hm":{"H":3,"m":3},"yMMMd":{"d":72,"M":73,"y":74},"fallback":"{0} – {1}"},"bs":{"hm":{"a":75,"h":76,"m":77},"Hm":{"H":3,"m":3},"yMMMd":{"d":78,"M":79,"y":80},"fallback":"{0} - {1}"},"ca":{"hm":{"a":82,"h":83,"m":84},"Hm":{"H":53,"m":53},"yMMMd":{"d":85,"M":86,"y":87},"fallback":"{0} - {1}"},"cs":{"hm":{"a":88,"h":89,"m":90},"Hm":{"H":91,"m":91},"yMMMd":{"d":92,"M":93,"y":94},"fallback":"{0} – {1}"},"cv":{"hm":{"a":95,"h":96,"m":97},"Hm":{"H":3,"m":3},"yMMMd":{"d":98,"M":99,"y":100},"fallback":"{0} – {1}"},"cy":{"hm":{"a":101,"h":102,"m":103},"Hm":{"H":3,"m":3},"yMMMd":{"d":104,"M":105,"y":106},"fallback":"{0} – {1}"},"da":{"hm":{"a":107,"h":108,"m":109},"Hm":{"H":46,"m":46},"yMMMd":{"d":110,"M":111,"y":112},"fallback":"{0} – {1}"},"de-at":{"hm":{"a":113,"h":114,"m":115},"Hm":{"H":116,"m":117},"yMMMd":{"d":118,"M":119,"y":120},"fallback":"{0} – {1}"},"de":{"hm":{"a":121,"h":122,"m":123},"Hm":{"H":124,"m":125},"yMMMd":{"d":126,"M":127,"y":128},"fallback":"{0} – {1}"},"dv":{"hm":{"a":129,"h":130,"m":131},"Hm":{"H":3,"m":3},"yMMMd":{"d":132,"M":133,"y":134},"fallback":"{0} – {1}"},"el":{"hm":{"a":135,"h":136,"m":137},"Hm":{"H":3,"m":3},"yMMMd":{"d":138,"M":139,"y":140},"fallback":"{0} - {1}"},"en-au":{"hm":{"a":141,"h":142,"m":143},"Hm":{"H":144,"m":144},"yMMMd":{"d":145,"M":146,"y":147},"fallback":"{0} – {1}"},"en-ca":{"yMMMd":{"d":148,"M":149,"y":150},"hm":{"a":151,"h":152,"m":153},"Hm":{"H":144,"m":144},"fallback":"{0} – {1}"},"en-gb":{"hm":{"a":154,"h":155,"m":156},"Hm":{"H":144,"m":144},"yMMMd":{"d":157,"M":158,"y":159},"fallback":"{0} – {1}"},"en-ie":{"hm":{"a":160,"h":161,"m":162},"Hm":{"H":144,"m":144},"yMMMd":{"d":163,"M":164,"y":165},"fallback":"{0} – {1}"},"en-nz":{"hm":{"a":166,"h":167,"m":168},"Hm":{"H":144,"m":144},"yMMMd":{"d":169,"M":170,"y":171},"fallback":"{0} – {1}"},"eo":{"hm":{"h":172,"m":173},"Hm":{"H":3,"m":3},"yMMMd":{"d":174,"M":175,"y":176},"fallback":"{0} – {1}"},"es":{"hm":{"a":177,"h":178,"m":179},"Hm":{"H":91,"m":91},"yMMMd":{"d":180,"M":181,"y":182},"fallback":"{0}–{1}"},"et":{"hm":{"a":183,"h":184,"m":185},"Hm":{"H":3,"m":3},"yMMMd":{"d":186,"M":187,"y":188},"fallback":"{0}–{1}"},"eu":{"hm":{"a":189,"h":190,"m":191},"Hm":{"H":3,"m":3},"yMMMd":{"d":192,"M":193,"y":194},"fallback":"{0} – {1}"},"fa":{"hm":{"a":195,"h":196,"m":197},"Hm":{"H":198,"m":198},"yMMMd":{"d":199,"M":200,"y":201},"fallback":"{0} تا {1}"},"fi":{"hm":{"a":204,"h":205,"m":206},"Hm":{"H":207,"m":207},"yMMMd":{"d":208,"M":209,"y":210},"fallback":"{0}–{1}"},"fo":{"hm":{"a":211,"h":212,"m":213},"Hm":{"H":3,"m":3},"yMMMd":{"d":214,"M":215,"y":216},"fallback":"{0} – {1}"},"fr-ca":{"hm":{"a":217,"h":218,"m":219},"Hm":{"H":144,"m":144},"yMMMd":{"d":220,"M":221,"y":222},"fallback":"{0} – {1}"},"fr-ch":{"hm":{"m":223},"Hm":{"m":3},"yMMMd":{"M":224,"y":225},"fallback":"du {0} au {1}"},"fr":{"hm":{"a":229,"h":230,"m":231},"Hm":{"H":144,"m":144},"yMMMd":{"d":232,"M":233,"y":234},"fallback":"{0} – {1}"},"fy":{"hm":{"a":235,"h":236,"m":237},"Hm":{"H":3,"m":3},"yMMMd":{"d":238,"M":239,"y":240},"fallback":"{0} - {1}"},"gd":{"hm":{"a":241,"h":242,"m":243},"Hm":{"H":144,"m":144},"yMMMd":{"d":244,"M":245,"y":246},"fallback":"{0} – {1}"},"gl":{"hm":{"a":247,"h":248,"m":249},"Hm":{"H":3,"m":3},"yMMMd":{"d":250,"M":251,"y":252},"fallback":"{0} – {1}"},"he":{"hm":{"a":253,"h":254,"m":255},"Hm":{"H":91,"m":91},"yMMMd":{"d":256,"M":257,"y":258},"fallback":"{0} – {1}"},"hi":{"hm":{"a":259,"h":260,"m":261},"Hm":{"H":3,"m":3},"yMMMd":{"d":262,"M":263,"y":264},"fallback":"{0} – {1}"},"hr":{"hm":{"a":265,"h":266,"m":267},"Hm":{"H":144,"m":144},"yMMMd":{"d":268,"M":269,"y":270},"fallback":"{0} – {1}"},"hu":{"hm":{"a":271,"h":272,"m":273},"Hm":{"H":91,"m":91},"yMMMd":{"d":274,"M":275,"y":276},"fallback":"{0} – {1}"},"hy-am":{"hm":{"a":277,"h":278,"m":279},"Hm":{"H":91,"m":91},"yMMMd":{"d":280,"M":281,"y":282},"fallback":"{0} – {1}"},"id":{"hm":{"a":283,"h":284,"m":285},"Hm":{"H":46,"m":46},"yMMMd":{"d":286,"M":287,"y":288},"fallback":"{0} – {1}"},"is":{"hm":{"a":289,"h":290,"m":291},"Hm":{"H":3,"m":3},"yMMMd":{"d":292,"M":293,"y":294},"fallback":"{0} – {1}"},"it":{"hm":{"a":295,"h":296,"m":297},"Hm":{"H":3,"m":3},"yMMMd":{"d":298,"M":299,"y":300},"fallback":"{0} - {1}"},"ja":{"hm":{"a":301,"h":302,"m":303},"Hm":{"H":304,"m":304},"yMMMd":{"d":305,"M":306,"y":307},"fallback":"{0}～{1}"},"jv":{"hm":{"a":309,"h":310,"m":311},"Hm":{"H":3,"m":3},"yMMMd":{"d":312,"M":313,"y":314},"fallback":"{0} – {1}"},"ka":{"hm":{"a":315,"h":316,"m":317},"Hm":{"H":3,"m":3},"yMMMd":{"d":318,"M":319,"y":320},"fallback":"{0} – {1}"},"kk":{"hm":{"a":321,"h":322,"m":323},"Hm":{"H":3,"m":3},"yMMMd":{"d":324,"M":325,"y":326},"fallback":"{0} - {1}"},"km":{"hm":{"a":327,"h":328,"m":329},"Hm":{"H":144,"m":144},"yMMMd":{"d":330,"M":331,"y":332},"fallback":"{0} - {1}"},"ko":{"hm":{"a":333,"h":334,"m":335},"Hm":{"H":336,"m":336},"yMMMd":{"d":337,"M":338,"y":339},"fallback":"{0} ~ {1}"},"lb":{"hm":{"a":341,"h":342,"m":343},"Hm":{"H":3,"m":3},"yMMMd":{"d":344,"M":345,"y":346},"fallback":"{0} - {1}"},"lo":{"hm":{"a":347,"h":348,"m":349},"Hm":{"H":3,"m":3},"yMMMd":{"d":350,"M":351,"y":352},"fallback":"{0} – {1}"},"lt":{"hm":{"a":353,"h":354,"m":355},"Hm":{"H":3,"m":3},"yMMMd":{"d":356,"M":357,"y":358},"fallback":"{0} – {1}"},"lv":{"hm":{"a":359,"h":360,"m":361},"Hm":{"H":3,"m":3},"yMMMd":{"d":362,"M":363,"y":364},"fallback":"{0} - {1}"},"me":{"hm":{"a":365,"h":366,"m":367},"Hm":{"H":3,"m":3},"yMMMd":{"d":368,"M":369,"y":370},"fallback":"{0} – {1}"},"mk":{"hm":{"a":371,"h":372,"m":373},"Hm":{"H":3,"m":3},"yMMMd":{"d":374,"M":375,"y":376},"fallback":"{0} - {1}"},"ml":{"hm":{"a":377,"h":378,"m":379},"Hm":{"H":144,"m":144},"yMMMd":{"d":380,"M":381,"y":382},"fallback":"{0} - {1}"},"mr":{"hm":{"a":383,"h":384,"m":385},"Hm":{"H":144,"m":144},"yMMMd":{"d":386,"M":387,"y":388},"fallback":"{0} – {1}"},"ms-my":{"hm":{"a":389,"h":390,"m":391},"Hm":{"H":3,"m":3},"yMMMd":{"d":392,"M":393,"y":394},"fallback":"{0} – {1}"},"ms":{"hm":{"a":395,"h":396,"m":397},"Hm":{"H":3,"m":3},"yMMMd":{"d":398,"M":399,"y":400},"fallback":"{0} – {1}"},"my":{"hm":{"a":401,"h":402,"m":403},"Hm":{"H":3,"m":3},"yMMMd":{"d":404,"M":405,"y":406},"fallback":"{0} – {1}"},"nb":{"hm":{"a":407,"h":408,"m":409},"Hm":{"H":46,"m":46},"yMMMd":{"d":410,"M":411,"y":412},"fallback":"{0}–{1}"},"ne":{"hm":{"a":413,"h":414,"m":415},"Hm":{"H":3,"m":3},"yMMMd":{"d":416,"M":417,"y":418},"fallback":"{0} – {1}"},"nl":{"hm":{"a":419,"h":420,"m":421},"Hm":{"H":3,"m":3},"yMMMd":{"d":422,"M":423,"y":424},"fallback":"{0} - {1}"},"nn":{"hm":{"h":425,"m":426},"Hm":{"H":3,"m":3},"yMMMd":{"d":427,"M":428,"y":429},"fallback":"{0} – {1}"},"pl":{"hm":{"a":430,"h":431,"m":432},"Hm":{"H":3,"m":3},"yMMMd":{"d":433,"M":434,"y":435},"fallback":"{0} – {1}"},"pt-br":{"hm":{"a":436,"h":437,"m":438},"Hm":{"H":144,"m":144},"yMMMd":{"d":439,"M":440,"y":441},"fallback":"{0} - {1}"},"pt":{"hm":{"a":442,"h":443,"m":444},"Hm":{"H":144,"m":144},"yMMMd":{"d":445,"M":446,"y":447},"fallback":"{0} - {1}"},"ro":{"hm":{"a":448,"h":449,"m":450},"Hm":{"H":3,"m":3},"yMMMd":{"d":451,"M":452,"y":453},"fallback":"{0} – {1}"},"ru":{"hm":{"a":454,"h":455,"m":456},"Hm":{"H":91,"m":91},"yMMMd":{"d":457,"M":458,"y":459},"fallback":"{0} - {1}"},"se":{"hm":{"a":460,"h":461,"m":462},"Hm":{"H":3,"m":3},"yMMMd":{"d":463,"M":464,"y":465},"fallback":"{0} – {1}"},"si":{"hm":{"a":466,"h":467,"m":468},"Hm":{"H":46,"m":46},"yMMMd":{"d":469,"M":470,"y":471},"fallback":"{0} – {1}"},"sk":{"hm":{"a":472,"h":473,"m":474},"Hm":{"H":53,"m":53},"yMMMd":{"d":475,"M":476,"y":477},"fallback":"{0} – {1}"},"sl":{"hm":{"a":478,"h":479,"m":480},"Hm":{"H":3,"m":3},"yMMMd":{"d":481,"M":482,"y":483},"fallback":"{0}–{1}"},"sq":{"hm":{"a":484,"h":485,"m":486},"Hm":{"H":144,"m":144},"yMMMd":{"d":487,"M":488,"y":489},"fallback":"{0} - {1}"},"sr-cyrl":{"hm":{"a":490,"h":491,"m":492},"Hm":{"H":46,"m":46},"yMMMd":{"d":493,"M":494,"y":495},"fallback":"{0} – {1}"},"sr":{"hm":{"a":496,"h":497,"m":498},"Hm":{"H":46,"m":46},"yMMMd":{"d":499,"M":500,"y":501},"fallback":"{0} – {1}"},"sv":{"hm":{"a":502,"h":503,"m":504},"Hm":{"H":3,"m":3},"yMMMd":{"d":505,"M":506,"y":507},"fallback":"{0} – {1}"},"sw":{"hm":{"a":508,"h":509,"m":510},"Hm":{"H":144,"m":144},"yMMMd":{"d":511,"M":512,"y":513},"fallback":"{0} – {1}"},"ta":{"hm":{"a":514,"h":515,"m":516},"Hm":{"H":144,"m":144},"yMMMd":{"d":517,"M":518,"y":519},"fallback":"{0} – {1}"},"te":{"hm":{"a":520,"h":521,"m":522},"Hm":{"H":3,"m":3},"yMMMd":{"d":523,"M":524,"y":525},"fallback":"{0} – {1}"},"th":{"hm":{"a":526,"h":527,"m":528},"Hm":{"H":529,"m":529},"yMMMd":{"d":530,"M":531,"y":532},"fallback":"{0} – {1}"},"tl-ph":{"hm":{"a":533,"h":534,"m":535},"Hm":{"H":3,"m":3},"yMMMd":{"d":536,"M":537,"y":538},"fallback":"{0} – {1}"},"tlh":{"hm":{"a":539,"h":540,"m":541},"Hm":{"H":3,"m":3},"yMMMd":{"d":542,"M":543,"y":544},"fallback":"{0} – {1}"},"tr":{"hm":{"a":545,"h":546,"m":547},"Hm":{"H":3,"m":3},"yMMMd":{"d":548,"M":549,"y":550},"fallback":"{0} – {1}"},"tzl":{"hm":{"a":551,"h":552,"m":553},"Hm":{"H":3,"m":3},"yMMMd":{"d":554,"M":555,"y":556},"fallback":"{0} – {1}"},"tzm-latn":{"hm":{"a":557,"h":558,"m":559},"Hm":{"H":3,"m":3},"yMMMd":{"d":560,"M":561,"y":562},"fallback":"{0} – {1}"},"tzm":{"hm":{"a":563,"h":564,"m":565},"Hm":{"H":3,"m":3},"yMMMd":{"d":566,"M":567,"y":568},"fallback":"{0} – {1}"},"uk":{"hm":{"a":569,"h":570,"m":571},"Hm":{"H":3,"m":3},"yMMMd":{"d":572,"M":573,"y":574},"fallback":"{0} – {1}"},"uz":{"hm":{"a":575,"h":576,"m":577},"Hm":{"H":3,"m":3},"yMMMd":{"d":578,"M":579,"y":580},"fallback":"{0} – {1}"},"vi":{"hm":{"a":581,"h":582,"m":583},"Hm":{"H":3,"m":3},"yMMMd":{"d":584,"M":585,"y":586},"fallback":"{0} - {1}"},"zh-cn":{"hm":{"a":587,"h":588,"m":589},"Hm":{"H":3,"m":3},"yMMMd":{"d":590,"M":591,"y":592},"fallback":"{0} – {1}"},"zh-tw":{"hm":{"a":593,"h":594,"m":595},"Hm":{"H":3,"m":3},"yMMMd":{"d":596,"M":597,"y":598},"fallback":"{0} – {1}"},"en":{"hm":{"a":599,"h":600,"m":601},"Hm":{"H":144,"m":144},"yMMMd":{"d":602,"M":603,"y":604},"fallback":"{0} – {1}"},"formats":["h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","HH:mm–HH:mm","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","{","0","}"," ","–","1","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM، YYYY","D MMM – D MMM، YYYY","D MMM، YYYY – D MMM، YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM، YYYY","D MMM – D MMM، YYYY","D MMM، YYYY – D MMM، YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM، YYYY","D MMM – D MMM، YYYY","D MMM، YYYY – D MMM، YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM، YYYY","D MMM – D MMM، YYYY","D MMM، YYYY – D MMM، YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","D MMM YYYY – D MMM","D MMM YYYY – D MMM YYYY","hh.mm A – hh.mm A","hh.mm–hh.mm A","hh.mm–hh.mm A","HH.mm–HH.mm","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","H:mm – H:mm","D.MM – D.MM.YYYY [г].","D.MM – D.MM.YYYY [г].","D.MM.YYYY [г]. – D.MM.YYYY [г].","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM, YYYY","D MMM – D MMM, YYYY","D MMM, YYYY – D MMM, YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","DD. – DD. MMM YYYY.","DD. MMM – DD. MMM YYYY.","DD. MMM YYYY. – DD. MMM YYYY.","-","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","H:mm–H:mm","D.–D. M. YYYY","D. M. – D. M. YYYY","D. M. YYYY – D. M. YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm h:mm A","h:mm – h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM, YYYY – D MMM YYYY","h.mm A – h.mm A","h.mm–h.mm A","h.mm–h.mm A","D.–D. MMM YYYY","D. MMM – D. MMM YYYY","D. MMM YYYY – D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","HH:mm–HH:mm [Uhr]","HH:mm–HH:mm [Uhr]","D.–D. MMM YYYY","D. MMM – D. MMM YYYY","D. MMM YYYY – D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","HH:mm–HH:mm [Uhr]","HH:mm–HH:mm [Uhr]","D.–D. MMM YYYY","D. MMM – D. MMM YYYY","D. MMM YYYY – D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","DD–DD MMM YYYY","DD MMM – DD MMM YYYY","DD MMM YYYY – DD MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","HH:mm – HH:mm","MMM D – D, YYYY","MMM D – MMM D, YYYY","MMM D, YYYY – MMM D, YYYY","MMM D – D, YYYY","MMM D – MMM D, YYYY","MMM D, YYYY – MMM D, YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","MMM D – D, YYYY","MMM D – MMM D, YYYY","MMM D, YYYY – MMM D, YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","MMM D – D, YYYY","MMM D – MMM D, YYYY","MMM D, YYYY – MMM D, YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","MMM D – D, YYYY","MMM D – MMM D, YYYY","MMM D, YYYY – MMM D, YYYY","h:mm–h:mm A","h:mm–h:mm A","YYYY-MMM-DD – YYYY-MMM-DD","YYYY-MMM-DD – YYYY-MMM-DD","YYYY-MMM-DD – YYYY-MMM-DD","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D.–D. MMM YYYY","D. MMM – D. MMM YYYY","D. MMM YYYY – D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY([e])[Ho] MMM D–D","YYYY([e])[Ho] MMM D – MMM D","YYYY([e])[Ho] MMM D – YYYY([e])[Ho] MMM D","h:mm A تا h:mm A","h:mm تا h:mm A","h:mm تا h:mm A","H:mm تا H:mm","D تا D MMM YYYY","D LLL تا D MMM YYYY","D MMM YYYY تا D MMM YYYY","ت","ا","h.mm A – h.mm A","h.mm–h.mm A","h.mm–h.mm A","H.mm–H.mm","D.–D. MMMM YYYY","D. MMMM – D. MMMM YYYY","D. MMMM YYYY – D. MMMM YYYY","h:mm A–h:mm A","h:mm–h:mm A","h:mm–h:mm A","D.–D. MMM YYYY","DD. MMM–DD. MMM YYYY","DD. MMM YYYY–DD. MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm–h:mm A","D MMM [au] D MMM YYYY","D MMM YYYY [au] D MMM YYYY","D","u","A","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mmA – h:mmA","h:mm – h:mmA","h:mm – h:mmA","D – D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM, YYYY","D MMM – D MMM, YYYY","D MMM, YYYY – D MMM, YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D בMMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","DD. – DD. MMM YYYY.","DD. MMM – DD. MMM YYYY.","DD. MMM YYYY. – DD. MMM YYYY.","A h:mm – A h:mm","A h:mm–h:mm","A h:mm–h:mm","YYYY. MMM D–D.","YYYY. MMM D. – MMM D.","YYYY. MMM D. – YYYY. MMM D.","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","DD–DD MMM, YYYYթ.","DD MMM – DD MMM, YYYYթ.","DD MMM, YYYYթ․ – DD MMM, YYYYթ.","h.mm A – h.mm A","h.mm–h.mm A","h.mm–h.mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D.–D. MMM YYYY","D. MMM – D. MMM YYYY","D. MMM YYYY – D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","DD–DD MMM YYYY","DD MMM – DD MMM YYYY","DD MMM YYYY – DD MMM YYYY","Ah時mm分～Ah時mm分","Ah時mm分～h時mm分","Ah時mm分～h時mm分","H時mm分～H時mm分","YYYY年M月D日～D日","YYYY年M月D日～M月D日","YYYY年M月D日～YYYY年M月D日","～","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM, YYYY","DD MMM. – DD MMM. YYYY","DD MMM. YYYY – D MMM. YYYY","A h:mm – A h:mm","A h:mm–h:mm","A h:mm–h:mm","YYYY [ж]. D–D MMM","YYYY [ж]. D MMM – D MMM","YYYY [ж]. D MMM – YYYY [ж]. D MMM","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D – D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","A h:mm ~ A h:mm","A h:mm~h:mm","A h:mm~h:mm","HH:mm ~ HH:mm","YYYY년 M월 D일~D일","YYYY년 M월 D일 ~ M월 D일","YYYY년 M월 D일 ~ YYYY년 M월 D일","~","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D.–D. MMM YYYY","D. MMM – D. MMM YYYY","D. MMM YYYY – D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D/MM/YYYY – D/MM/YYYY","D/MM/YYYY – D/MM","DD/MM/YYYY – DD/MM/YYYY","hh:mm A–hh:mm A","hh:mm–hh:mm A","hh:mm–hh:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY. [gada] D.–D. MMM","YYYY. [gada] D. MMM – D. MMM","YYYY. [gada] D. MMM – YYYY. [gada] D. MMM","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","DD–DD MMM YYYY","DD MMM – DD MMM YYYY","DD MMM YYYY – DD MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","YYYY MMM D – D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D – D MMM, YYYY","D MMM – D MMM, YYYY","D MMM, YYYY – D MMM, YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM, YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM, YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM၊ YYYY","D MMM YYYY– D MMM YYYY","h.mm A–h.mm A","h.mm–h.mm A","h.mm–h.mm A","D.–D. MMM YYYY","D. MMM–D. MMM YYYY","D. MMM YYYY–D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm–h:mm A","h:mm–h:mm A","D.–D. MMM YYYY","D. MMM–D. MMM YYYY","D. MMM YYYY–D. MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","DD–DD.MM.YYYY","DD.MM–DD.MM.YYYY","DD.MM.YYYY–DD.MM.YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D – D [de] MMM [de] YYYY","D [de] MMM – D [de] MMM [de] YYYY","D [de] MMM [de] YYYY – D [de] MMM [de] YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D – D [de] MMM [de] YYYY","D [de] MMM – D [de] MMM [de] YYYY","D [de] MMM [de] YYYY – D [de] MMM [de] YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY [г].","D MMM – D MMM YYYY [г].","D MMM YYYY – D MMM YYYY [г].","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","A h.mm – A h.mm","A h.mm – h.mm","A h.mm – h.mm","YYYY MMM D – D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D. – D. M. YYYY","D. M. – D. M. YYYY","D. M. YYYY – D. M. YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D.–D. MMM YYYY","D. MMM–D. MMM YYYY","D. MMM YYYY–D. MMM YYYY","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","D – D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h.mm A – h.mm A","h.mm–h.mm A","h.mm–h.mm A","DD.–DD. MMM YYYY.","DD. MMM – DD. MMM YYYY.","DD. MMM YYYY. – DD. MMM YYYY.","h.mm A – h.mm A","h.mm–h.mm A","h.mm–h.mm A","DD.–DD. MMM YYYY.","DD. MMM – DD. MMM YYYY.","DD. MMM YYYY. – DD. MMM YYYY.","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM–D MMM YYYY","D MMM YYYY–D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm – h:mm A","MMM D – D, YYYY","MMM D – D, YYYY","MMM D YYYY – MMM D YYYY","A h:mm – A h:mm","A h:mm–h:mm","A h:mm–h:mm","D – D MMM, YYYY","D MMM – D MMM, YYYY","D MMM, YYYY – D MMM, YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM, YYYY","D MMM – D MMM, YYYY","D MMM, YYYY – D MMM, YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","HH:mm น. – HH:mm น.","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","A h:mm – A h:mm","A h:mm–h:mm","A h:mm–h:mm","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","YYYY MMM D–D","YYYY MMM D – MMM D","YYYY MMM D – YYYY MMM D","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D–D MMM YYYY","D MMM – D MMM YYYY","D MMM YYYY – D MMM YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D – D-MMM, YYYY","D-MMM – D-MMM, YYYY","D-MMM, YYYY – D-MMM, YYYY","h:mm A – h:mm A","h:mm–h:mm A","h:mm–h:mm A","D – D MMM, YYYY","D MMM – D MMM, YYYY","[Ngày] DD [tháng] M [năm] YYYY - [Ngày] DD [tháng] M [năm] YYYY","Ah:mm至Ah:mm","Ah:mm至h:mm","Ah:mm至h:mm","YYYY年M月D日至D日","YYYY年M月D日至M月D日","YYYY年M月D日至YYYY年M月D日","Ah:mm至Ah:mm","Ah:mm至h:mm","Ah:mm至h:mm","YYYY年M月D日至D日","YYYY年M月D日至M月D日","YYYY年M月D日至YYYY年M月D日","h:mm A – h:mm A","h:mm – h:mm A","h:mm – h:mm A","MMM D – D, YYYY","MMM D – MMM D, YYYY","MMM D, YYYY – MMM D, YYYY"]};

    return moment;
}));
