/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.Code;
import com.openexchange.obs.api.ObsPackage;

public class PackageStatus
extends ObsPackage {
    private Code code;
    private String details = null;

    public PackageStatus(String name, String code) throws BuildServiceException {
        this(name, Code.parseCode(code));
    }

    public PackageStatus(String name, Code code) throws BuildServiceException {
        super(name);
        if (code == null) {
            throw new BuildServiceException("Package code is null");
        }
        this.code = code;
    }

    public final Code getCode() {
        return this.code;
    }

    public final String getDetails() {
        return this.details;
    }

    public final void setDetails(String details) {
        this.details = details;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getPackageName());
        ret.append(':');
        ret.append(this.code.toString());
        if (null != this.details) {
            ret.append(',');
            ret.append(this.details);
        }
        return ret.toString();
    }
}

