/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.git;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class Git {
    private final Repository repository;
    private Map<ObjectId, Ref> tags = null;
    private final List<Ref> walkedTags = new ArrayList<Ref>();

    public Git(File gitDir) throws IOException {
        this.repository = this.initialize(gitDir);
    }

    private Repository initialize(File gitDir) throws IOException {
        return ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDir)).readEnvironment()).findGitDir()).build();
    }

    private Map<ObjectId, Ref> readTags() throws IOException {
        if (null != this.tags) {
            return this.tags;
        }
        this.tags = new HashMap<ObjectId, Ref>();
        for (Ref r : this.repository.getRefDatabase().getRefs("refs/tags/").values()) {
            ObjectId key = this.repository.peel(r).getPeeledObjectId();
            if (key == null) {
                key = r.getObjectId();
            }
            this.tags.put(key, r);
        }
        return this.tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Ref> walkTags() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (!this.walkedTags.isEmpty()) {
            return this.walkedTags;
        }
        try (RevWalk walk = new RevWalk(this.repository);){
            walk.markStart(walk.parseCommit((AnyObjectId)this.repository.resolve("HEAD")));
            RevCommit candidate = null;
            Map<ObjectId, Ref> tags = this.readTags();
            while ((candidate = walk.next()) != null) {
                ObjectId candidateId = candidate.getId();
                Ref ref = tags.get(candidateId);
                if (null == ref) continue;
                this.walkedTags.add(ref);
            }
        }
        return this.walkedTags;
    }

    public List<String> getTags() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ArrayList<String> retval = new ArrayList<String>();
        for (Ref ref : this.walkTags()) {
            retval.add(ref.toString());
        }
        return retval;
    }
}

