'use strict';


var Type = require('../../type');


function resolveJavascriptUndefined(state) {
  state.result = undefined;
  return true;
}


function representJavascriptUndefined(/*object, explicit*/) {
  return '';
}


function isUndefined(object) {
  return 'undefined' === typeof object;
}


module.exports = new Type('tag:yaml.org,2002:js/undefined', {
  loadKind: 'scalar',
  loadResolver: resolveJavascriptUndefined,
  dumpPredicate: isUndefined,
  dumpRepresenter: representJavascriptUndefined
});
