'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getIterator2 = require('babel-runtime/core-js/get-iterator');

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _set = require('babel-runtime/core-js/set');

var _set2 = _interopRequireDefault(_set);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _toArray = require('../../utils/toArray');

var _toArray2 = _interopRequireDefault(_toArray);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Variable = function () {
    function Variable(_ref) {
        var name = _ref.name,
            type = _ref.type,
            scope = _ref.scope;
        (0, _classCallCheck3.default)(this, Variable);

        this.name = name;
        this.type = type;
        this.scope = scope;
        this._definitions = new _set2.default();
        this._references = new _set2.default();
    }

    (0, _createClass3.default)(Variable, [{
        key: '_addDefinition',
        value: function _addDefinition(definition) {
            definition.variable = this;
            this._definitions.add(definition);
        }
    }, {
        key: '_addReference',
        value: function _addReference(reference) {
            reference.variable = this;
            this._references.add(reference);
        }
    }, {
        key: '_removeDefinition',
        value: function _removeDefinition(definition) {
            this._definitions.delete(definition);
        }
    }, {
        key: '_removeReference',
        value: function _removeReference(reference) {
            this._references.delete(reference);
        }
    }, {
        key: '_transferReferences',
        value: function _transferReferences(variable) {
            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = (0, _getIterator3.default)(this._references), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var reference = _step.value;

                    if (!reference.type) {
                        this._references.delete(reference);
                        variable._references.add(reference);
                        reference.variable = variable;
                    }
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }
        }
    }, {
        key: 'getDefinitions',
        value: function getDefinitions() {
            return (0, _toArray2.default)(this._definitions);
        }
    }, {
        key: 'getReferences',
        value: function getReferences() {
            return (0, _toArray2.default)(this._references);
        }
    }]);
    return Variable;
}();

exports.default = Variable;
//# sourceMappingURL=Variable.js.map