---
tags: ['verb-tag-jscomments']
---
# {%= name %} {%= badge('fury') %}

> {%= description %}

Similar in concept to [matchdep](https://github.com/tkellen/node-matchdep) and [load-grunt-tasks](https://github.com/sindresorhus/load-grunt-tasks), but returns an array of fully resolved file paths to _any local modules or npm modules listed in package.json dependencies_.

## Install
{%= include('install', {save: true}) %}

## Usage

```js
var resolve = require('resolve-dep');
resolve( patterns, options )
```

## API

{%= jscomments("index.js") %}


### Options

Type: `object`

The options object supports any [globby](https://github.com/sindresorhus/globby) options, as well as the following:


### patterns

Type: `string|array`

The file path, glob pattern, or name of the npm module to resolve.

**File paths**

```js
resolve('templates/*.hbs')
resolve(['a/*.hbs', 'b/*.hbs'])
```

**NPM modules**

```js
resolve('*')
resolve(['grunt-*', 'gulp-*'])
resolve(['grunt-*', 'gulp-*'], {type: 'devDependencies'})
resolve(['lodash', 'assemble']);
```

#### options.config
Type: `Object`
Default value: `package.json`

Pass an explicit config object to use instead of package.json.

#### options.type

Type: `String|Array`

Default value: `all`

Valid values: `all|dependencies|devDepencies|peerDependencies`

Any valid npm dependency field that can be used in package.json is a valid value for this option.

**Examples:**

```js
// resolve chai and mocha, if in devDependencies, otherwise an empty array
resolve(['chai', 'mocha'], {type: 'devDependencies'});
// resolve lodash if in dependencies, otherwise an empty array
resolve(['lodash'], {type: 'dependencies'});
// all dependencies
resolve(['*'], {type: 'dependencies'});
// all dependencies, devDependencies and peerDependencies
resolve('*');
```


## Author
{%= include('author') %}

## License
{%= copyright() %}
{%= license() %}

***

{%= include("footer") %}
