/* This file has been generated by ox-ui-module generator.
 * Please only apply minor changes (better no changes at all) to this file
 * if you want to be able to run the generator again without much trouble.
 *
 * If you really have to change this file for whatever reason, try to contact
 * the core team and describe your use-case. May be, your changes can be
 * integrated into the templates to be of use for everybody.
 */
'use strict';

module.exports = function (grunt) {

    var languages = grunt.file.expand('i18n/*.po').map(function (fileName) {
        return fileName.match(/([a-zA-Z]+_[a-zA-Z]+).po$/)[1];
    });

    // Copy build version or dist version into some arbitrary directory
    grunt.config.merge({
        copy: {
            local_install_build: {
                files: [{
                    expand: true,
                    src: '**/*',
                    dot: true,
                    cwd: 'build/',
                    filter: 'isFile',
                    dest: grunt.option('dest') || 'no_dest_set/'
                }]
            },
            local_install_dynamic: {
                options: {
                    mode: true
                },
                files: [{
                    expand: true,
                    src: ['**/*'].concat(languages.map(function (Lang) {
                        //return '' in case --no-languages is used, so language files
                        //will also be copied by this task
                        return grunt.option('no-languages') || false ? '!**/*.' + Lang + '.js' : '';
                    })).filter(function (Lang) {
                        return Lang.length > 0;
                    }),
                    dot: true,
                    cwd: 'dist/',
                    filter: 'isFile',
                    dest: grunt.option('prefix') || 'no_prefix_set/'
                }]
            },
            local_install_static: {
                options: {
                    mode: true
                },
                files: [{
                    expand: true,
                    src: ['appsuite/**/*', '!appsuite/manifests/**/*'].concat(languages.map(function (Lang) {
                        //ignore language files for static packages
                        return '!**/*.' + Lang + '.js';
                    })),
                    dot: true,
                    cwd: 'dist/',
                    filter: 'isFile',
                    dest: grunt.option('htdoc') || 'no_htdoc_set'
                }]
            }
        }
    });

    grunt.registerTask('install', 'install build directory into a custom location', function () {
        if (!grunt.option('dest')) {
            grunt.fail.fatal('Need --dest option to be set');
        }
        grunt.log.writeln('Installing into:', grunt.option('dest'));
        grunt.task.run('copy:local_install_build');
    });
    grunt.registerTask('install:dist', 'install dist directory into a custom location', function () {
        var tasks = [],
            dynamicConfig = grunt.config('copy.local_install_dynamic.files')[0],
            staticConfig = grunt.config('copy.local_install_static.files')[0];
        if (grunt.file.expand(staticConfig, staticConfig.src).length) {
            tasks.push('install:static');
        }

        if (grunt.file.expand(dynamicConfig, dynamicConfig.src).length) {
            tasks.push('install:dynamic');
        }
        grunt.task.run(tasks);
    });
    grunt.registerTask('install:dynamic', 'install files for dynamic usage into a custom location', function () {
        if (!grunt.option('prefix')) {
            grunt.fail.fatal('Need --prefix option to be set');
        }
        grunt.log.writeln('Installing into:', grunt.option('prefix'));
        grunt.task.run('copy:local_install_dynamic');
    });
    grunt.registerTask('install:static', 'install files for static usage into a custom location', function () {
        if (!grunt.option('htdoc')) {
            grunt.fail.fatal('Need --htdoc option to be set');
        }
        grunt.log.writeln('Installing into:', grunt.option('htdoc'));
        grunt.task.run('copy:local_install_static');
    });

    languages.forEach(function (Lang) {
        var config = {};

        config['local_install_' + Lang] = {
            files: [{
                src: ['**/*.' + Lang + '.js'],
                expand: true,
                filter: 'isFile',
                cwd: 'dist/',
                dest: grunt.option('prefix') || 'no_prefix_set/'
            }]
        };

        grunt.config.merge({
            copy: config
        });
        grunt.registerTask('install:' + Lang, 'install language directory into a custom location', function () {
            if (!grunt.option('prefix')) {
                grunt.fail.fatal('Need --prefix option to be set');
            }
            grunt.log.writeln('Installing into:', grunt.option('prefix'));
            grunt.task.run('copy:local_install_' + Lang);
        });
    });

    grunt.loadNpmTasks('grunt-contrib-copy');
};
