  /**
   *  Ignores all elements in an observable sequence leaving only the termination messages.
   * @returns {Observable} An empty observable sequence that signals termination, successful or exceptional, of the source sequence.
   */
  observableProto.ignoreElements = function () {
    var source = this;
    return new AnonymousObservable(function (observer) {
      return source.subscribe(noop, observer.onError.bind(observer), observer.onCompleted.bind(observer));
    });
  };
