/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jgit.internal.storage.reftree.RefTreeDatabase;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;

public class RefTreeNames {
    private static final String STAGE = "stage/";

    public static boolean isRefTree(RefDatabase refdb, String ref) {
        if (refdb instanceof RefTreeDatabase) {
            RefTreeDatabase b = (RefTreeDatabase)refdb;
            if (ref.equals(b.getTxnCommitted())) {
                return true;
            }
            String namespace = b.getTxnNamespace();
            if (namespace != null && ref.startsWith(namespace) && !ref.startsWith(namespace + STAGE)) {
                return true;
            }
        }
        return false;
    }

    public static Collection<Ref> allRefs(RefDatabase refdb) throws IOException {
        Collection<Ref> refs = refdb.getRefs("").values();
        if (!(refdb instanceof RefTreeDatabase)) {
            return refs;
        }
        RefDatabase bootstrap = ((RefTreeDatabase)refdb).getBootstrap();
        Collection<Ref> br = bootstrap.getRefs("").values();
        ArrayList<Ref> all = new ArrayList<Ref>(refs.size() + br.size());
        all.addAll(refs);
        all.addAll(br);
        return all;
    }

    private RefTreeNames() {
    }
}

