  /**
   * Converts a Promise to an Observable sequence
   * @param {Promise} An ES6 Compliant promise.
   * @returns {Observable} An Observable sequence which wraps the existing promise success and failure.
   */
  var observableFromPromise = Observable.fromPromise = function (promise) {
    return observableDefer(function () {
      var subject = new Rx.AsyncSubject();

      promise.then(
        function (value) {
          if (!subject.isDisposed) {
            subject.onNext(value);
            subject.onCompleted();
          }
        },
        subject.onError.bind(subject));

      return subject;
    });
  };
