  function elementAtOrDefault(source, index, hasDefault, defaultValue) {
    if (index < 0) { throw new Error(argumentOutOfRange); }
    return new AnonymousObservable(function (o) {
      var i = index;
      return source.subscribe(function (x) {
        if (i-- === 0) {
          o.onNext(x);
          o.onCompleted();
        }
      }, function (e) { o.onError(e); }, function () {
        if (!hasDefault) {
          o.onError(new Error(argumentOutOfRange));
        } else {
          o.onNext(defaultValue);
          o.onCompleted();
        }
      });
    }, source);
  }
