define([
	"./support"
], function( support ) {

// We have to close these tags to support XHTML (#13200)
var wrapMap = {
	option: [ 1, "<select multiple='multiple'>", "</select>" ],

	// Support: IE8
	param: [ 1, "<object>", "</object>" ],

	thead: [ 1, "<table>", "</table>" ],

	// Some of the following wrappers are not fully defined, because
	// their parent elements (except for "table" element) could be omitted
	// since browser parsers are smart enough to auto-insert them

	// Support: Android 2.3
	// Android browser doesn't auto-insert colgroup
	col: [ 2, "<table><colgroup>", "</colgroup></table>" ],

	// Auto-insert "tbody" element
	tr: [ 2, "<table>", "</table>" ],

	// Auto-insert "tbody" and "tr" elements
	td: [ 3, "<table>", "</table>" ],

	// IE8 can't serialize link, script, style, or any html5 (NoScope) tags,
	// unless wrapped in a div with non-breaking characters in front of it.
	_default: support.htmlSerialize ? [ 0, "", "" ] : [ 1, "X<div>", "</div>" ]
};

// Support: IE8-IE9
wrapMap.optgroup = wrapMap.option;

wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
wrapMap.th = wrapMap.td;

return wrapMap;
});
