/* This file has been generated by ox-ui-module generator.
 * Please only apply minor changes (better no changes at all) to this file
 * if you want to be able to run the generator again without much trouble.
 *
 * If you really have to change this file for whatever reason, try to contact
 * the core team and describe your use-case. May be, your changes can be
 * integrated into the templates to be of use for everybody.
 */
'use strict';

module.exports = function (grunt) {

    grunt.isPeerDependencyInstalled = function (name) {
        var path = require('path');
        var root = path.resolve('node_modules');
        return grunt.file.exists(path.join(root, name, 'package.json'));
    };
    if (!grunt.isPeerDependencyInstalled('grunt-check-dependencies')) {
        grunt.fail.fatal('Essential dependencies missing, try to run `npm install` or at least `npm install --production`');
    }

    var path = require('path');

    // make grunt config extendable
    grunt.config.extend = function (k, v) {
        grunt.config(k, require('underscore').extend({}, grunt.config(k), v));
    };

    grunt.config('pkg', grunt.file.readJSON('package.json'));

    grunt.config('local', require('underscore').extend(
        grunt.file.readJSON(path.join(path.dirname(__filename), 'local.conf.default.json')),
        grunt.file.exists('grunt/local.conf.json') ? grunt.file.readJSON('grunt/local.conf.json') : {}
    ));

    grunt.util.runPrefixedSubtasksFor = function (main_task, prefix) {
        return function () {
            var list = [];

            for (var key in grunt.config(main_task)) {
                if (key.substr(0, prefix.length) === prefix) {
                    list.push(key);
                }
            }
            list = list.map(function (name) {
                return main_task + ':' + name;
            });

            grunt.task.run(list);
        };
    };

    // custom tasks
    grunt.registerTask('manifests', ['newer:jsonlint:manifests', 'concat:manifests']);
    grunt.registerTask('lint', ['newer:jshint:all', 'newer:jsonlint:all']);

    // steps to build the ui (ready for development)
    grunt.registerTask('build', ['lint', 'copy_build', 'newer:concat', 'newer:less', 'compile_po']);
    // create a distribution ready version of the ui
    grunt.registerTask('dist', ['clean', 'checkDependencies:build', 'bower', 'build', 'uglify', 'copy_dist']);
    // run development setup
    grunt.registerTask('dev', ['connect', 'test', 'watch']);
    // run a clean development setup
    grunt.registerTask('cleanDev', ['clean', 'default', 'connect', 'test', 'watch']);
    // default task
    grunt.registerTask('default', ['checkDependencies:dev', 'bower', 'build']);

    // load pre-configured grunt tasks
    grunt.loadTasks(path.join(path.dirname(__filename), 'shared'));
};
