/**
 * Separator object
 * Used to space/separate choices group
 */


/**
 * Module exports
 */

module.exports = Separator;


/**
 * Separator object
 * @constructor
 * @param {String} line   Separation line content (facultative)
 */

function Separator( line ) {
  this.line = line || "--------";
}


/**
 * Helper function returning false if object is a separator
 * @param  {Object} obj object to test against
 * @return {Boolean}    `false` if object is a separator
 */

Separator.exclude = function( obj ) {
  return !(obj instanceof Separator);
};


/**
 * Stringify separator
 * @return {String} the separator display string
 */

Separator.prototype.toString = function() {
  return this.line;
};
