/**
 * plugin.js
 *
 * Copyright, Moxiecode Systems AB
 * Released under LGPL License.
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/*global tinymce:true */

tinymce.PluginManager.add('oximage', function(editor) {

    function showDialog(url) {

        var dom = editor.dom,
            el = $(editor.contentAreaContainer),
            imgElm = editor.selection.getNode(),
            data = { src: url },
            width, height, classListCtrl;

        function onSubmitForm() {

            function waitLoad(imgElm) {

                function selectImage() {
                    imgElm.onload = imgElm.onerror = null;
                    editor.selection.select(imgElm);
                    editor.nodeChanged();
                }

                imgElm.onload = function() {

                    var max_width = el.width() * 0.7,
                        width = imgElm.clientWidth,
                        height = imgElm.clientHeight;

                    // scale down?
                    if (width > max_width) {
                        height = Math.round(height * max_width / width);
                        width = max_width;
                    }

                    dom.setAttribs(imgElm, { width: width, height: height });

                    selectImage();
                };

                imgElm.onerror = selectImage;
            }

            editor.undoManager.transact(function() {
                if (!data.src) {
                    if (imgElm) {
                        dom.remove(imgElm);
                        editor.focus();
                        editor.nodeChanged();
                    }

                    return;
                }

                if (!imgElm) {
                    data.id = '__mcenew';
                    editor.focus();
                    editor.selection.setContent(dom.createHTML('img', data));
                    imgElm = dom.get('__mcenew');
                    dom.setAttrib(imgElm, 'id', null);
                } else {
                    dom.setAttribs(imgElm, data);
                }

                waitLoad(imgElm);
            });
        }

        width = dom.getAttrib(imgElm, 'width');
        height = dom.getAttrib(imgElm, 'height');

        if (imgElm.nodeName == 'IMG' && !imgElm.getAttribute('data-mce-object') && !imgElm.getAttribute('data-mce-placeholder')) {
            data = {
                src: dom.getAttrib(imgElm, 'src'),
                alt: dom.getAttrib(imgElm, 'alt'),
                "class": dom.getAttrib(imgElm, 'class'),
                width: width,
                height: height
            };
        } else {
            imgElm = null;
        }

        onSubmitForm();
    }

    editor.addButton('image', {
        icon: 'image',
        title: 'Insert/edit image',
        onPostRender: function () {
            var form = $('<form>', { 'accept-charset': 'UTF-8', enctype: 'multipart/form-data', method: 'POST' }).addClass('mce-widget mce-btn mce-last btn-file'),
                gguid = _.uniqueId('form-control-label-');
            form.append(
                $('<i>').addClass('mce-ico mce-i-image').css('padding', '6px 10px'),
                $('<label>').attr('for', gguid).addClass('sr-only'),
                $('<input name="file" type="file" class="file-input">').prop({ multiple: true }).attr({ id: gguid }).on('change', function () {
                    var file = $(this);
                    require(['io.ox/mail/write/inline-images', 'io.ox/core/notifications', 'gettext!io.ox/mail'], function (inlineimages, notifications, gt) {
                        var failHandler = function (data) {
                            if (data && data.error) {
                                notifications.yell('error', data.error);
                            }
                        };
                        if (!(/\.(gif|bmp|tiff|jpe?g|gmp|png)$/i).test(file.val())) {
                            notifications.yell('error', gt('Please select a valid image File to insert'));
                        } else {
                            return inlineimages.api.inlineImage({
                                file: file[0].files ? file[0].files[0] : [],
                                form: form
                            }).then(function (data) {
                                showDialog(inlineimages.api.getInsertedImageUrl(data))
                            }).fail(failHandler);
                        }
                    });
                })
            );
            $(this.getEl()).replaceWith(form);
        }
    });

    /*
    Adds dropdown for upload and drive picker.
    This still needs some work and is deactivated for now.

    editor.addButton('image', {
        type: 'menubutton',
        icon: 'image',
        tooltip: 'Insert/edit image',
        menu: [
            {
                text: 'Upload',
                onclick: function () {
                    require(['io.ox/mail/write/inline-images'], function (inlineimages) {
                        inlineimages.show().done(function (url) {
                            showDialog(url);
                        });
                    });
                }
            },
            {
                text: 'Drive',
                onclick: function() {
                    // open ox filepicker
                    require(['io.ox/files/filepicker', 'io.ox/files/api', 'gettext!io.ox/files']).done(function (Picker, fileAPI, gt) {
                        var picker = new Picker({
                            primaryButtonText: gt('Add'),
                            multiselect: false,
                            filter: function (file) {
                                return (/\.(gif|bmp|tiff|jpe?g|gmp|png)$/i).test(file.filename);
                            },
                        });
                        picker.done(function (files) {
                            var url = '';
                            if (files[0]) {
                                url = fileAPI.getUrl(files[0], 'view');
                            }
                            showDialog(url);
                        });
                    });
                }
            }
        ]
    });
    */
});
