define("io.ox/switchboard/views/call-history",["io.ox/backbone/views/disposable","io.ox/contacts/api","io.ox/contacts/util","io.ox/switchboard/presence","io.ox/switchboard/lookup","io.ox/switchboard/call/api","io.ox/core/extensions","settings!io.ox/switchboard","gettext!io.ox/switchboard"],function(e,t,i,n,o,s,a,l,c){"use strict";var r=a.point("io.ox/switchboard/call-history/data"),d=l.get("callHistory/limit",50),h=new(Backbone.Collection.extend({comparator:"date"})),m=e.extend({tagName:"li",className:"launcher dropdown call-history",events:{'click [data-action="all"]':"showAll",'click [data-action="missed"]':"showMissed"},initialize:function(){var e=l.get("callHistory/entries")||[];this.collection.add(e),this.onAddRemove=_.debounce(this.onAddRemove.bind(this),10),this.listenTo(this.collection,"add remove reset",this.onAddRemove),this.onChange=_.debounce(this.onChange.bind(this),10),this.listenTo(this.collection,"change",this.onChange),this.opened=!1,r.invoke("load",this)},render:function(){return this.$el.attr("role","presentation").append($('<a href="#" class="dropdown-toggle" data-toggle="dropdown" tabindex="-1" aria-haspopup="true" aria-expanded="false" role="button">').attr("aria-label",c("Call history")).on("click",this.onOpen.bind(this)).one("click",this.onFirstOpen.bind(this)).append($.icon("fa-phone"),this.$indicator=$('<svg height="8" width="8" class="indicator" focusable="false" aria-hidden="true"><circle cx="4" cy="4" r="4"></svg>')),this.$ul=$('<ul class="dropdown-menu dropdown-menu-right" role="menu">').append(this.$header=$('<li class="header" role="separator">').append($('<div class="header-caption">').text(c("Call History")),$('<div class="header-controls">').append($('<button type="button" class="btn btn-link" data-action="all">').text(c.pgettext("call-history","All")),$('<button type="button" class="btn btn-link" data-action="missed">').text(c.pgettext("call-history","Missed")))))),this.updateIndicator(),this},onFirstOpen:function(){this.opened=!0,r.invoke("initialize",this),this.renderItems()},onOpen:function(){l.set("callHistory/lastSeen",_.now()).save(),this.updateIndicator()},onAddRemove:function(){this.updateIndicator(),this.onChange(),this.opened&&(this.removeItems(),this.renderItems())},onChange:function(){r.invoke("store",this)},renderItems:function(){this.collection.slice(-d).reverse().forEach(function(e){this.$ul.append(new p({model:e}).render().$el)},this)},updateIndicator:function(){var t=l.get("callHistory/lastSeen",0),e=this.collection.some(function(e){return e.get("missed")&&e.get("date")>t});this.$indicator.toggleClass("hidden",!e),this.$el.find(".dropdown-toggle").toggle(0<this.collection.length)},removeItems:function(){this.$ul.children().slice(1).remove()},showAll:function(e){e.stopPropagation(),this.$('.dropdown-menu > li[role="presentation"]').slideDown(300)},showMissed:function(e){e.stopPropagation(),this.$('.dropdown-menu > li[role="presentation"]:not(.missed)').slideUp(300)}}),p=e.extend({tagName:"li",className:"call-history-item",events:{"click a":"onClick"},initialize:function(){this.type=this.model.get("type"),this.listenTo(this.model,"remove",this.onRemove),this.listenTo(this.model,"change:name change:email",this.onChange),this.$el.attr("role","presentation"),this.fetchMissingData()},fetchMissingData:function(){this.model.get("name")||r.invoke("fetch",this)},updateMissingData:function(e){e&&(this.disposed||this.model.set({email:e.email1||e.email2||e.email3,name:i.getFullName(e)}))},render:function(){return this.$el.empty().attr("title",this.getTooltip()).toggleClass("missed",this.model.get("missed")).append(this.createLink().append(this.createIcon(),this.createPicture(),this.createPresence(),$("<div>").append($('<span class="date">').text(this.getDate()),$('<div class="name ellipsis">').text(this.getName())),$('<div class="caption ellipsis">').text(this.getCaption()))),this},createLink:function(){var e=$('<a href="#" role="menuitem" draggable="false">');return"phone"===this.type&&e.attr("href","callto:"+this.model.get("number")),e.attr("tabindex",this.model===_(this.model.collection.models).last()?0:-1),e},createIcon:function(){return this.model.get("missed")?$('<span class="call-icon" aria-hidden="true"><i class="fa fa-exclamation"></i></span>'):this.model.get("incoming")?$():$('<span class="call-icon" aria-hidden="true"><i class="fa fa-phone"></i><i class="fa fa-angle-double-right"></i></span>')},createPicture:function(){var e=this.model.get("email");if(!e)return $('<div class="contact-photo">');e={email:e};return t.pictureHalo($('<div class="contact-photo">'),e,{width:32,height:32})},createPresence:function(){var e=this.model.get("email");return e?n.getPresenceDot(e):$('<span class="presence">')},getTooltip:function(){var e=this.model.get("missed"),t=this.model.get("incoming"),i=this.model.get("name")||this.model.get("number")||this.model.get("email");return c(e?"Missed call from %1$s":t?"Answered call from %1$s":"You called %1$s",i)},getDate:function(){var e=this.model.get("date");return moment().isSame(e,"day")?moment(e).format("LT"):moment().isSame(e,"week")?moment(e).format("dddd"):moment(e).format("l")},getName:function(){return this.model.get("name")||this.model.get("number")||this.model.get("email")||c("Unknown")},getCaption:function(){switch(this.type){case"phone":return this.model.get("name")?this.model.get("number"):c("Unknown");case"jitsi":return"Jitsi";case"zoom":return"Zoom"}},onChange:function(){this.render()},onRemove:function(){this.$el.remove()},onClick:function(e){r.invoke("action",this,e)}}),u=/^(zoom|jitsi)$/i;return a.point("io.ox/switchboard/call-history/data").extend({id:"default",index:100,initialize:function(){o.initialize()},store:function(){var e=this.collection.toJSON().filter(function(e){return u.test(e.type)});l.set("callHistory/entries",e.slice(-d)).save()},fetch:function(){u.test(this.type)&&o.findByEmail(this.model.get("email")).done(this.updateMissingData.bind(this))},action:function(e){u.test(this.type)&&(e.preventDefault(),s.start(this.type,this.model.get("email")))}},{id:"phone",index:200,initialize:function(){},fetch:function(){"phone"===this.type&&o.findByNumber(this.model.get("number")).done(this.updateMissingData.bind(this))}}),h.view=new m({collection:h}).render(),h.lookup=o,h.settings=l,(window.callHistory=h).CallHistoryItem=p,h});