define("io.ox/notes/detail-view",["io.ox/backbone/views/disposable","io.ox/notes/api","io.ox/notes/parser","io.ox/core/notifications","io.ox/backbone/mini-views/dropdown","gettext!io.ox/notes"],function(t,n,o,e,i,s){"use strict";return t.extend({className:"abs note scrollable",events:{"click a[data-name]":"onInsert"},initialize:function(t){this.options=t||{},this.model=this.getModel(),this.$el.attr("data-cid",this.options.cid),this.listenTo(this.model,"change:html",this.renderHTML),this.listenTo(this.model,"change:last_modified",this.renderLastModified),this.listenTo(this.model,"change:title",this.renderTitle),this.listenTo(this.model,"change:preview",function(t,e){e=_.extend({},this.model.get("meta"),{note_preview:e});this.model.set("meta",e),n.update(this.options.cid,{meta:e})}),this.render().fetch(),this.$(".note-content").on("keydown",function(t){if(t.metaKey)switch(t.which){case 83:t.preventDefault(),document.execCommand("strikeThrough",!1,"true");break;case 85:t.preventDefault(),document.execCommand("underline",!1,"true")}}),this.$(".note-content").on("click","ul.todo li",function(t){0<=t.offsetX||($(this).toggleClass("checked"),$(t.delegateTarget).trigger("input"))}),this.$(".note-content").on("paste",function(t){t.preventDefault();t=(t.originalEvent.clipboardData||window.clipboardData).getData("Text");document.execCommand("inserttext",!1,t)});this.throttledUpdateContent=_.throttle(function(){this.disposed||this.updateContentImmediately()},6e4,{leading:!1}),this.updateContent=function(){this.model.set("last_modified",_.now()),this.throttledUpdateContent()},this.updateTitle=_.throttle(function(){this.disposed||this.updateTitleImmediately()},6e4,{leading:!1}),this.$(".note-content").on("input",this.updateContent.bind(this)),this.$(".note-title input").on("input",this.updateTitle.bind(this));var e=setInterval(function(){this.disposed||this.renderLastModified()}.bind(this),1e4);this.on("dispose",function(){this.stopListening(),this.updateContentImmediately(),this.updateTitleImmediately(),window.clearInterval(e)})},getModel:function(){var t=n.getModel(this.options.cid);return t||(t=new Backbone.Model,n.addToPool(t)),t},render:function(){return this.$el.append($('<div class="note-container">').append($('<div class="note-header">').append(new i({caret:!0,label:s("Insert"),className:"dropdown pull-left"}).link("insert-todo","Todo list").link("insert-ul","Bulleted list").link("insert-ol","Numbered list").divider().link("insert-image","Image").render().$el,$('<div class="note-caption pull-right">')),$('<div class="note-title">').append('<input type="text">'),$('<div class="note-content" tabindex="0" contenteditable="true" spellcheck="true">'))),this.renderLastModified(),this.renderTitle(),this.renderHTML(),this},renderLastModified:function(){var t=this.model.get("last_modified");this.$(".note-caption").text(t?s("Modified")+": "+moment(t).fromNow():" ")},renderTitle:function(){this.$(".note-title input").val(String(this.model.get("title")||"").replace(/\.txt$/i,""))},renderHTML:function(){this.$(".note-content").html(this.model.get("html")||"")},fetch:function(){var t,i;this.model.has("preview")||(t=_.cid(this.options.cid),i=this,n.get(t).done(function(t){var e;i.disposed||(e=t.data,i.model.set("preview",e.meta.note_preview,{silent:!0}),i.model.set(e).set(o.parsePlainText(t.content)))}).fail(e.yell))},updateContentImmediately:function(){var t;this.disposed||(t=o.parseHTML(this.$(".note-content"))).content!==this.model.get("content")&&(console.log("updateContentImmediately..."),this.model.set(t),n.updateContent(this.model.pick("id","folder_id","filename","preview"),t.content))},updateTitleImmediately:function(){var t;this.disposed||(t=this.$(".note-title input").val())!==this.model.get("title")&&(this.model.set("title",t),n.update(this.options.cid,{title:t}))},onInsert:function(t){var e,i=this.$(".note-content").focus()[0],n=this.getEditorRange(i);switch($(t.currentTarget).attr("data-name")){case"insert-todo":e=this.onInsertTodo();break;case"insert-ul":e=this.onInsertBulletedList();break;case"insert-ol":e=this.onInsertNumberedList();break;case"insert-image":e=this.onInsertImage()}n.insertNode(e),setTimeout(function(){n.collapse(!1),e.scrollIntoViewIfNeeded(!0),i.focus()},1)},getEditorRange:function(t){var e=window.getSelection(),i=e.getRangeAt(0);return $.contains(t,i.commonAncestorContainer)?i.deleteContents():((i=document.createRange()).selectNodeContents(t),i.collapse(!1),e.removeAllRanges(),e.addRange(i)),i},onInsertTodo:function(){return $('<ul class="todo"><li>First item</li><li>Second item</li></ul>')[0]},onInsertBulletedList:function(){return $("<ul><li>First item</li><li>Second item</li></ul>")[0]},onInsertNumberedList:function(){return $("<ol><li>First item</li><li>Second item</li></ol>")[0]},onInsertImage:function(){var t=["13894/63603","13894/63604","13894/63605","13894/63583","13894/63584","13894/63585","13894/63586","13894/63587","13894/63606","13894/63673","13894/63607","13894/63674","13894/63608","13894/63590","13894/63591","13894/63592","13894/63593","13894/63594","13894/63595","13894/63596","13894/63597","13894/63609"],t=t[Math.random()*t.length>>0];return $("<img>").attr("src","api/files?action=document&folder=13894&id="+t+"&delivery=view&scaleType=contain&width=1024")[0]}})});