define("io.ox/core/viewer/views/types/documentview",["io.ox/core/viewer/views/types/baseview","io.ox/core/viewer/views/document/thumbnailview","io.ox/core/pdf/pdfdocument","io.ox/core/pdf/pdfview","io.ox/core/tk/doc-converter-utils","io.ox/core/tk/doc-utils/pageloader","io.ox/core/viewer/util","gettext!io.ox/core","less!io.ox/core/pdf/pdfstyle"],function(e,t,i,n,o,r,a,s){"use strict";var h,d,c,l;return e.extend({initialize:function(e){a.logPerformanceTimer("DocumentView:initialize"),_.extend(this,e),this.PAGE_SIDE_MARGIN=_.device("desktop")?20:10,this.ZOOM_FACTORS=[25,35,50,75,100,125,150,200,300,400,600,800],this.currentZoomFactor=100,this.fitWidthZoomed=!1,this.fitScreenZoomed=!1,this.pdfView=null,this.pdfDocument=null,this.pageLoader=null,this.documentLoad=$.Deferred(),this.loadedPageNodes=[],this.loadMorePagesTimerId=null,this.listenTo(this.viewerEvents,"viewer:resize",this.onResize),this.listenTo(this.viewerEvents,"viewer:zoom:in",_.bind(this.changeZoomLevel,this,"increase")),this.listenTo(this.viewerEvents,"viewer:zoom:out",_.bind(this.changeZoomLevel,this,"decrease")),this.listenTo(this.viewerEvents,"viewer:zoom:fitwidth",_.bind(this.changeZoomLevel,this,"fitwidth")),this.listenTo(this.viewerEvents,"viewer:zoom:fitheight",_.bind(this.changeZoomLevel,this,"fitheight")),this.listenTo(this.viewerEvents,"viewer:beforeclose",this.onBeforeClose),this.listenTo(this.viewerEvents,"viewer:document:scrolltopage",this.onScrollToPage),this.listenTo(this.viewerEvents,"viewer:document:next",this.onNextPage),this.listenTo(this.viewerEvents,"viewer:document:previous",this.onPreviousPage),this.listenTo(this.viewerEvents,"viewer:document:first",this.onFirstPage),this.listenTo(this.viewerEvents,"viewer:document:last",this.onLastPage),this.listenTo(this.viewerEvents,"viewer:document:print",this.onPrint),this.setZoomLevelDebounced=_.debounce(this.setZoomLevel.bind(this),1e3),this.refreshDebounced=_.debounce(this.refresh.bind(this),500),this.currentDominantPageIndex=1,this.numberOfPages=1,this.disposed=null,this.$el.addClass("swiper-slide-document"),this.doubleTapZoomed=!1,this.isPrefetched=!1,this.listenTo(ox,"app:resume app:init",function(e){this.pdfView&&("io.ox/files/detail"===e.getName()?this.pdfView.resumeRendering():this.pdfView.suspendRendering())})},onTap:function(e,t){2===t&&(this.doubleTapZoomed?this.changeZoomLevel("fitheight"):this.changeZoomLevel("original"),this.doubleTapZoomed=!this.doubleTapZoomed)},onPinch:function(e,t,i,o){switch(e){case"start":h=i;break;case"move":d=i/h,c=o.x+this.$el.scrollLeft(),l=o.y+this.$el.scrollTop(),this.documentContainer.css({"transform-origin":c+"px "+l+"px",transform:"scale("+d+")"});break;case"end":l=d*this.currentZoomFactor,l=a.minMax(l,this.getMinZoomFactor(),this.getMaxZoomFactor()),this.setZoomLevel(l),this.documentContainer.removeAttr("style");break;case"cancel":this.documentContainer.removeAttr("style")}},onScrollToPage:function(e){var t;!this.isVisible()||0<(t=this.getPageNode(e)).length&&(t=t[0].offsetTop-this.PAGE_SIDE_MARGIN,this.$el.scrollTop(t),this.viewerEvents.trigger("viewer:document:pagechange",e))},onNextPage:function(){var e=this.getDominantPage()+1;this.onScrollToPage(e)},onPreviousPage:function(){var e=this.getDominantPage()-1;this.onScrollToPage(e)},onFirstPage:function(){this.onScrollToPage(1)},onLastPage:function(){0<this.numberOfPages&&this.onScrollToPage(this.numberOfPages)},onPrint:function(){var e=o.getEncodedConverterUrl(this.model);window.open(e,"_blank")},onBeforeClose:function(){var e,t;this.isVisible()&&(e=this.model.get("id"),t=this.$el.scrollTop(),this.setInitialScrollPosition(e,t))},onScrollHandler:function(){var e=this.currentDominantPageIndex,t=this.getDominantPage();t&&(e!==t&&(this.currentDominantPageIndex=t,this.viewerEvents.trigger("viewer:blendcaption",s("Page %1$d of %2$d",this.currentDominantPageIndex,this.numberOfPages)).trigger("viewer:document:selectthumbnail",this.currentDominantPageIndex).trigger("viewer:document:pagechange",this.currentDominantPageIndex)),this.loadVisiblePages(),this.viewerEvents.trigger("viewer:blendnavigation"))},loadVisiblePages:function(){this.documentLoad.done(function(){a.logPerformanceTimer("DocumentView:loadVisiblePages");var e=this.getPagesToRender(),i=_.first(e),o=_.last(e);this.isVisible()&&(this.pageLoader.abortQueuedRequests(),this.cancelMorePagesTimer(),_.each(e,function(e){this.loadPage(e,"high")},this),this.loadMorePagesTimerId=window.setTimeout(function(){for(var e=1;e<=1;e++)0<i-e&&this.loadPage(i-e,"medium"),o+e<=this.numberOfPages&&this.loadPage(o+e,"medium")}.bind(this),50),_.each(this.loadedPageNodes,function(e,t){(t<i-1||o+1<t)&&(this.emptyPageNode(e),delete this.loadedPageNodes[t])},this))}.bind(this))},loadPage:function(e,t){var i=this.getPageNode(e),t={format:"pdf",priority:t,pageZoom:this.currentZoomFactor/100};0===i.children().length&&this.pageLoader.loadPage(i,e,t).done(function(){this.loadedPageNodes[e]=i,this.refresh(e)}.bind(this)).fail(function(){i.append($("<div>").addClass("error-message").text(s("Sorry, this page is not available at the moment.")))})},refresh:function(e,t){var i,o;0<this.numberOfPages&&(i=this,_.isNumber(e)?(o=this.getPageNode(e),a.logPerformanceTimer("DocumentView:refresh_before_set_pagezoom_"+e),this.pageLoader.setPageZoom(o,this.currentZoomFactor/100).done(function(){a.logPerformanceTimer("DocumentView:refresh_then_from_set_pagezoom_"+e)})):this.pages.detach().each(function(){i.emptyPageNode($(this)),a.logPerformanceTimer("DocumentView:refresh_before_set_pagezoom_"+e),i.pageLoader.setPageZoom($(this),i.currentZoomFactor/100).done(function(){a.logPerformanceTimer("DocumentView:refresh_then_from_set_pagezoom_"+e)})}).appendTo(i.documentContainer),_.isNumber(t)&&this.onScrollToPage(t),e||this.loadVisiblePages())},cancelMorePagesTimer:function(){this.loadMorePagesTimerId&&(window.clearTimeout(this.loadMorePagesTimerId),this.loadMorePagesTimerId=null)},emptyPageNode:function(e){e&&e.data("data-rendertype","").css({visibility:"visible"}).empty()},render:function(){return this.documentContainer=$('<div class="document-container io-ox-core-pdf">'),this.$el.empty(),this},prefetch:function(e){return e&&1===e.priority&&($.ajax({url:o.getEncodedConverterUrl(this.model,{async:!0}),dataType:"text"}),this.isPrefetched=!0),this},getDominantPage:function(){var e=this.getPagesToRender(),o=this.currentZoomFactor/2,s=null,n=this;return e.forEach(function(e){var t=n.pages[e-1].getBoundingClientRect(),i=n.$el.innerHeight()/2;t.top+o<=i&&t.bottom-o>=i&&(s=e)}),s||e[0]},getPagesToRender:function(){var o=[];return _.each(this.pages,function(e,t){function i(e){return 0<=e&&e<=window.innerHeight}(i((e=(e=e).getBoundingClientRect()).top)||i(e.bottom)||e.top<0&&e.bottom>window.innerHeight)&&o.push(t+1)}),o},getPageNode:function(e){return 0<e?this.documentContainer.children().eq(e-1):$()},getPageNumber:function(e){e=e&&e.attr("data-page");return parseInt(e,10)},clearPdfDocumentWaitMessage:function(){clearTimeout(this.PdfDocumentWaitTimer)},startPdfDocumentWaitMessage:function(){this.PdfDocumentWaitTimer=window.setTimeout(function(){this.displayDownloadNotification(s("Your preview is being generated."),"io-ox-busy immediate",s("\n Alternatively you can download the file."))}.bind(this),5e3)},show:function(){if(a.logPerformanceTimer("DocumentView:show"),!this.disposed){if(!(0<this.$el.find(".document-page").length)){if((e=(e=this.model).get("meta"))&&"passwordProtected"===e.document_conversion_error)return this.displayDownloadNotification(o.getErrorText("passwordProtected"),"fa-lock"),this.documentLoad.reject(),this;var e,t=o.getEncodedConverterUrl(this.model);this.$el.empty(),this.pdfDocument=new i(t),this.clearPdfDocumentWaitMessage(),this.startPdfDocumentWaitMessage(),this.$el.busy({immediate:!0});t=$.when(this.pdfDocument.getLoadPromise());return t.done(function(){a.logPerformanceTimer("DocumentView:show_getLoadPromise_done_handler")}),t.always(function(){this.clearPdfDocumentWaitMessage()}.bind(this)),t.then(function(i){if(!this.disposed&&this.pdfDocument){if(_.isNumber(i)){this.documentContainer.enableTouch({tapHandler:this.onTap.bind(this),pinchHandler:this.onPinch.bind(this)}),this.$el.empty().append(this.documentContainer);var o=this.getInitialScrollPosition(this.model.get("id"))||0;return require(["io.ox/core/pdf/pdfviewerlinkservice"]).then(function(e){var t=this.viewerEvents,e=new e({externalLinkTarget:2});e.setDocument(this.pdfDocument.getPDFJSDocument()),this.numberOfPages=i,this.pdfView=new n(this.pdfDocument,{textOverlay:!0,annotationsOverlay:!0,linkService:e}),e.setViewer({scrollPageIntoView:function(e){e&&e.pageNumber&&t.trigger("viewer:document:scrolltopage",e.pageNumber)}}),this.pageLoader=new r(this.pdfDocument,this.pdfView),this.currentZoomFactor=this.getInitialZoomLevel(this.model.get("id"))||this.getDefaultZoomFactor(),_.times(i,function(e){var t=$('<div class="document-page">').attr("data-page",e+1),e=this.pdfView.getRealPageSize(e+1,this.currentZoomFactor/100);this.documentContainer.append(t.attr(e).css(e))},this),this.pages=this.$el.find(".document-page"),this.loadVisiblePages(),this.$el.addClass("swiper-no-swiping"),this.$el.on("scroll",_.debounce(this.onScrollHandler.bind(this),50)),this.$el.scrollTop(o),this.currentDominantPageIndex=this.getDominantPage()||1,this.viewerEvents.trigger("viewer:document:selectthumbnail",this.currentDominantPageIndex).trigger("viewer:document:loaded").trigger("viewer:document:pagechange",this.currentDominantPageIndex,i),this.$el.idle(),this.documentLoad.resolve()}.bind(this))}s.call(this,i)}}.bind(this),s.bind(this)),this}_.isEmpty(this.loadedPageNodes)&&this.loadVisiblePages()}function s(e){console.warn("Core.Viewer.DocumentView.show(): failed loading PDF document. Cause: ",e.cause);var t=o.getErrorTextFromResponse(e)||o.getErrorText("importError"),i="passwordProtected"===e.cause?"fa-lock":null;this.displayDownloadNotification(t,i),this.model.isFile()&&(e=_.extend({},this.model.get("meta"),{document_conversion_error:e.cause}),this.model.set("meta",e)),this.documentLoad.reject()}},getDefaultScale:function(){var e=this.$el.innerWidth()-2*this.PAGE_SIDE_MARGIN,t=this.pdfDocument&&this.pdfDocument.getDefaultPageSize(),t=t&&t.width;return!t||t<=e?1:n.round(e/t,.01)},getDefaultZoomFactor:function(){return 100*this.getDefaultScale()},getModeZoomFactor:function(e){var t=this.$el.width(),i=this.$el.height(),o=this.pdfDocument.getOriginalPageSize(),s=(t-40)/o.width*100,n=(i-40)/o.height*100,r=100;switch(e){case"fitwidth":r=s;break;case"fitheight":r=Math.min(s,n)}return Math.round(r)},changeZoomLevel:function(o){this.isVisible()&&this.pdfDocument.getLoadPromise().done(function(){var t=this.currentZoomFactor;switch(o){case"increase":i=_.find(this.ZOOM_FACTORS,function(e){return t<e})||this.getMaxZoomFactor(),this.resetFitZoom();break;case"decrease":var e=_.findLastIndex(this.ZOOM_FACTORS,function(e){return e<t}),i=this.ZOOM_FACTORS[e]||this.getMinZoomFactor();this.resetFitZoom();break;case"fitwidth":this.fitScreenZoomed=!1,this.fitWidthZoomed=!0,i=this.getModeZoomFactor("fitwidth");break;case"fitheight":this.fitWidthZoomed=!1,this.fitScreenZoomed=!0,i=this.getModeZoomFactor("fitheight");break;case"original":i=100,this.resetFitZoom();break;default:return}this.setZoomLevel(i)}.bind(this))},resetFitZoom:function(){this.fitScreenZoomed=!1,this.fitWidthZoomed=!1},setZoomLevel:function(e){var t,i,o;_.isNumber(e)&&this.pdfView&&this.isVisible()&&(e=a.minMax(e,this.getMinZoomFactor(),this.getMaxZoomFactor()))!==this.currentZoomFactor&&(o=this.$el.scrollTop(),t=this.$el.scrollLeft(),i=(o-(i=20*(this.getDominantPage()-1)))*e/(o=this.currentZoomFactor)+i,o=t*e/o,this.currentZoomFactor=e,this.refreshDebounced(),this.$el.scrollTop(i),this.$el.scrollLeft(o),this.setInitialZoomLevel(this.model.get("id"),e),this.viewerEvents.trigger("viewer:blendcaption",Math.round(e)+" %"))},getMaxZoomFactor:function(){return _.last(this.ZOOM_FACTORS)},getMinZoomFactor:function(){return _.first(this.ZOOM_FACTORS)},unload:function(){return this.pageLoader&&(this.pageLoader.abortQueuedRequests(),this.cancelMorePagesTimer(),this.pageLoader.destroy(),this.pageLoader=null),this.pdfView&&(this.pdfView.destroy(),this.pdfView=null),this.pdfDocument&&(this.pdfDocument.destroy(),this.pdfDocument=null),this.$el.empty(),this.isPrefetched=!1,this.PdfDocumentWaitTimer&&this.clearPdfDocumentWaitMessage(),this},onResize:function(){this.documentLoad.done(function(){var e;this.isVisible()&&(e=this.getDefaultZoomFactor(),this.fitWidthZoomed&&(e=this.getModeZoomFactor("fitwidth")),this.fitScreenZoomed&&(e=this.getModeZoomFactor("fitheight")),this.setZoomLevelDebounced(e))}.bind(this))},onDispose:function(){this.unload(),this.disposed=!0,this.$el.off(),this.$el.removeClass("swiper-slide-document"),this.thumbnailsView&&this.thumbnailsView.onDispose()}})});