define("io.ox/core/settings/errorlog/settings/pane",["io.ox/core/extensions","io.ox/backbone/views/extensible","io.ox/core/settings/util","io.ox/core/http","io.ox/core/capabilities","settings!io.ox/core","gettext!io.ox/core","static/3rd.party/Chart.min.js"],function(t,e,s,r,i,a,n,o){"use strict";var d;i.has("guest")||(t.point("io.ox/settings/pane/tools").extend({id:"errorlog",title:n("Error log"),ref:"io.ox/core/settings/errorlog",index:200}),t.point("io.ox/core/settings/errorlog/settings/detail").extend({index:100,id:"view",draw:function(){this.append(new e({point:"io.ox/core/settings/errorlog/settings/detail/view",model:a}).render().$el)}}),t.point("io.ox/core/settings/errorlog/settings/detail/view").extend({id:"header",index:100,render:function(){this.$el.append(s.header(n("Error log")))}},{id:"error-view",index:200,render:function(){this.$el.append((new d).render().$el)}}),d=Backbone.View.extend({tagName:"div",className:"error-log",events:{"click .nav a":"onClickTab","click .reload-statistics":"onUpdateStatistics","click .toggle-request-body":"onToggleRequestBody","click .toggle-stack-trace":"onToggleStackTrace"},initialize:function(){this.collection=r.log(),this.collection.on("add",this.onAdd,this)},onAdd:function(t){this.updateStatistics(),this.renderError(t)},onClickTab:function(t){t.preventDefault(),$(t.target).closest("a").tab("show")},onUpdateStatistics:function(t){t.preventDefault(),this.updateStatistics()},onToggleRequestBody:function(t){t.preventDefault();var e=$(t.target);e.data("visible")?e.data("visible",!1).text(n("Show request body")).next().hide():e.data("visible",!0).text(n("Hide request body")).next().show()},onToggleStackTrace:function(t){t.preventDefault();var e=$(t.target);e.data("visible")?e.data("visible",!1).text(n("Show stack trace")).next().hide():e.data("visible",!0).text(n("Hide stack trace")).next().show()},render:function(){return this.$el.empty(),this.renderSummary(),a.get("ping/enabled",!1)&&(this.renderStatistics(),this.renderChart(),this.updateStatistics()),this.renderTabs(),this.collection.each(this.renderError,this),this},getSummary:function(){return[].join(", ")},getUptime:function(){return Math.round((_.now()-ox.t0)/1e3/60)},renderSummary:function(){this.$el.append($('<section class="summary">').append($("<div>").append($.txt(n("Date")+": "+moment().format("l LT")),$.txt(", "),$.txt(n("Host")+": "),$("<b>").text(location.hostname),$.txt(", "),$.txt(n("UI version")+": "),$("<b>").text(ox.serverConfig.version),$.txt(", "),$.txt(n("Server version")+": "),$("<b>").text(ox.serverConfig.serverVersion),$.txt(", "),$.txt(n("Browser")+": "+navigator.userAgent))))},updateStatistics:function(){this.$el.find(".statistics").empty().append($("<div>").append($.txt(n("Total: %1$s requests",r.statistics.count())),$.txt(". "),$.txt(n("Average time: %1$s ms",r.statistics.avg())),$.txt(". "),$.txt(n("Loss: %1$s %",Math.round(100*r.statistics.loss()))),$.txt(". "),$.txt(n("Uptime: %1$s minutes",this.getUptime())),$.txt(".")),$("<div>").append($('<a href="#" class="reload-statistics">').text(n("Reload statistics")))),this.updateChart()},renderStatistics:function(){this.$el.append($('<section class="statistics">'))},renderChart:function(){this.$el.append($('<section class="chart">'),$('<section class="chart-description">').text(n("The blue graph shows the distribution of request durations in percent. The gray graph shows a trivial network ping to recognize slow connections.")))},updateChart:function(){var t,e,s,i;function a(e){var s=[0,0,0,0,0,0,0,0,0,0,0,0];return _(e).each(function(t){1e3<=t?s[s.length-1]++:500<=t?s[s.length-2]++:s[Math.max(1,Math.round(t/50))]++}),s=_(s).map(function(t){return Math.round(t/e.length*100)})}e=a(r.statistics.data()),s={labels:[0,"",100,"",200,"",300,"",400,"","> 0.5s","> 1s"],datasets:[{data:a(r.statistics.ping())},{data:e}]},this.$el.find(".chart").empty().append(t=_.device("smartphone")?$('<canvas width="300" height="100">'):$('<canvas width="600" height="200">')),i=t.get(0).getContext("2d"),new o(i,{type:"line",data:s,options:{legend:{display:!1},tooltips:{enabled:!1},elements:{line:{backgroundColor:"rgba(0, 136, 204, 0.15)",borderColor:"rgba(0, 136, 204, 0.80)",borderWidth:2},point:{backgroundColor:"rgba(0, 136, 204, 1)",borderColor:"#fff",radius:4}}}})},renderTabs:function(){this.$el.append($('<ul class="nav nav-tabs" role="tablist">').append($('<li class="active" role="presentation">').append($('<a href="#" data-target="#errors" role="tab">').text(n("Errors"))),$('<li role="presentation">').append($('<a href="#" data-target="#slow" role="tab">').text(n("Slow requests"))),$('<li role="presentation">').append($('<a href="#" data-target="#loss" role="tab">').text(n("Loss")))),$('<div class="tab-content">').append($('<div class="tab-pane active" id="errors">').append($('<div class="empty">').text(n("No errors"))),$('<div class="tab-pane" id="slow">').append($('<div class="empty">').text(n("No slow requests"))),$('<div class="tab-pane" id="loss">').append($('<div class="empty">').text(n("No lost requests")))))},getMessage:function(t){return t.get("error")},getID:function(t){var e=t.get("error_id"),s=t.get("code");return e?"(ID: "+e+(s?" / "+s:"")+")":""},getUrl:function(t){return t.get("url").replace(/(password\w*)=[^&#]+/g,"$1=****").replace(/%2F/g,"/").replace(/%2C/g,",")},getStrackTrace:function(t){var e=t.get("error_stack");return _.isArray(e)?e.join("\n"):""},getRequestBody:function(t){return _([t.get("params"),t.get("data")]).chain().map(function(s){if(!s)return null;try{_.isString(s)&&(s=JSON.parse(s))}catch(t){return s}return _.isObject(s)&&_(s).each(function(t,e){/password/.test(e)&&(s[e]="****")}),JSON.stringify(s,null,"  ")}).compact().uniq().value().join("\n")},getTime:function(t){return moment(t.get("timestamp")).format("l LT")},getTabId:function(t){return r.statistics.isLoss(t.get("status"))?"#loss":1e3<t.get("took")?"#slow":"#errors"},updateTab:function(t){var e,s=this.$el.find(t).children();0<s.length&&((e=this.$el.find('a[data-target="'+t+'"]')).find(".count").remove(),e.append($('<span class="count">').text(" ("+s.length+")")))},renderError:function(e){var t=this.getTabId(e),s=this;this.$el.find(t).find(".empty").remove().end().append($('<section class="error">').append($('<div class="message">').append($("<b>").text(this.getMessage(e)),$.txt(" "),$('<span class="error-id">').text(this.getID(e)),$.txt(" "),$('<span class="datetime">').text(this.getTime(e))),$('<div class="url">').text(this.getUrl(e)),$("<div>").append($('<a href="#" class="toggle-request-body" data-visible="false">').text(n("Show request body")),$('<div class="request-body">').hide().text(this.getRequestBody(e))).append(function(){var t=s.getStrackTrace(e);return t?[$('<a href="#" class="toggle-stack-trace" data-visible="false">').text(n("Show stack trace")),$('<div class="stack-trace">').hide().text(t)]:[]}))),this.updateTab(t)}}))});