define("io.ox/files/api",["io.ox/core/http","io.ox/core/folder/api","io.ox/core/api/user","io.ox/core/api/backbone","io.ox/core/api/collection-pool","io.ox/core/api/collection-loader","io.ox/core/capabilities","io.ox/core/extensions","io.ox/core/api/jobs","io.ox/core/util","io.ox/find/api","settings!io.ox/core","settings!io.ox/files","gettext!io.ox/files"],function(d,l,o,r,e,t,s,c,p,u,f,n,a,i){"use strict";var m={},g=/^application\/(force-download|binary|x-download|octet-stream|vnd|vnd.ms-word.document.12|odt|x-pdf)$/i;m.Model=r.Model.extend({constructor:function(e,t){var i;(e=e||{}).space?i={filename:e.name,file_size:e.size,file_mimetype:e.mimeType,spaceId:e.space,id:e.id,origData:e,source:"compose"}:_.isObject(e.mail)?i={filename:e.filename,file_size:e.size,file_mimetype:e.content_type,id:e.id,folder_id:e.mail.folder_id||null,origData:e,source:"mail"}:_.isNumber(e.attached)&&_.isNumber(e.module)?i={filename:e.filename,file_size:e.file_size||e.size,file_mimetype:e.file_mimetype||e.fmtType,id:e.id||e.managedId,folder_id:e.folder,module:e.module,origData:e,source:"pim"}:_.isString(e.guardUrl)||"guardDrive"===e.source||"guardMail"===e.source?(i=e).content_type&&!i.file_mimetype&&(i.file_mimetype=e.content_type):(i=e).source="drive",r.Model.call(this,i,t),this.listenTo(this,"change:com.openexchange.file.sanitizedFilename",function(e,t){var i=this.get("versions");if(i){for(var o=0;o<i.length;o++)if(i[o].version===e.get("version")){i[o]["com.openexchange.file.sanitizedFilename"]=t;break}this.set("versions",i)}})},isFolder:function(){return this.has("standard_folder")},isFile:function(){return!this.isFolder()&&this.isDriveItem()},isDriveItem:function(){return"drive"===this.get("source")||"guardDrive"===this.get("source")},isSVG:function(e){return/^image\/svg/.test(e||this.getMimeType())},isTiff:function(e){return/^image\/tif?f/.test(e||this.getMimeType())},isImage:function(e){return/^image\//.test(e||this.getMimeType())&&!this.isSVG(e)},isAudio:function(e){return/^audio\//.test(e||this.getMimeType())},isVideo:function(e){return/^video\//.test(e||this.getMimeType())},isOffice:function(e){return/^application\/(msword|excel|powerpoint|vnd\.(ms-word|ms-excel|ms-powerpoint|oasis|openxmlformats))/.test(e||this.getMimeType())},isPDF:function(e){return/^application\/pdf$/.test(e||this.getMimeType())},isZIP:function(e){return/^application\/zip$/.test(e||this.getMimeType())},isText:function(e){return/^(text\/plain|application\/rtf|text\/rtf)$/.test(e||this.getMimeType())},isWordprocessing:function(e){return/^application\/(?:msword|vnd\.(?:ms-word|openxmlformats-officedocument\.wordprocessingml|oasis\.opendocument\.text))/.test(e||this.getMimeType())},isSpreadsheet:function(e){return/^application\/(?:excel|vnd\.(?:ms-excel|openxmlformats-officedocument\.spreadsheetml|oasis\.opendocument\.spreadsheet))/.test(e||this.getMimeType())},isPresentation:function(e){return/^application\/(?:powerpoint|vnd\.(?:ms-powerpoint|openxmlformats-officedocument\.presentationml|oasis\.opendocument\.presentation))/.test(e||this.getMimeType())},isPgp:function(e){return/^application\/pgp(?:-encrypted)*$/.test(e)||this.isGuard()},isGuard:function(){return/^guard/.test(this.get("source"))},isEncrypted:function(){return this.isPgp()||/\.(grd|grd2|pgp)$/i.test(this.get("filename"))},isLocked:function(){return this.get("locked_until")>_.now()},isMailAttachment:function(){return"mail"===this.get("source")||"guardMail"===this.get("source")},isComposeAttachment:function(){return"compose"===this.get("source")},isPIMAttachment:function(){return"pim"===this.get("source")},isEmptyFile:function(){return this.isFile()&&!this.get("filename")},getDisplayName:function(){return this.get("com.openexchange.file.sanitizedFilename")||this.get("filename")||this.get("title")||""},getExtension:function(){var e=String(this.get("filename")||"").split(".");return 1===e.length?"":e.pop().toLowerCase()},getGuardExtension:function(){var e=String(this.get("filename")||"").split(".");return 2<e.length&&"pgp"===e.pop().toLowerCase()?e[e.length-1].toLowerCase():""},getMimeType:function(){var e=String(this.get("file_mimetype")).toLowerCase().split(";")[0];return"guardDrive"===this.get("source")&&this.get("meta")&&this.get("meta").OrigMime&&(e=this.get("meta").OrigMime),g.test(e)?m.mimeTypes[this.getExtension()]||e:"audio/mp3"===e?"audio/mpeg":e},getGuardMimeType:function(){var e=this.get("meta"),t=e&&e.OrigMime;return t&&!g.test(t)||(t=m.mimeTypes[this.getGuardExtension()]||this.getMimeType()),t},getFileType:function(){if(this.isFolder&&this.isFolder())return"folder";if(this.getExtension){var e=this.getExtension();for(var t in this.types)if(this.types[t].test(e))return t}return!1},getGuardType:function(){var e=this.getGuardExtension();if(e)for(var t in this.types)if(this.types[t].test(e))return t;return this.getFileType()},types:{image:/^(gif|bmp|tif?f|jpe?g|gmp|png|psd|heic?f?)$/,audio:/^(aac|mp3|m4a|m4b|ogg|opus|wav)$/,video:/^(avi|m4v|mp4|ogv|ogm|mov|mpeg|webm|wmv)$/,vcf:/^(vcf)$/,doc:/^(docx|docm|dotx|dotm|odt|ott|doc|dot|rtf)$/,xls:/^(csv|xlsx|xlsm|xltx|xltm|xlam|xls|xlt|xla|xlsb|ods|ots)$/,ppt:/^(pptx|pptm|potx|potm|ppsx|ppsm|ppam|odp|otp|ppt|pot|pps|ppa|odg|otg)$/,pdf:/^pdf$/,zip:/^(zip|tar|gz|rar|7z|bz2)$/,txt:/^(txt|md)$/,guard:/^(grd|grd2|pgp)$/},supportsPreview:function(){if(this.isEncrypted())return!1;var e=this.getMimeType();return this.isImage(e)?"thumbnail":this.isAudio(e)?"cover":!(!s.has("document_preview")||!(this.isPDF(e)||this.isOffice(e)||this.isText(e)))&&"preview"},getUrl:function(e,t){return m.getUrl(this.toJSON(),e,t)},hasWritePermissions:function(){var e=$.Deferred(),i=this.get("object_permissions")||this.get("com.openexchange.share.extendedObjectPermissions")||[],t=_(i).findWhere({entity:ox.user_id,group:!1});return!t||t&&t.bits<2?o.get().done(function(t){e.resolve(i.filter(function(e){return!0===e.group&&_.contains(t.groups,e.entity)}).reduce(function(e,t){return e||2<=t.bits},!1))}).fail(function(){e.resolve(!1)}):e.resolve(!!(t&&2<=t.bits)),e}}),m.Collection=r.Collection.extend({model:m.Model}),m.mimeTypes={jpg:"image/jpeg",jpeg:"image/jpeg",png:"image/png",gif:"image/gif",tif:"image/tiff",tiff:"image/tiff",bmp:"image/bmp",heic:"image/heic",heif:"image/heif",mp3:"audio/mpeg",ogg:"audio/ogg",opus:"audio/ogg",aac:"audio/aac",m4a:"audio/mp4",m4b:"audio/mp4",wav:"audio/wav",mp4:"video/mp4",m4v:"video/mp4",ogv:"video/ogg",ogm:"video/ogg",webm:"video/webm",wmv:"video/video/x-ms-wmv",csv:"text/csv",odc:"application/vnd.oasis.opendocument.chart",odb:"application/vnd.oasis.opendocument.database",odf:"application/vnd.oasis.opendocument.formula",odg:"application/vnd.oasis.opendocument.graphics",otg:"application/vnd.oasis.opendocument.graphics-template",odi:"application/vnd.oasis.opendocument.image",odp:"application/vnd.oasis.opendocument.presentation",otp:"application/vnd.oasis.opendocument.presentation-template",ods:"application/vnd.oasis.opendocument.spreadsheet",ots:"application/vnd.oasis.opendocument.spreadsheet-template",odt:"application/vnd.oasis.opendocument.text",odm:"application/vnd.oasis.opendocument.text-master",ott:"application/vnd.oasis.opendocument.text-template",oth:"application/vnd.oasis.opendocument.text-web",pdf:"application/pdf",xlsx:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",xlsm:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",xltx:"application/vnd.openxmlformats-officedocument.spreadsheetml.template",xltm:"application/vnd.openxmlformats-officedocument.spreadsheetml.template",pptx:"application/vnd.openxmlformats-officedocument.presentationml.presentation",pptm:"application/vnd.openxmlformats-officedocument.presentationml.presentation",ppsx:"application/vnd.openxmlformats-officedocument.presentationml.slideshow",potx:"application/vnd.openxmlformats-officedocument.presentationml.template",potm:"application/vnd.openxmlformats-officedocument.presentationml.template",docx:"application/vnd.openxmlformats-officedocument.wordprocessingml.document",docm:"application/vnd.openxmlformats-officedocument.wordprocessingml.document",dotx:"application/vnd.openxmlformats-officedocument.wordprocessingml.template",dotm:"application/vnd.openxmlformats-officedocument.wordprocessingml.template",doc:"application/msword",dot:"application/msword",xls:"application/vnd.ms-excel",xlb:"application/vnd.ms-excel",xlt:"application/vnd.ms-excel",ppt:"application/vnd.ms-powerpoint",pot:"application/vnd.ms-powerpoint",pps:"application/vnd.ms-powerpoint"},m.getExtension=function(e){var t=e&&(e["com.openexchange.file.sanitizedFilename"]||e.filename||e.title),i=String(t||"").split(".");return 2<i.length&&"pgp"===i.pop().toLowerCase()?i[i.length-1].toLowerCase():1<i.length?i.pop().toLowerCase():""},m.isText=function(e){return m.Model.prototype.types.txt.test(m.getExtension(e))},m.isPDF=function(e){return m.Model.prototype.types.pdf.test(m.getExtension(e))},m.isWordprocessing=function(e){return m.Model.prototype.types.doc.test(m.getExtension(e))},m.isPresentation=function(e){return m.Model.prototype.types.ppt.test(m.getExtension(e))},m.isSpreadsheet=function(e){return m.Model.prototype.types.xls.test(m.getExtension(e))},m.isOffice=function(e){return m.isWordprocessing(e)||m.isPresentation(e)||m.isSpreadsheet(e)},m.isImage=function(e){return m.Model.prototype.types.image.test(m.getExtension(e))},m.isAudio=function(e){return m.Model.prototype.types.audio.test(m.getExtension(e))},m.isVideo=function(e){return m.Model.prototype.types.video.test(m.getExtension(e))},m.getUrl=function(e,t,i){if(i=_.extend({scaleType:"contain"},i),e.space)return ox.apiRoot+"/mail/compose/"+e.space+"/attachments/"+e.id+"?session="+ox.session;var o="/files",r=encodeURIComponent(e.folder_id),n=encodeURIComponent(e.id),a="&user="+ox.user_id+"&context="+ox.context_id+"&sequence="+(e.last_modified||1),s="?action=document&folder="+r+"&id="+n+(void 0!==e.version&&!1!==i.version&&null!==i.version?"&version="+e.version:"")+a,d=e.filename?"/"+encodeURIComponent(e.filename):"",l=i.width&&i.height?"&scaleType="+i.scaleType+"&width="+i.width+"&height="+i.height:"",c=_([ox.user_id,ox.context_id,e.last_modified]).compact().join(".")||"";switch(c&&(s+="&"+c),i.params&&(s+="&"+_.serialize(i.params)),t){case"download":o=e.meta&&e.meta.downloadUrl||o+d+s+"&delivery=download";break;case"thumbnail":if(i.noSharding){o=e.meta&&e.meta.thumbnailUrl||o+s+"&delivery=view"+l;break}return u.getShardingRoot(e.meta&&e.meta.thumbnailUrl||o+s+"&delivery=view"+l);case"preview":if(i.noSharding){o=e.meta&&e.meta.previewUrl||o+s+"&delivery=view"+l+"&format=preview_image&content_type=image/jpeg";break}return u.getShardingRoot(e.meta&&e.meta.previewUrl||o+s+"&delivery=view"+l+"&format=preview_image&content_type=image/jpeg");case"cover":o="/image/file/mp3Cover?folder="+r+"&id="+n+l+a+"&content_type=image/jpeg&"+c;break;case"play":o=o+s+"&delivery=view";break;default:o=o+d+s+"&delivery=view"}return ox.apiRoot+o};var v=e.create("files",{Collection:m.Collection,Model:m.Model});v.add=_.wrap(v.add,function(e,t,i){_.isUndefined(i)&&(i=t,t="detail");var o=this.get(t),r=[];i=[].concat(i),"detail"===t&&i.forEach(function(e){!o.get(_.cid(e))||o.get(_.cid(e))&&o.get(_.cid(e)).get("last_modified")>=e.last_modified?e.expired=!1:(e.expired=!0,r.push(_.cid(e)))});var n=e.call(this,t,i);return 0<r.length&&o.trigger("expired_models",r),n});var h="1,2,3,5,20,23,108,700,702,703,704,705,707,711,7040",x=d.getAllColumns("files",!0),y=n.get("folder/mailattachments",{});_.isEmpty(y)?x=x.replace(",7030",""):h+=",7030";function w(e){if(e.data=e.data||{},e&&e.code&&("UPL-0005"===e.code||"IFO-1700"===e.code))e.data.custom={type:"error",text:i(e.error,e.error_params[0],e.error_params[1])};else if(e&&e.code&&"IFO-0100"===e.code&&e.problematic&&e.problematic[0]&&700===e.problematic[0].id)e.data.custom={type:"error",text:i("The provided filename exceeds the allowed length.")};else if(e&&e.code&&"FLS-0024"===e.code)e.data.custom={type:"error",text:i("The allowed quota is reached.")};else{if(e.error&&"abort"===e.error)return;e.data.custom={type:"error",text:i("This file could not be uploaded.")+(/^0 /.test(e.error)?"":"\n"+e.error)}}return e}function b(e){if(/^folder\./.test(e)){var t=l.pool.getModel(e.substr(7)).toJSON();return t.folder_id="folder",new m.Model(t)}return v.get("detail").get(e)}function T(e){return v.add("detail",e),v.get("detail").get(_.cid(e)).toJSON()}function M(e){return this.get(_.cid(e))}function C(e){return this.get(_.cid(e)).toJSON()}_.extend(m,Backbone.Events),m.pool=v,m.collectionLoader=new t({module:"files",getQueryParams:function(e){return!/^virtual\//.test(e.folder)&&{action:"all",folder:e.folder||n.get("folder/infostore"),columns:h,sort:e.sort||"702",order:e.order||"asc",pregenerate_previews:!1!==e.pregenerate_previews,timezone:"utc"}},fetch:function(t){var e=this.module,i=e+"/"+_.cacheKey(_.extend({session:ox.session},t)),o=ox.rampup[i],r=this.noSelect(t),n=this.virtual(t),a=this;if(o)return delete ox.rampup[i],$.when(o);r&&1===l.pool.getModel(t.folder).attributes.own_rights&&(t.tree=1,t.parent=t.folder,e="folders",t.action="list",t.columns="1,2,3,5,20,23");return n?$.when(n):d.wait().then(function(){return a.mimeTypeFilter?a.filterByMimeType(t).then(function(e){return a.filter&&(e=_(e).filter(a.filter)),a.useSlice?Array.prototype.slice.apply(e,t.limit.split(",")):e}):$.when(a.httpGet(e,t),ox.manifests.loadPluginsFor("io.ox/files/filter"))}).then(function(e){return _.isFunction(a.filter)&&(e=_(e).filter(a.filter)),e=e.filter(function(t){return c.point("io.ox/files/filter").filter(function(e){return!1!==e.invoke("isEnabled",this,t)}).map(function(e){return e.invoke("isVisible",this,t)}).reduce(function(e,t){return e&&t},!0)}),a.useSlice?Array.prototype.slice.apply(e,t.limit.split(",")):e})},httpGet:function(n,a){if("9"!==a.folder)return l.list(a.folder).then(function(t){"5"===String(a.sort)&&(t=_(t).sortBy("last_modified")),"desc"===a.order&&t.reverse();var e=a.limit.split(/,/),o=Number(e[0]),r=Number(e[1]),i=o-t.length+","+(r-t.length);return t.length>=r?t.slice(o,r):d.GET({module:n,params:_.extend({},a,{limit:i})}).then(function(e){var i=[].concat(t,new Array(Math.max(0,o-t.length)),e).slice(o,r);return i.forEach(function(e,t){i[t]=T(e)}),i},function(e){return"IFO-0400"===e.code&&0===e.error_params.length&&e.error_params.push(a.folder),m.trigger("error error:"+e.code,e),ox.debug&&console.warn("files.httpGet",e.error,e),[]})});var i=[];return l.get("virtual/favorites/infostore").then(function(t){return l.list("virtual/favorites/infostore").then(function(e){return e.length&&i.push(t),l.multipleLists(["virtual/drive/private","virtual/drive/public","virtual/filestorage"]).then(function(e){switch(s.has("share_links || invite_guests")||(e=_.filter(e,function(e){return"virtual/myshares"!==e.id})),i=i.concat(e),String(a.sort)){case"702":i=_(i).sortBy("title");break;case"5":i=_.sortBy(i,function(e){return e.last_modified?e.last_modified:0})}return"desc"===a.order&&i.reverse(),i})})})},filterByMimeType:function(a){var s=this;return l.get(a.folder).then(function(n){return l.list(a.folder).then(function(t){"5"===String(a.sort)&&(t=_(t).sortBy("last_modified")),"desc"===a.order&&t.reverse();var e=a.limit.split(/,/),o=Number(e[0]),r=Number(e[1]);if(t.length>=r)return t.slice(o,r);var i={data:{facets:[{facet:"folder",filter:null,value:a.folder},{facet:"account",filter:null,value:n.account_id},{facet:"file_type",filter:{fields:["file_extension"],queries:s.mimeTypeFilter},value:s.mimeTypeFilter}],options:{includeSubfolders:!1,sort:a.sort,order:a.order},size:r,start:o},params:{module:"files"}};return f.query(i).then(function(e){e=e.results;var i=[].concat(t,new Array(Math.max(0,o-t.length)),e).slice(o,r);return i.forEach(function(e,t){i[t]=T(e)}),s.addIndex(o,a,i),s.done(),i},function(e){return"IFO-0400"===e.code&&0===e.error_params.length&&e.error_params.push(a.folder),m.trigger("error error:"+e.code,e),ox.debug&&console.warn("files.filter",e.error,e),[]})})})},PRIMARY_PAGE_SIZE:210,SECONDARY_PAGE_SIZE:210}),m.collectionLoader.noSelect=function(e){return!l.pool.getModel(e.folder).can("read")},m.collectionLoader.each=function(e){m.pool.add("detail",e)},m.collectionLoader.setMimeTypeFilter=function(e){return!_.isEqual(m.collectionLoader.mimeTypeFilter,e)&&(m.collectionLoader.mimeTypeFilter=e,!0)},m.resolve=function(e,t){var i=_(e).chain().map(b).compact().value();return!1===t?i:_(i).invoke("toJSON")},m.get=function(t,e){if((e=_.extend({cache:!0},e)).cache){var i=v.get("detail").get(_.cid(t));if(i&&!i.get("expired")&&i.has("description"))return $.when(i.toJSON())}var o=_.extend({action:"get",id:t.id,folder:t.folder_id||t.folder,timezone:"UTC"},e.params);return e.columns&&(o.columns=e.columns),d.GET({module:"files",params:o}).then(function(e){return t.origin&&(e.origin=_.clone(t.origin)),T(e)},function(e){throw m.trigger("error error:"+e.code,e),e})},m.getAll=function(e,t){return t=_.extend({columns:h},t),d.GET({module:"files",params:_.extend({action:"all",columns:t.columns,folder:e,timezone:"UTC"},t.params)}).then(function(e){return v.add("detail",e),e},function(e){throw m.trigger("error error:"+e.code,e),e})},m.getList=function(t,i){var e=t,o=v.get("detail");return i=_.extend({cache:!0},i),0===t.length?$.when([]):(i.cache&&(e=_(t).reject(M,o)),i.fullModels&&0===e.length?$.when(_(t).map(M,o)):0===e.length?$.when(_(t).map(C,o)):d.fixList(e,d.PUT({module:"files",params:{action:"list",columns:h,timezone:"UTC"},data:d.simplify(e)})).then(function(e){return _(e.filter(Boolean)).each(T),i.fullModels?_(t).map(M,o):_(t).map(C,o)}))};function k(e,t){return d.pause(),_(e).each(function(e){d.PUT({module:"files",params:{action:t,id:e.id,folder:e.folder_id||e.folder,timezone:"UTC"},appendColumns:!1})}),d.resume()}function F(e,i){var o=v.get("detail");e.forEach(function(e){var t=o.get(_.cid(e));t&&t.set("locked_until",i)})}m.unlock=function(e){return F(e=_.isArray(e)?e:[e],0),k(e,"unlock").done(function(){m.propagate("unlock",e)})},m.lock=function(e){return F(e=_.isArray(e)?e:[e],_.now()+6e4),k(e,"lock").then(function(){return m.propagate("lock",e)})},m.clear=function(e){return v.getByFolder(e).forEach(function(e){e.expired=!0,e.reset()}),d.PUT({module:"folders",appendColumns:!1,params:{action:"clear",tree:"1"},data:[e]}).done(function(){m.propagate("clear",{folder_id:e})})},m.restore=function(e){_.isArray(e)||(e=[e]);var t=[];return _(e).each(function(e){t.push({id:e.get("id"),folder:e.get("folder_id")}),_(m.pool.collections).invoke("remove",e),e.set("unread",0)}),d.PUT({module:"infostore",params:{action:"restore",folder:"1"===t[0].id||/^default\d+/.test(t[0].id)?0:1},data:t,appendColumns:!1}).done(function(e){var t,i=[];_.each(e,function(e){t=e.path[0].id,_.contains(i,t)||i.push(t),m.trigger("refresh:listviews")})}).fail(function(){_(e).each(function(e){m.propagate("restore:fail",e.toJSON())})})};var E,S=_.debounce(function(){m.trigger("refresh:listviews")},0);function P(e){m.trigger("beforedelete",e);var t=v.get("detail"),i=_(e).map(function(e){return t.get(_.cid(e))});t.remove(i)}function U(e,t,i){d.pause();var o=_(e).where({folder_id:"folder"}),r=_(e).difference(o);return r&&0<r.length&&d.PUT({module:"files",params:{action:"move",folder:t,ignoreWarnings:i,allow_enqueue:!0},data:r,appendColumns:!1}),_(o).each(function(e){l.move(e.id,t,{ignoreWarnings:i,enqueue:!0})}),d.resume()}function j(e,i,o){return d.pause(),_(e).map(function(e){var t={action:"copy",id:e.id,folder:e.folder_id,timestamp:e.timestamp||_.then(),ignoreWarnings:o};return e.file_options&&e.file_options.params&&(t=_.extend(t,e.file_options.params)),d.PUT({module:"files",params:t,data:{folder_id:i},appendColumns:!1})}),d.resume({consolidate:"reject"})}function A(r,n,a,e){function i(e){for(var t,i=0,o=(e=_.isString(e)?[]:e)?e.length:0;i<o;i++)if(e[i].error&&"CONFLICT"!==e[i].error.categories){t=e[i].error.error;break}m.propagate(r,n,a),s.resolve(t||e)}function t(e){if(_.isArray(e)){for(var t=0;t<e.length;t++)if("CONFLICT"===e[t].error.categories)return void i(e)}else if("CONFLICT"===e.categories)return void i(e);s.reject(e)}var o="move"===r?U:j,s=$.Deferred();return d.wait(o(n,a,e)).then(function(e){"move"===r&&e&&e.length&&(e=_(e).map(function(e){if(!e.data||!e.data.job)return e;p.addJob({module:"folders",action:"update",done:!1,showIn:"infostore",id:e.data.job,successCallback:i,failCallback:t})}),0===(e=_(e).compact()).length)||i(e)},function(e){s.reject(e)}),s}function O(e,t,i){t=_.extend({addVersion:!0,folder:n.get("folder/infostore"),module:"files"},t);var o=_.extend({action:e,force_json_response:!0,timestamp:_.then()},t.params);t.filename&&(o.filename=t.filename),t.title&&(i.title=t.title),t.preview&&(i.meta=_.extend({},i.meta,{note_preview:t.preview})),"new"===e&&(o.extendedResponse=!0,o.try_add_version=!1!==t.addVersion,"newFile"===a.get("uploadHandling")&&(o.try_add_version=!1));var r=new FormData;return r.append("json",JSON.stringify(i)),r.folder=i.folder_id,"filename"in t?r.append("file",t.file,t.filename):"file"in t&&r.append("file",t.file),d.UPLOAD({module:t.module,params:o,data:r,fixPost:!0}).fail(w)}function z(e){return d.pause(),m.get(e,{cache:!1}),m.versions.load(e,{cache:!1}),d.resume().then(function(e){return!(!_.isArray(e)||!e.length)&&e[0].data})}return l.on({"before:clear":function(e){var i=String(a.get("folder/trash"))===e;_(v.getByFolder(e)).each(function(e){var t=e.filter(function(e){return i||e.isFile()});e.length===t.length?e.reset():e.remove(t)})},"remove:infostore":function(){var e=a.get("folder/trash");e&&(l.list(e,{cache:!1}),_(v.getByFolder(e)).each(function(e){e.expired=!0})),S()},"before:remove before:move":function(e){var t=v.get("detail"),i=_.cid(e);t.remove(t.get(i))},restore:function(){m.trigger("refresh:listviews")}}),m.remove=function(e,t){return P(e),d.wait(d.PUT({module:"files",params:{action:"delete",timestamp:_.then(),hardDelete:Boolean(t)},data:d.simplify(e),appendColumns:!1}).done(function(){m.propagate("remove:file",e)}))},m.move=function(e,t,i){return P(e),A("move",e,t,i)},m.copy=function(e,t,i){return A("copy",e,t,i)},m.zip=function(t){return require(["io.ox/core/download"]).then(function(e){e.url(ox.apiRoot+"/files?"+$.param({action:"zipfolder",folder:t,recursive:!0,session:ox.session}))})},m.update=function(t,e,i){if(_.isObject(e)&&!_.isEmpty(e)){var o,r=m.pool.get("detail").get(_.cid(t)),n={};r&&(r.set(e),o=Object.keys(r.changedAttributes()),_.each(o,function(e){n[e]=r.previous(e)})),i=_.extend({silent:!1},i);var a={file:e};return i.notification&&!_.isEmpty(i.notification)&&(a.notification=i.notification),d.PUT({module:"files",params:{action:"update",id:t.id,timestamp:_.then(),ignoreWarnings:i.ignoreWarnings,extendedResponse:!0},data:a,appendColumns:!1}).then(function(e){_.isObject(e)&&r&&r.get("id")!==e.id&&(r.set("id",e.id),t.id=e.id)}).always(_.lfo(function(e,t,i){i&&i.error&&e&&t&&t.set(e)},n,r)).done(function(){i.silent||m.propagate("change:file",t,e)})}},m.upload=function(n){var e=n.folder_id||n.folder,t=O("new",n,{folder_id:e,description:n.description||""}),i=t.then(function(e){var t=e.data.file,i=_(t).pick("id","folder_id"),o=t.title||t.filename;if("new_version"!==e.data.save_action)return m.propagate("add:file",i),t;var r=m.pool.get("detail").get(_.cid(i));return r&&r.set("id",t.id),!1!==n.addVersion&&"new_version"===e.data.save_action&&"announceNewVersion"===a.get("uploadHandling")&&m.trigger("add:imp_version",o),m.propagate("add:version",t)});return i.abort=t.abort,i},m.versions={upload:function(o){var e=O("update",o,{id:o.id,folder_id:o.folder_id||o.folder,version_comment:o.version_comment||""}),t=e.then(function(e){var t=e.data;if(o.id===t)return m.propagate("add:version",o);var i=m.pool.get("detail").get(_.cid(o));return i.set("id",t),m.propagate("add:version",i.toJSON())});return t.abort=e.abort,t},load:function(e,i){i=_.extend({cache:!0,adjustVersion:!1},i);var t=_.cid(e),o=v.get("detail").get(t);return o?i.cache&&o.has("versions")?$.when(o.get("versions")):d.GET({module:"files",params:{action:"versions",columns:x,folder:e.folder_id,id:e.id,timezone:"utc"},appendColumns:!0}).then(function(e){var t={versions:e,number_of_versions:e.length};return null===o.get("version")&&i.adjustVersion&&(t.version=null,_.last(e).version=null),o.set(t),e}):$.when([])},remove:function(t){var e=_.cid(t),i=v.get("detail").get(e);return i&&_.isArray(i.get("versions"))&&i.set("versions",i.get("versions").filter(function(e){return e.version!==t.version})),d.PUT({module:"files",params:{action:"detach",id:t.id,folder:t.folder_id,timestamp:_.then()},data:[t.version],appendColumns:!1}).then(function(){return m.propagate("remove:version",t)})},removePreviousVersions:function(t){var i,e=v.get("detail").get(_.cid(t)),o=e.get("versions");return o.sort(function(e,t){return e.current_version?-o.length:t.current_version?o.length:t.last_modified-e.last_modified}),e&&_.isArray(o)&&e.set("versions",o.filter(function(e){return e.version===t.version?i=!0:!!e.current_version||!(parseInt(e.version,10)<parseInt(t.version,10))&&!i})),d.PUT({module:"files",params:{action:"detach",id:t.id,folder:t.folder_id,timestamp:_.then()},data:_.difference(o,e.get("versions")).map(function(e){return e.version}),appendColumns:!1}).then(function(){m.propagate("refresh:file",_.pick(t,"id","folder_id"))})},setCurrent:function(t){var e=v.get("detail").get(_.cid(t));e&&_.isArray(e.get("versions"))&&e.set("versions",e.get("versions").map(function(e){return e.current_version=e.version===t.version,e}));var i={version:t.version};return m.update(t,i).done(function(){m.propagate("change:version",t)})},getCurrentState:function(i,e){return"boolean"==typeof i.current_version?$.when(i.current_version):m.versions.load(i,e).then(function(e){var t=!1;return _.isArray(e)&&(t=!e.length||_.some(e,function(e){return!!e.current_version&&(-1===e.number_of_versions||e.version===i.version)})),t})}},m.search=function(e,t){return t=_.extend({action:"search",columns:m.search.columns,sort:"702",order:"asc",limit:100},t),d.PUT({module:"files",params:_(t).pick("action","columns","sort","order","limit","folder","includeSubfolders"),data:m.search.getData(e,t)}).done(function(e){_(e).each(T)})},m.search.columns=h,m.search.getData=function(e){return{pattern:e}},m.propagate=(E={new:"add:file",change:"change:file",update:"change:file",delete:"remove:file"},function(e,t){var i=_.isArray(t)?t:[t];switch(l.isExternalFileStorage(t),t=_(t).pick("folder","folder_id","id","version"),e=E[e]||e,ox.debug&&console.log("files/api.propagate()",e,t,i,arguments[2]||{}),e){case"add:file":m.trigger("add:file",t),l.reload(i);break;case"restore:fail":m.trigger("restore:fail",t);break;case"add:version":case"refresh:file":return z(t).done(function(){m.trigger("add:version",t)});case"change:file":m.trigger("change:file update change:file:"+_.ecid(t)+" update:"+_.ecid(t));var o=arguments[2]||{};("title"in o||"filename"in o)&&m.propagate("rename",t),"object_permissions"in o&&m.propagate("permissions",t),"description"in o&&m.propagate("description",t);break;case"favorite:add":m.trigger("favorite:add",t);break;case"favorite:remove":m.trigger("favorite:remove",t);break;case"change:version":m.trigger("change:version",t);break;case"clear":m.trigger("clear",t.folder_id),l.reload(t.folder_id);break;case"copy":case"move":i=_.reject(i,function(e){return"folder"===e.folder_id});var r=arguments[2];m.trigger(e,i,r),l.reload(i,r),v.resetFolder(r);break;case"lock":return m.getList(i,{cache:!1});case"remove:file":l.reload(i);var n=a.get("folder/trash");n&&_(v.getByFolder(n)).each(function(e){e.expired=!0}),m.trigger("remove:file",i),_(i).each(function(e){m.trigger("remove:file:"+_.ecid(e))});break;case"remove:version":return z(t).done(function(){m.trigger("remove:version",t)});case"rename":return l.get(t.folder_id).then(function(e){if(l.isExternalFileStorage(e))return z(t).done(function(){m.trigger("rename",_.cid(t))});m.trigger("rename",_.cid(t))});case"permissions":m.trigger("change:permissions",_.cid(t));break;case"description":m.trigger("description",_.cid(t))}}),m.getDefaultColumns=function(e){var t=d.getAllColumns("files");return _([].concat(t,e)).uniq().sort().join(",")},m});