/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Julian Bäume <julian.baeume@open-xchange.com>
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 */

(function () {

    'use strict';

    //
    // Plugin functions
    //

    // this is called for each editor instance
    function init(ed) {
        var view = null, panelId = 'emoji-' + ed.id;

        // load required code now
        require(['io.ox/core/emoji/view'], function (EmojiView) {
            // create instance only once per editor
            view = new EmojiView({ editor: ed });
        });
        function renderView() {
            return '<div id="' + panelId + '">';
        }
        var recalculatePosition = _.debounce(function () {
            if (!view) return;
            var rect = view.$el.get(0).getBoundingClientRect(),
                windowHeight = $(window).height(),
                parent = view.$el.closest('.mce-container'),
                arrow = parent.find('.mce-arrow');
            if (rect.bottom > windowHeight) {
                var top = parseInt(parent.css('top'), 10); // yep kind of strange, but the container has some strange margins
                parent.css('top', (top - (rect.bottom - windowHeight)) + 'px');
            }
            arrow.toggle(rect.bottom < windowHeight);
        }, 1);

        // TODO: translate title
        ed.addButton('emoji', {
            type: 'panelbutton',
            tooltip: 'Emoticons',
            icon: 'emoticons',
            panel: {
                layout: 'grid',
                role: 'application',
                html: renderView,
                onPostRender: function () {
                    this.on('show', function () {
                        if ($('#' + panelId).is(':empty') && view) {
                            $('#' + panelId).append(view.$el);
                        }
                        if (view) {
                            view.toggle();
                            var boundingRect = view.$el.get(0).getBoundingClientRect(),
                                layoutRect = this.layoutRect();
                            layoutRect.w = boundingRect.width + layoutRect.deltaW;
                            layoutRect.innerW = layoutRect.contentW = boundingRect.width;
                            layoutRect.h = boundingRect.height + layoutRect.deltaH;
                            layoutRect.innerH = layoutRect.height = boundingRect.height;
                            this.layoutRect(layoutRect);
                            this.reflow();
                            // first reflow might reduce size to zero as some checks in tinymce will fail due to floating point comparison
                            // therefore, manually set the size manually and reflow again.
                            $(this.$el[0]).css({ width: boundingRect.width, height: boundingRect.height });
                            this.reflow();
                        }
                        recalculatePosition();
                    })
                    .on('hide', function () {
                        if (view) view.toggle();
                    });
                }
            }

        });
    }

    window.tinymce.PluginManager.add('emoji', init);

}());
