define("io.ox/backbone/views/window",["io.ox/backbone/views/disposable","io.ox/core/a11y","gettext!io.ox/core","settings!io.ox/core"],function(t,e,i,n){"use strict";function o(){s.remove(this.model),d.updateAriaAttributes()}var s=new Backbone.Collection,a="#io-ox-core",l=$('<div id="floating-window-backdrop">'),d=(new(t.extend({tagName:"ul",id:"io-ox-taskbar",className:"f6-target",attributes:{role:"toolbar","aria-label":i("Minimized windows"),"aria-hidden":!0},initialize:function(){this.listenTo(ox.ui.apps,"launch resume",this.onLaunchResume)},onLaunchResume:function(t){var e=t&&t.get("window")&&t.get("window").floating&&t.get("window").floating.model;e&&(e.set("minimized",!1),s.add(e),this.updateAriaAttributes())},addByCid:function(t){return this.add(this.$el.find('[data-cid="'+t+'"]')).show()},updateAriaAttributes:function(){var t=this.$el.find("li").filter(function(){return"none"!==$(this).css("display")}).length>0;this.$el.toggleClass("f6-target",t),t?this.$el.removeAttr("aria-hidden"):this.$el.attr("aria-hidden",!0)},add:function(t){return this.$el.append(t),this.updateAriaAttributes(),t},render:function(){return $("#io-ox-taskbar-container").empty().attr("aria-label",i("Minimized windows")).append(this.$el),this}}))).render(),h=Backbone.Model.extend({defaults:{minimized:!1,active:!0,floating:!0,lazy:!1,mode:"normal",title:"",showInTaskbar:!0,size:"width-md"},initialize:function(t){t=t||{},_.device("desktop")&&n.get("features/floatingWindows/preferredMode/enabled",!0)&&!t.mode&&t.name&&n.get("features/floatingWindows/preferredMode/apps",{})[t.name]&&this.set("mode",n.get("features/floatingWindows/preferredMode/apps",{})[t.name])}}),r=t.extend({events:{'click [data-action="minimize"]':"onMinimize",'click [data-action="close"]':"onQuit",'click [data-action="normalize"]':"toggleMode",'click [data-action="maximize"]':"toggleMode","dblclick .floating-header":"toggleMode","mousedown :not(.controls)":"activate","mousedown .floating-header":"startDrag",keydown:"onKeydown"},initialize:function(t){this.options=t||{},this.listenTo(this,"dispose",o),this.model||(this.model=new h(_(this.options).pick("title","minimized","active","closable","win","taskbarIcon","width","height","showInTaskbar","size","mode"))),this.model.set("previousFocus",document.activeElement,{silent:!0}),this.listenTo(this.model,{activate:this.activate,deactivate:this.deactivate,"change:mode":this.onChangeMode,"change:minimized":this.toggle,"change:count":this.onChangeCount,close:function(){this.$el.remove()}}),this.$body=this.options.$body||$("<div>"),this.$body=this.$el.find(".window-container-center").length>0?this.$el.find(".window-container-center"):this.$body,s.add(this.model),this.model.get("lazy")||new m({model:this.model}).render(),_.bindAll(this,"drag","stopDrag","keepInWindow","onResize"),$(window).on("resize",this.keepInWindow,this.onResize),this.listenTo(this,"dispose",function(){$(window).off("resize",this.keepInWindow)})},renderControls:function(){var t="normal"===this.model.get("mode");return $('<div class="controls" role="toolbar">').append($('<button type="button" class="btn btn-link" data-action="minimize">').attr("aria-label",i("Minimize")).append($('<i class="fa fa-window-minimize" aria-hidden="true">').attr("title",i("Minimize"))),$('<button type="button" class="btn btn-link" data-action="normalize" tabindex="-1">').attr("aria-label",i("Shrink")).append($('<i class="fa fa-compress" aria-hidden="true">').attr("title",i("Shrink"))).toggleClass("hidden",t),$('<button type="button" class="btn btn-link" data-action="maximize" tabindex="-1">').attr("aria-label",i("Maximize")).append($('<i class="fa fa-expand" aria-hidden="true">').attr("title",i("Maximize"))).toggleClass("hidden",!t),this.model.get("closable")?$('<button type="button" class="btn btn-link" data-action="close" tabindex="-1">').attr("aria-label",i("Close")).append($('<i class="fa fa-times" aria-hidden="true">').attr("title",i("Close"))):"")},onResize:function(){this.model&&(_.isBoolean(this.model.get("noOverflow"))||this.model.set("noOverflow",!0),"maximized"===this.model.get("mode")&&this.isOverfloating(this.$el)&&this.model.get("noOverflow")&&(this.model.set("onResize",!0),this.model.set("mode","normal")))},isOverfloating:function(t){return t.position().left+t.width()>document.documentElement.clientWidth||t.position().top+t.height()>document.documentElement.clientHeight||t.position().left<0||t.position().top<0},keepInWindow:function(t){if(_.isBoolean(t)||(t=!1),!(this.model.get("minimized")||this.minimizing||0===this.$el.parent().length||this.el.offsetLeft===100-this.el.offsetWidth&&0===this.el.offsetTop)){var e=Math.max(100-this.el.offsetWidth,Math.min($(a).width()-100,this.el.offsetLeft)),i=Math.max(0,Math.min($(a).height()-100,this.el.offsetTop));if(t){var n=$(a).width()-this.el.offsetWidth,o=$(a).height()-this.el.offsetHeight;n&&e>n-16&&(e=Math.max(0,n-16)),o&&i>o-16&&(i=Math.max(0,o-16))}this.$el.css({left:e+"px",top:i+"px"}),this.trigger("move")}},startDrag:function(t){this.minimizing||1===t.which&&(t.preventDefault(),this.model.set("offsetX",t.clientX-this.el.offsetLeft,{silent:!0}),this.model.set("offsetY",t.clientY-this.el.offsetTop,{silent:!0}),$(document).on("mousemove",this.drag),$(document).on("mouseup",this.stopDrag),this.lastActiveElement=$(document.activeElement),this.$el.focus(),$(a).append(l),this.$el.addClass("dragging"))},drag:function(t){this.$el.css({left:t.clientX-this.model.get("offsetX")+"px",top:t.clientY-this.model.get("offsetY")+"px"}),this.keepInWindow(),1!==t.which&&this.stopDrag()},stopDrag:function(){this.model.set("xPos",this.$el.css("left"),{silent:!0}),this.model.set("yPos",this.$el.css("top"),{silent:!0}),$(document).off("mousemove",this.drag),$(document).off("mouseup",this.stopDrag),this.lastActiveElement&&(this.lastActiveElement.focus(),this.lastActiveElement=null),l.remove(),this.$el.removeClass("dragging"),this.model.set("noOverflow",!this.isOverfloating(this.$el))},onQuit:function(){this.model.trigger("quit")},onKeydown:function(t){this.onEscape(t),this.onTab(t)},onEscape:function(t){27===t.which&&(t.isDefaultPrevented()||$(t.target).hasClass("mce-panel")||$(t.target).hasClass("mce-content-body")||$(t.target).hasClass("token-input")||this.onQuit())},onTab:function(t){9===t.which&&e.trapFocus(this.$el,t)},open:function(){return $(a).append(this.$el),this.$el.focus(),this.activate({firstTime:!0}),this},onChangeMode:function(){if(!this.minimizing){var t="normal"===this.model.get("mode"),e=this.el.offsetLeft,i=this.el.offsetWidth;if(this.$('[data-action="normalize"]').toggleClass("hidden",t),this.$('[data-action="maximize"]').toggleClass("hidden",!t),this.$el.removeClass("normal maximized").addClass(this.model.get("mode")),this.$el.css({height:"",width:""}),this.model.set({initialWidth:this.el.offsetWidth,initialHeight:this.el.offsetHeight}),$(window).trigger("changefloatingstyle"),this.model.get("onResize"))this.$el.css("left",e),this.model.set("onResize",!1);else{var o=e/(document.documentElement.clientWidth-i),s=this.el.offsetWidth-i;this.$el.css("left",e-o*s)}if(_.device("desktop")&&n.get("features/floatingWindows/preferredMode/enabled",!0)&&this.model.get("name")){var a=n.get("features/floatingWindows/preferredMode/apps",{});a[this.model.get("name")]=this.model.get("mode"),n.set("features/floatingWindows/preferredMode/apps",a).save()}this.keepInWindow("maximized"===this.model.get("mode")),_.defer(function(){$(window).trigger("resize")})}},toggleMode:function(){this.minimizing||this.model.set("mode","maximized"===this.model.get("mode")?"normal":"maximized")},activate:function(t){if(!this.$el.hasClass("active")){if(s.each(function(t){t.trigger("deactivate")}),this.$el.addClass("active"),this.model.set("active",!0),0!==this.$el.has(document.activeElement).length||t||e.getTabbable(this.$body).first().focus(),this.model.get("lazy"))return this.model.set("lazy",!1);this.keepInWindow(),t&&t.firstTime&&"maximized"===this.model.get("mode")&&this.$el.css("top",Math.max(0,Math.min(32,$(a).height()-this.$el.height()))),ox.trigger("change:document:title",this.model.get("title"))}},deactivate:function(){this.$el.removeClass("active"),this.model.set("active",!1)},setTitle:function(t){return this.title=t,this.$header.find("h1 .title").text(t||" "),this.model.set("title",t),this},onChangeCount:function(){this.$header.find("h1 .count").toggle(this.model.get("count")>0).text(this.model.get("count"))},minimize:function(){var t=ox.ui.App.getCurrentApp();t&&t.get("title")&&ox.trigger("change:document:title",t.get("title")),this.model.set("minimized",!0),this.minimizing=!1,this.$el.css({left:this.model.get("xPos"),top:this.model.get("yPos")})},onMinimize:function(){if(!this.minimizing){var t=this,e=d.addByCid(this.model.cid),i="normal"===this.model.get("mode")?this.$el.width():$("body").width(),n=e.offset().left+e.width()/2-i/2,o=$("body").height()-this.$el.height()/2;this.minimizing=!0,this.$el.velocity({translateZ:0,left:n+"px",top:o+"px",scale:.2,opacity:0},{complete:function(e){var i=$(e).data("velocity");i.transformCache={},$(e).removeAttr("style").data("velocity",i),t.minimize(),t.minimizing=!1}})}},toggle:function(t,e){if(this.$el.toggle(!e),e)return this.deactivate();this.activate()},render:function(){var t=_.uniqueId("title");return this.$el.addClass("floating-window window-container").addClass(this.model.get("mode")).addClass(this.model.get("size")).attr({"aria-labelledby":t,tabindex:-1,role:"dialog"}).append($('<div class="abs floating-window-content" role="document">').append(this.$header=this.$header||$('<div class="floating-header abs">').append($("<h1>").append($('<span class="title">').attr("id",t).text(this.model.get("title")||" "),$('<span class="count label label-danger">').toggle(this.model.get("count")>0).text(this.model.get("count"))),this.renderControls()),$('<div class="floating-body abs">').append(this.$body))),this}}),m=t.extend({tagName:"li",attributes:{role:"presentation"},events:{'click [data-action="restore"]':"onClick"},initialize:function(){this.listenTo(this.model,{close:this.onRemove,"change:title":this.onChangeTitle,"change:count":this.onChangeCount,"change:minimized":this.onChangeMinimized})},onClick:function(){if(!this.model.get("floating")&&this.model.get("win"))return this.model.set("minimized",!1),void this.model.get("win").app.launch();this.model.set("minimized",!1),ox.trigger("change:document:title",this.model.get("title")),this.model.trigger("lazyload")},onRemove:function(){var t=this.model,i=this.$el.siblings();this.$el.velocity("fadeOut",{duration:200,complete:function(n){$(n).remove(),$(t.get("previousFocus")).is(":visible")?$(t.get("previousFocus")).focus():i.length>=1?i.first().focus():$(".folder-tree").is(":visible")?$(".folder-tree:visible .folder.selected").focus():e.focusListSelection($(".window-container:visible").first()),s.remove(t)}})},onChangeTitle:function(){var t=this.model.get("title")||"";t=t.trim(),this.$title.text(t),this.$button.attr("aria-label",t),this.model.get("minimized")||ox.trigger("change:document:title",this.model.get("title"))},onChangeCount:function(){this.$count.toggle(this.model.get("count")>0).text(this.model.get("count"))},onChangeMinimized:function(t){t=t||{},this.$el.toggle(this.model.get("minimized")),!t.isRender&&this.model.get("minimized")&&this.$el.find('[data-action="restore"]').focus(),d.updateAriaAttributes()},render:function(){return this.$el.attr("data-cid",this.model.cid).append(this.$button=$('<button type="button" class="taskbar-button" data-action="restore">').append(this.$icon=this.model.get("taskbarIcon")?$('<i class="fa" aria-hidden="true">').addClass(this.model.get("taskbarIcon")):$(),this.$title=$('<span role="presentation" class="title" aria-hidden="true">'),this.$count=$('<span role="presentation" class="count label label-danger">'),$('<span role="presentation" class="spacing">'),$('<i role="presentation" class="maximize-icon pull-right fa fa-window-maximize" aria-hidden="true">'))),this.onChangeTitle(),this.onChangeCount(),this.onChangeMinimized({isRender:!0}),d.add(this.$el),this}});return{View:r,collection:s,Model:h,TaskbarElement:m,addNonFloatingApp:function(t,e){if(t&&(!s.findWhere({appId:t.id})||!s.findWhere({appId:t.id}).get("win"))){e=e||{};var i=s.findWhere({appId:t.id});if(i?i.set("win",t.getWindow()):i=new h({floating:!1,win:t.getWindow(),title:t.getTitle()||"",closable:!0,minimized:!!e.lazyload,taskbarIcon:t.get("userContentIcon"),appId:t.id}),e.lazyload||(t.on("change:title",function(t,e){i.set("title",e)}),i.once("quit",function(){t.quit()}),t.once("quit",function(){i.trigger("close")})),s.findWhere({appId:t.id})||s.add(i),!0!==t.get("hideTaskbarEntry")){var n=t.taskbarItem||new m({model:i}).render();return t.taskbarItem=n,e.lazyload||t.getWindow().on("hide show",function(){i.set("minimized",!this.state.visible),this.state.visible||d.add(n.$el)}),n}}}}});