define("io.ox/core/viewer/views/types/documentview",["io.ox/core/viewer/views/types/baseview","io.ox/core/viewer/views/document/thumbnailview","io.ox/core/pdf/pdfdocument","io.ox/core/pdf/pdfview","io.ox/core/tk/doc-converter-utils","io.ox/core/tk/doc-utils/pageloader","io.ox/core/pdf/pdfviewerlinkservice","io.ox/core/viewer/util","gettext!io.ox/core","less!io.ox/core/pdf/pdfstyle"],function(e,t,i,o,s,n,r,a,h){"use strict";var d={general:h("An error occurred converting the document so it cannot be displayed."),passwordProtected:h("This document is password protected and cannot be displayed.")};return e.extend({initialize:function(e){a.logPerformanceTimer("DocumentView:initialize"),_.extend(this,e),this.PAGE_SIDE_MARGIN=_.device("desktop")?20:10,this.ZOOM_FACTORS=[25,35,50,75,100,125,150,200,300,400,600,800],this.currentZoomFactor=100,this.fitWidthZoomed=!1,this.fitScreenZoomed=!1,this.pdfView=null,this.pdfDocument=null,this.pageLoader=null,this.documentLoad=$.Deferred(),this.loadedPageNodes=[],this.loadMorePagesTimerId=null,this.listenTo(this.viewerEvents,"viewer:resize",this.onResize),this.listenTo(this.viewerEvents,"viewer:zoom:in",_.bind(this.changeZoomLevel,this,"increase")),this.listenTo(this.viewerEvents,"viewer:zoom:out",_.bind(this.changeZoomLevel,this,"decrease")),this.listenTo(this.viewerEvents,"viewer:zoom:fitwidth",_.bind(this.changeZoomLevel,this,"fitwidth")),this.listenTo(this.viewerEvents,"viewer:zoom:fitheight",_.bind(this.changeZoomLevel,this,"fitheight")),this.listenTo(this.viewerEvents,"viewer:beforeclose",this.onBeforeClose),this.listenTo(this.viewerEvents,"viewer:document:scrolltopage",this.onScrollToPage),this.listenTo(this.viewerEvents,"viewer:document:next",this.onNextPage),this.listenTo(this.viewerEvents,"viewer:document:previous",this.onPreviousPage),this.listenTo(this.viewerEvents,"viewer:document:first",this.onFirstPage),this.listenTo(this.viewerEvents,"viewer:document:last",this.onLastPage),this.listenTo(this.viewerEvents,"viewer:document:print",this.onPrint),this.setZoomLevelDebounced=_.debounce(this.setZoomLevel.bind(this),1e3),this.refreshDebounced=_.debounce(this.refresh.bind(this),500),this.currentDominantPageIndex=1,this.numberOfPages=1,this.disposed=null,this.$el.addClass("swiper-slide-document"),this.doubleTapZoomed=!1,this.isPrefetched=!1,this.listenTo(ox,"app:resume app:init",function(e){this.pdfView&&("io.ox/files/detail"===e.getName()?this.pdfView.resumeRendering():this.pdfView.suspendRendering())})},onTap:function(e,t){2===t&&(this.doubleTapZoomed?this.changeZoomLevel("fitheight"):this.changeZoomLevel("original"),this.doubleTapZoomed=!this.doubleTapZoomed)},onPinch:function(){var e,t,i,o,s;return function(n,r,h,d){switch(n){case"start":e=h;break;case"move":t=h/e,o=d.x+this.$el.scrollLeft(),s=d.y+this.$el.scrollTop(),this.documentContainer.css({"transform-origin":o+"px "+s+"px",transform:"scale("+t+")"});break;case"end":i=t*this.currentZoomFactor,i=a.minMax(i,this.getMinZoomFactor(),this.getMaxZoomFactor()),this.setZoomLevel(i),this.documentContainer.removeAttr("style");break;case"cancel":this.documentContainer.removeAttr("style")}}}(),onScrollToPage:function(e){if(this.isVisible()){var t=this.getPageNode(e);if(t.length>0){var i=t[0].offsetTop-this.PAGE_SIDE_MARGIN;this.$el.scrollTop(i),this.viewerEvents.trigger("viewer:document:pagechange",e)}}},onNextPage:function(){var e=this.getDominantPage()+1;this.onScrollToPage(e)},onPreviousPage:function(){var e=this.getDominantPage()-1;this.onScrollToPage(e)},onFirstPage:function(){this.onScrollToPage(1)},onLastPage:function(){this.numberOfPages>0&&this.onScrollToPage(this.numberOfPages)},onPrint:function(){var e=s.getEncodedConverterUrl(this.model);window.open(e,"_blank")},onBeforeClose:function(){if(this.isVisible()){var e=this.model.get("id"),t=this.$el.scrollTop();this.setInitialScrollPosition(e,t)}},onScrollHandler:function(){var e=this.currentDominantPageIndex,t=this.getDominantPage();t&&(e!==t&&(this.currentDominantPageIndex=t,this.viewerEvents.trigger("viewer:blendcaption",h("Page %1$d of %2$d",this.currentDominantPageIndex,this.numberOfPages)).trigger("viewer:document:selectthumbnail",this.currentDominantPageIndex).trigger("viewer:document:pagechange",this.currentDominantPageIndex)),this.loadVisiblePages(),this.viewerEvents.trigger("viewer:blendnavigation"))},loadVisiblePages:function(){this.documentLoad.done(function(){a.logPerformanceTimer("DocumentView:loadVisiblePages");var e=this.getPagesToRender(),t=_.first(e),i=_.last(e);this.isVisible()&&(this.pageLoader.abortQueuedRequests(),this.cancelMorePagesTimer(),_.each(e,function(e){this.loadPage(e,"high")},this),this.loadMorePagesTimerId=window.setTimeout(function(){for(var e=1;e<=1;e++)t-e>0&&this.loadPage(t-e,"medium"),i+e<=this.numberOfPages&&this.loadPage(i+e,"medium")}.bind(this),50),_.each(this.loadedPageNodes,function(e,o){(o<t-1||o>i+1)&&(this.emptyPageNode(e),delete this.loadedPageNodes[o])},this))}.bind(this))},loadPage:function(e,t){var i=this.getPageNode(e),o={format:"pdf",priority:t,pageZoom:this.currentZoomFactor/100};0===i.children().length&&this.pageLoader.loadPage(i,e,o).done(function(){this.loadedPageNodes[e]=i,this.refresh(e)}.bind(this)).fail(function(){i.append($("<div>").addClass("error-message").text(h("Sorry, this page is not available at the moment.")))})},refresh:function(e,t){if(this.numberOfPages>0){var i=this;if(_.isNumber(e)){var o=this.getPageNode(e);a.logPerformanceTimer("DocumentView:refresh_before_set_pagezoom_"+e),this.pageLoader.setPageZoom(o,this.currentZoomFactor/100).done(function(){a.logPerformanceTimer("DocumentView:refresh_then_from_set_pagezoom_"+e)})}else this.pages.detach().each(function(){i.emptyPageNode($(this)),a.logPerformanceTimer("DocumentView:refresh_before_set_pagezoom_"+e),i.pageLoader.setPageZoom($(this),i.currentZoomFactor/100).done(function(){a.logPerformanceTimer("DocumentView:refresh_then_from_set_pagezoom_"+e)})}).appendTo(i.documentContainer);_.isNumber(t)&&this.onScrollToPage(t),e||this.loadVisiblePages()}},cancelMorePagesTimer:function(){this.loadMorePagesTimerId&&(window.clearTimeout(this.loadMorePagesTimerId),this.loadMorePagesTimerId=null)},emptyPageNode:function(e){e&&e.data("data-rendertype","").css({visibility:"visible"}).empty()},render:function(){return this.documentContainer=$('<div class="document-container io-ox-core-pdf">'),this.documentContainer.enableTouch({tapHandler:this.onTap.bind(this),pinchHandler:this.onPinch.bind(this)}),this.$el.empty(),this},prefetch:function(e){return e&&1===e.priority&&($.ajax({url:s.getEncodedConverterUrl(this.model,{async:!0}),dataType:"text"}),this.isPrefetched=!0),this},getDominantPage:function(){var e=this.getPagesToRender(),t=this.currentZoomFactor/2,i=null,o=this;return e.forEach(function(e){var s=o.pages[e-1].getBoundingClientRect(),n=o.$el.innerHeight()/2;s.top+t<=n&&s.bottom-t>=n&&(i=e)}),i||e[0]},getPagesToRender:function(){function e(e){function t(e){return e>=0&&e<=window.innerHeight}var i=e.getBoundingClientRect();return t(i.top)||t(i.bottom)||i.top<0&&i.bottom>window.innerHeight}var t=[];return _.each(this.pages,function(i,o){e(i)&&t.push(o+1)}),t},getPageNode:function(e){return e>0?this.documentContainer.children().eq(e-1):$()},getPageNumber:function(e){var t=e&&e.attr("data-page");return parseInt(t,10)},clearPdfDocumentWaitMessage:function(){clearTimeout(this.PdfDocumentWaitTimer)},startPdfDocumentWaitMessage:function(){this.PdfDocumentWaitTimer=window.setTimeout(function(){this.displayDownloadNotification(h("Your preview is being generated."),"io-ox-busy",h("\n Alternatively you can download the file."))}.bind(this),5e3)},show:function(){function e(e){console.warn("Core.Viewer.DocumentView.show(): failed loading PDF document. Cause: ",e.cause);var t=d[e.cause]||d.general,i="passwordProtected"===e.cause?"fa-lock":null;if(this.displayDownloadNotification(t,i),this.model.isFile()){var o=_.extend({},this.model.get("meta"),{document_conversion_error:e.cause});this.model.set("meta",o)}this.documentLoad.reject()}if(a.logPerformanceTimer("DocumentView:show"),!this.disposed){if(!(this.$el.find(".document-page").length>0)){if(function(e){var t=e.get("meta");return t&&"passwordProtected"===t.document_conversion_error}(this.model))return this.displayDownloadNotification(d.passwordProtected,"fa-lock"),this.documentLoad.reject(),this;var t=s.getEncodedConverterUrl(this.model);this.$el.empty(),this.pdfDocument=new i(t),this.clearPdfDocumentWaitMessage(),this.startPdfDocumentWaitMessage(),this.$el.addClass("io-ox-busy");var h=$.when(this.pdfDocument.getLoadPromise());return h.done(function(){a.logPerformanceTimer("DocumentView:show_getLoadPromise_done_handler")}),h.always(function(){this.clearPdfDocumentWaitMessage()}.bind(this)),h.then(function(t){if(!this.disposed&&this.pdfDocument)if(_.isNumber(t)){this.$el.empty().append(this.documentContainer);var i=this.getInitialScrollPosition(this.model.get("id"))||0,s=new r({externalLinkTarget:2,pdfDocument:this.pdfDocument.getPDFJSDocument(),eventHub:this.viewerEvents});this.numberOfPages=t,this.pdfView=new o(this.pdfDocument,{textOverlay:!0,annotationsOverlay:!0,linkService:s}),this.pageLoader=new n(this.pdfDocument,this.pdfView),this.currentZoomFactor=this.getInitialZoomLevel(this.model.get("id"))||this.getDefaultZoomFactor(),_.times(t,function(e){var t=$('<div class="document-page">').attr("data-page",e+1),i=this.pdfView.getRealPageSize(e+1,this.currentZoomFactor/100);this.documentContainer.append(t.attr(i).css(i))},this),this.pages=this.$el.find(".document-page"),this.loadVisiblePages(),this.$el.addClass("swiper-no-swiping"),this.$el.on("scroll",_.debounce(this.onScrollHandler.bind(this),50)),this.$el.scrollTop(i),this.currentDominantPageIndex=this.getDominantPage()||1,this.viewerEvents.trigger("viewer:document:selectthumbnail",this.currentDominantPageIndex).trigger("viewer:document:loaded").trigger("viewer:document:pagechange",this.currentDominantPageIndex,t),this.$el.removeClass("io-ox-busy"),this.documentLoad.resolve()}else e.call(this,t)}.bind(this),e.bind(this)),this}_.isEmpty(this.loadedPageNodes)&&this.loadVisiblePages()}},getDefaultScale:function(){var e=this.$el.innerWidth()-2*this.PAGE_SIDE_MARGIN,t=this.pdfDocument&&this.pdfDocument.getDefaultPageSize(),i=t&&t.width;return!i||e>=i?1:o.round(e/i,.01)},getDefaultZoomFactor:function(){return 100*this.getDefaultScale()},getModeZoomFactor:function(e){var t=this.$el.width(),i=this.$el.height(),o=this.pdfDocument.getOriginalPageSize(),s=(t-40)/o.width*100,n=(i-40)/o.height*100,r=100;switch(e){case"fitwidth":r=s;break;case"fitheight":r=Math.min(s,n)}return Math.round(r)},changeZoomLevel:function(e){this.isVisible()&&this.pdfDocument.getLoadPromise().done(function(){var t,i=this.currentZoomFactor;switch(e){case"increase":t=_.find(this.ZOOM_FACTORS,function(e){return e>i})||this.getMaxZoomFactor(),this.resetFitZoom();break;case"decrease":var o=_.findLastIndex(this.ZOOM_FACTORS,function(e){return e<i});t=this.ZOOM_FACTORS[o]||this.getMinZoomFactor(),this.resetFitZoom();break;case"fitwidth":this.fitScreenZoomed=!1,this.fitWidthZoomed=!0,t=this.getModeZoomFactor("fitwidth");break;case"fitheight":this.fitWidthZoomed=!1,this.fitScreenZoomed=!0,t=this.getModeZoomFactor("fitheight");break;case"original":t=100,this.resetFitZoom();break;default:return}this.setZoomLevel(t)}.bind(this))},resetFitZoom:function(){this.fitScreenZoomed=!1,this.fitWidthZoomed=!1},setZoomLevel:function(e){if(_.isNumber(e)&&this.pdfView&&this.isVisible()&&(e=a.minMax(e,this.getMinZoomFactor(),this.getMaxZoomFactor()))!==this.currentZoomFactor){var t=this.$el.scrollTop(),i=this.$el.scrollLeft(),o=20*(this.getDominantPage()-1),s=this.currentZoomFactor,n=(t-o)*e/s+o,r=i*e/s;this.currentZoomFactor=e,this.refreshDebounced(),this.$el.scrollTop(n),this.$el.scrollLeft(r),this.setInitialZoomLevel(this.model.get("id"),e),this.viewerEvents.trigger("viewer:blendcaption",Math.round(e)+" %")}},getMaxZoomFactor:function(){return _.last(this.ZOOM_FACTORS)},getMinZoomFactor:function(){return _.first(this.ZOOM_FACTORS)},unload:function(){return this.pageLoader&&(this.pageLoader.abortQueuedRequests(),this.cancelMorePagesTimer(),this.pageLoader.destroy(),this.pageLoader=null),this.pdfView&&(this.pdfView.destroy(),this.pdfView=null),this.pdfDocument&&(this.pdfDocument.destroy(),this.pdfDocument=null),this.$el.empty(),this.isPrefetched=!1,this.PdfDocumentWaitTimer&&this.clearPdfDocumentWaitMessage(),this},onResize:function(){this.documentLoad.done(function(){if(this.isVisible()){var e=this.getDefaultZoomFactor();this.fitWidthZoomed&&(e=this.getModeZoomFactor("fitwidth")),this.fitScreenZoomed&&(e=this.getModeZoomFactor("fitheight")),this.setZoomLevelDebounced(e)}}.bind(this))},onDispose:function(){this.unload(),this.disposed=!0,this.$el.off(),this.$el.removeClass("swiper-slide-document"),this.thumbnailsView&&this.thumbnailsView.onDispose()}})});