/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Frank Paczynski <frank.paczynski@open-xchange.com>
 */

define('io.ox/tasks/common-extensions', [
    'io.ox/backbone/mini-views/dropdown',
    'io.ox/tasks/util',
    'io.ox/mail/util',
    'io.ox/tasks/api',
    'io.ox/core/strings',
    'gettext!io.ox/tasks'
], function (Dropdown, util, mailUtil, api, strings, gt) {

    'use strict';

    var extensions = {

        date: function (baton, options) {
            var data = baton.data, t = data.end_time || data.start_time || data.last_modified;
            if (!_.isNumber(t)) return;
            this.append(
                $('<time class="date">')
                .attr('datetime', moment(t).toISOString())
                .text(mailUtil.getDateTime(t, options))
            );
        },

        compactdate: function (baton) {
            extensions.date.call(this, baton, { fulldate: false, smart: false });
        },

        title: function (baton) {
            this.append(
                $('<div class="title">').append(
                    baton.data.title
                )
            );
        },

        progress: function (baton) {
            this.append(
                $('<div class="prog">').append(
                    gt('Progress') + ': ' + (baton.data.percent_completed || 0) + '%'
                )
            );
        },

        dueDate: (function () {

            function onClick(e) {

                e.preventDefault();
                var data = e.data.data,
                    finderId = $(e.target).val();

                ox.load(['io.ox/core/tk/dialogs', 'io.ox/core/notifications']).done(function (dialogs, notifications) {

                    var endTime = util.computePopupTime(finderId).endDate,
                        modifications = {
                            end_time: endTime,
                            id: data.id,
                            folder_id: data.folder_id || data.folder
                        };

                    //check if startDate is still valid with new endDate, if not, show dialog
                    if (data.start_time && data.start_time > endTime) {

                        var popup = new dialogs.ModalDialog()
                            .addButton('cancel', gt('Cancel'), 'cancel')
                            .addPrimaryButton('change', gt('Adjust start date'), 'changechange');
                        //text
                        popup.getBody().append(
                            $('<h4>').text(gt('Inconsistent dates')),
                            $('<div>').text(
                                //#. If the user changes the duedate of a task, it may be before the start date, which is not allowed
                                //#. If this happens the user gets the option to change the start date so it matches the due date
                                gt('The due date cannot be before start date. Adjust start date?')
                            )
                        );
                        popup.show().done(function (action) {
                            if (action === 'cancel') {
                                notifications.yell('info', gt('Canceled'));
                            } else {
                                modifications.start_time = modifications.end_time;
                                api.update(modifications).done(function () {
                                    notifications.yell('success', gt('Changed due date'));
                                });
                            }
                        });
                    } else {
                        api.update(modifications).done(function () {
                            notifications.yell('success', gt('Changed due date'));
                        });
                    }
                });
            }

            return function (baton) {

                var data = baton.first();

                var $ul = $('<ul class="dropdown-menu" role="menu">')
                    .append(
                        util.buildDropdownMenu({ bootstrapDropdown: true, daysOnly: true })
                    )
                    .on('click', 'li > a:not([data-action="close-menu"])', { data: data }, onClick);

                this.attr({
                    'aria-haspopup': 'true',
                    'data-action': 'change-due-date',
                    'data-toggle': 'dropdown',
                    'tabindex': '0'
                });

                this.append($('<i class="fa fa-caret-down" aria-hidden="true">'));

                new Dropdown({
                    el: this.parent(),
                    $toggle: this,
                    $ul: $ul
                }).render();

                this.parent().addClass('dropdown');
            };
        }())
    };

    return extensions;
});
