#!/bin/bash

set -e

ReleaseVersion=$1
buildComment=$2

PRODUCT=${PWD##*/}

cd build
# Clean buildsystem
ant -f build.xml clean antExtensionsClean cleanDeps antExtensions

# Pre release build steps
ant -f releaseNumbers.xml -DreleaseNotes="${buildComment}" -DReleaseVersion=$ReleaseVersion -DprojectSets=$PRODUCT-packages loadProjectSets increaseRevision

ant -f obs.xml      -DfullProductName=$PRODUCT -DprojectSets=$PRODUCT-packages -DReleaseVersion=$ReleaseVersion determineProject createProject deleteObsoletePackages
ant -f buildAll.xml -DfullProductName=$PRODUCT -DprojectSets=$PRODUCT-packages -DReleaseVersion=$ReleaseVersion determineProject upload
ant -f obs.xml      -DfullProductName=$PRODUCT -DprojectSets=$PRODUCT-packages -DReleaseVersion=$ReleaseVersion determineProject wait4Project
