# helper-glob [![NPM version](https://badge.fury.io/js/helper-glob.svg)](http://badge.fury.io/js/helper-glob)

> Template helper for globbing files. Works with handlebars, Lo-Dash or any template engine that supports helper functions.

## Install with [npm](npmjs.org)

```bash
npm i helper-glob --save
```

## Usage

**Lo-Dash**

```js
var _ = require('lodash');

_.template('<%= glob("files/*.txt") %>', {
  glob: require('helper-glob')
});

// glob and read files
var fs = require('fs');
_.template('<%= _.map(glob("files/*.txt"), read) %>', {
  glob: require('helper-glob'),
  read: function(fp) {
    return fs.readFileSync(fp, 'utf8');
  }
});

```

**Handlebars**

```js
var handlebars = require('handlebars');
var fs = require('fs');

handlebars.registerHelper('glob', require('helper-glob'));
handlebars.registerHelper('read', function(fp) {
  return fs.readFileSync(fp, 'utf8');
});
```

```handlebars
{{glob 'files/*.txt'}}

<!-- glob and read files using subexpressions -->
{{#each (glob "files/*.hbs")}}
  {{read .}}
{{/each}}
```

## Author

**Jon Schlinkert**
 
+ [github/helpers](https://github.com/helpers)
+ [twitter/helpers](http://twitter.com/helpers) 

## License
Copyright (c) 2014 Jon Schlinkert  
Released under the MIT license

***

_This file was generated by [verb](https://github.com/assemble/verb) on December 06, 2014. To update, run `npm i -g verb && verb`._

[assemble]: https://github.com/assemble/assemble
[generator-verb]: https://github.com/assemble/generator-verb
[handlebars-helpers]: https://github.com/assemble/handlebars-helpers/
[handlebars]: https://github.com/wycats/handlebars.js/
[helpers]: https://github.com/helpers
[Lo-Dash]: https://lodash.com/
[template]: https://github.com/jonschlinkert/template
[underscore]: https://github.com/jashkenas/underscore
[verb]: https://github.com/assemble/verb
[guide]: https://github.com/helpers/requests