// Generated by dts-bundle v0.7.3

declare module 'regexpp' {
    import * as AST from "regexpp/ast";
    import { RegExpParser } from "regexpp/parser";
    import { RegExpValidator } from "regexpp/validator";
    export { AST, RegExpParser, RegExpValidator };
    export function parseRegExpLiteral(source: string, options?: RegExpParser.Options): AST.RegExpLiteral;
    export function validateRegExpLiteral(source: string, options?: RegExpValidator.Options): void;
}

declare module 'regexpp/ast' {
    export type Node = BranchNode | LeafNode;
    export type BranchNode = RegExpLiteral | Pattern | Disjunction | Group | CapturingGroup | Quantifier | CharacterClass | LookaroundAssertion | CharacterClassRange;
    export type LeafNode = BoundaryAssertion | CharacterSet | Character | Backreference | Flags;
    export type Element = Disjunction | Group | CapturingGroup | Quantifier | CharacterClass | Assertion | CharacterSet | Character | Backreference;
    export type CharacterClassElement = EscapeCharacterSet | UnicodePropertyCharacterSet | Character | CharacterClassRange;
    export type AlternativeElement = Group | CapturingGroup | Quantifier | CharacterClass | Assertion | CharacterSet | Character | Backreference;
    export type QuantifiableElement = Group | CapturingGroup | CharacterClass | LookaheadAssertion | CharacterSet | Character | Backreference;
    export interface NodeBase {
        type: Node["type"];
        parent: Node["parent"];
        start: number;
        end: number;
        raw: string;
    }
    export interface RegExpLiteral extends NodeBase {
        type: "RegExpLiteral";
        parent: null;
        pattern: Pattern;
        flags: Flags;
    }
    export interface Pattern extends NodeBase {
        type: "Pattern";
        parent: RegExpLiteral | null;
        elements: Element[];
    }
    export interface Disjunction extends NodeBase {
        type: "Disjunction";
        parent: Pattern | Group | CapturingGroup | LookaroundAssertion;
        alternatives: AlternativeElement[][];
    }
    export interface Group extends NodeBase {
        type: "Group";
        parent: Pattern | Disjunction | Group | CapturingGroup | Quantifier | LookaroundAssertion;
        elements: Element[];
    }
    export interface CapturingGroup extends NodeBase {
        type: "CapturingGroup";
        parent: Pattern | Disjunction | Group | CapturingGroup | Quantifier | LookaroundAssertion;
        name: string | null;
        elements: Element[];
        references: Backreference[];
    }
    export type LookaroundAssertion = LookaheadAssertion | LookbehindAssertion;
    export interface LookaheadAssertion extends NodeBase {
        type: "Assertion";
        parent: Pattern | Disjunction | Group | CapturingGroup | Quantifier | LookaroundAssertion;
        kind: "lookahead";
        negate: boolean;
        elements: Element[];
    }
    export interface LookbehindAssertion extends NodeBase {
        type: "Assertion";
        parent: Pattern | Disjunction | Group | CapturingGroup | LookaroundAssertion;
        kind: "lookbehind";
        negate: boolean;
        elements: Element[];
    }
    export interface Quantifier extends NodeBase {
        type: "Quantifier";
        parent: Pattern | Disjunction | Group | CapturingGroup | LookaroundAssertion;
        min: number;
        max: number;
        greedy: boolean;
        element: QuantifiableElement;
    }
    export interface CharacterClass extends NodeBase {
        type: "CharacterClass";
        parent: Pattern | Disjunction | Group | CapturingGroup | Quantifier | LookaroundAssertion;
        negate: boolean;
        elements: CharacterClassElement[];
    }
    export interface CharacterClassRange extends NodeBase {
        type: "CharacterClassRange";
        parent: CharacterClass;
        min: Character;
        max: Character;
    }
    export type Assertion = BoundaryAssertion | LookaroundAssertion;
    export type BoundaryAssertion = EdgeAssertion | WordBoundaryAssertion;
    export interface EdgeAssertion extends NodeBase {
        type: "Assertion";
        parent: Pattern | Disjunction | Group | CapturingGroup | Quantifier | LookaroundAssertion;
        kind: "start" | "end";
    }
    export interface WordBoundaryAssertion extends NodeBase {
        type: "Assertion";
        parent: Pattern | Disjunction | Group | CapturingGroup | Quantifier | LookaroundAssertion;
        kind: "word";
        negate: boolean;
    }
    export type CharacterSet = AnyCharacterSet | EscapeCharacterSet | UnicodePropertyCharacterSet;
    export interface AnyCharacterSet extends NodeBase {
        type: "CharacterSet";
        parent: Pattern | Disjunction | Group | CapturingGroup | Quantifier | LookaroundAssertion;
        kind: "any";
    }
    export interface EscapeCharacterSet extends NodeBase {
        type: "CharacterSet";
        parent: Pattern | Disjunction | Group | CapturingGroup | Quantifier | CharacterClass | LookaroundAssertion;
        kind: "digit" | "space" | "word";
        negate: boolean;
    }
    export interface UnicodePropertyCharacterSet extends NodeBase {
        type: "CharacterSet";
        parent: Pattern | Disjunction | Group | CapturingGroup | Quantifier | CharacterClass | LookaroundAssertion;
        kind: "property";
        key: string;
        value: string | null;
        negate: boolean;
    }
    export interface Character extends NodeBase {
        type: "Character";
        parent: Pattern | Disjunction | Group | CapturingGroup | Quantifier | CharacterClass | LookaroundAssertion | CharacterClassRange;
        value: number;
    }
    export interface Backreference extends NodeBase {
        type: "Backreference";
        parent: Pattern | Disjunction | Group | CapturingGroup | Quantifier | LookaroundAssertion;
        ref: number | string;
        resolved: CapturingGroup;
    }
    export interface Flags extends NodeBase {
        type: "Flags";
        parent: RegExpLiteral | null;
        dotAll: boolean;
        global: boolean;
        ignoreCase: boolean;
        multiline: boolean;
        sticky: boolean;
        unicode: boolean;
    }
}

declare module 'regexpp/parser' {
    import { Flags, RegExpLiteral, Pattern } from "regexpp/ast";
    export namespace RegExpParser {
        interface Options {
            strict?: boolean;
            ecmaVersion?: 5 | 2015 | 2016 | 2017 | 2018;
        }
    }
    export class RegExpParser {
        constructor(options?: RegExpParser.Options);
        parseLiteral(source: string, start?: number, end?: number): RegExpLiteral;
        parseFlags(source: string, start?: number, end?: number): Flags;
        parsePattern(source: string, start?: number, end?: number, uFlag?: boolean): Pattern;
    }
}

declare module 'regexpp/validator' {
    export namespace RegExpValidator {
        interface Options {
            strict?: boolean;
            ecmaVersion?: 5 | 2015 | 2016 | 2017 | 2018;
            onLiteralEnter?(start: number): void;
            onLiteralLeave?(start: number, end: number): void;
            onFlags?(start: number, end: number, global: boolean, ignoreCase: boolean, multiline: boolean, unicode: boolean, sticky: boolean, dotAll: boolean): void;
            onPatternEnter?(start: number): void;
            onPatternLeave?(start: number, end: number): void;
            onDisjunctionEnter?(start: number): void;
            onDisjunctionLeave?(start: number, end: number): void;
            onAlternativeEnter?(start: number, index: number): void;
            onAlternativeLeave?(start: number, end: number, index: number): void;
            onGroupEnter?(start: number): void;
            onGroupLeave?(start: number, end: number): void;
            onCapturingGroupEnter?(start: number, name: string | null): void;
            onCapturingGroupLeave?(start: number, end: number, name: string | null): void;
            onQuantifier?(start: number, end: number, min: number, max: number, greedy: boolean): void;
            onLookaroundAssertionEnter?(start: number, kind: "lookahead" | "lookbehind", negate: boolean): void;
            onLookaroundAssertionLeave?(start: number, end: number, kind: "lookahead" | "lookbehind", negate: boolean): void;
            onEdgeAssertion?(start: number, end: number, kind: "start" | "end"): void;
            onWordBoundaryAssertion?(start: number, end: number, kind: "word", negate: boolean): void;
            onAnyCharacterSet?(start: number, end: number, kind: "any"): void;
            onEscapeCharacterSet?(start: number, end: number, kind: "digit" | "space" | "word", negate: boolean): void;
            onUnicodePropertyCharacterSet?(start: number, end: number, kind: "property", key: string, value: string | null, negate: boolean): void;
            onCharacter?(start: number, end: number, value: number): void;
            onBackreference?(start: number, end: number, ref: number | string): void;
            onCharacterClassEnter?(start: number, negate: boolean): void;
            onCharacterClassLeave?(start: number, end: number, negate: boolean): void;
            onCharacterClassRange?(start: number, end: number, min: number, max: number): void;
        }
    }
    export class RegExpValidator {
        constructor(options?: RegExpValidator.Options);
        validateLiteral(source: string, start?: number, end?: number): void;
        validateFlags(source: string, start?: number, end?: number): void;
        validatePattern(source: string, start?: number, end?: number, uFlag?: boolean): void;
    }
}

