/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2012 Open-Xchange Inc., Tarrytown, NY, USA. info@open-xchange.com
 *
 * @author Francisco Laguna <francisco.laguna@open-xchange.com>
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 */

define('plugins/portal/userSettings/register',
    ['io.ox/core/extensions',
     'io.ox/core/main',
     'gettext!io.ox/core'
    ], function (ext, main, gt) {

    'use strict';

    function keyClickFilter(e) {
        if (e.which === 13 || e.type === 'click') {
            if (_.isFunction(e.data.fn)) {
                e.data.fn();
            }
        }
    }

    function changeUserData() {

        require(['io.ox/core/tk/dialogs', 'io.ox/core/settings/user'], function (dialogs, users) {
            var usermodel,
                dialog = new dialogs.ModalDialog({
                    top: 60,
                    width: 900,
                    center: false,
                    maximize: true
                })
                .addPrimaryButton('save', gt('Save'))
                .addButton('discard', gt('Discard'));

            var $node = dialog.getContentNode();

            users.editCurrentUser($node).done(function (model) {
                usermodel = model;
            }).fail(function () {
                $node.append(
                    $.fail(gt('Couldn\'t load your contact data.'), function () {
                        users.editCurrentUser($node).done(function () {
                            $node.find('[data-action="discard"]').hide();
                        });
                    })
                );
            });
            dialog.show().done(function (action) {
                if (action === 'save') {
                    usermodel.save();
                }
            });
        });
    }

    function changePassword() {

        require(['io.ox/core/tk/dialogs', 'io.ox/core/http', 'io.ox/core/notifications'], function (dialogs, http, notifications) {

            var oldPass, newPass, newPass2;
            new dialogs.ModalDialog({ async: true, width: 400 })
            .header($('<h4>').text(gt('Change password')))
            .build(function () {
                this.getContentNode().append(
                    $('<label>').text(gt('Your current password')),
                    oldPass = $('<input type="password" class="input-large current-password">'),
                    $('<label>').text(gt('New password')),
                    newPass = $('<input type="password" class="input-large new-password">'),
                    $('<label>').text(gt('Repeat new password')),
                     newPass2 = $('<input type="password" class="input-large repeat-new-password">'),
                    $('<div class="alert alert-block alert-info">')
                    .css('margin', '14px 0px')
                    .text(
                        gt('If you change the password, you will be signed out. Please ensure that everything is closed and saved.')
                    )
                );
            })
            .addPrimaryButton('change', gt('Change password and sign out'))
            .addButton('cancel', gt('Cancel'))
            .on('change', function (e, data, dialog) {
                var node = dialog.getContentNode();
                if (newPass.val() === newPass2.val()) {
                    http.PUT({
                        module: 'passwordchange',
                        params: { action: 'update' },
                        appendColumns: false,
                        data: {
                            old_password: oldPass.val(),
                            new_password: newPass.val(),
                            new_password2: newPass2.val()
                        }
                    })
                    .done(function () {
                        node.find('input[type="password"]').val('');
                        dialog.close();
                        dialog = null;
                        main.logout();
                    })
                    .fail(function (error) {
                        notifications.yell(error);
                        dialog.idle();
                        oldPass.focus();
                        dialog = null;
                    });
                } else {
                    notifications.yell('warning', gt('The two newly entered passwords do not match.'));
                    dialog.idle();
                    newPass2.focus();
                    dialog = null;
                }
            })
            .show(function () {
                oldPass.focus();
            });
        });
    }

    ext.point('io.ox/portal/widget/userSettings').extend({

        title: gt('User data'),

        preview: function () {
            var content;
            this.append(
                content = $('<div class="content">').append(
                    // user data
                    $('<div class="action" role="button" tabindex="1">').text(gt('My contact data'))
                    .on('click keypress', { fn: changeUserData }, keyClickFilter)

                )
            );
            // password
            //check for capability
            require(['io.ox/core/capabilities'], function (capabilities) {
                if (capabilities.has('edit_password')) {
                    content.append(
                        $('<div class="action" role="button" tabindex="1">').text(gt('My password'))
                        .on('click keypress', { fn: changePassword}, keyClickFilter)
                    );
                }
            });
        }
    });

    ext.point('io.ox/portal/widget/userSettings/settings').extend({
        title: gt('User data'),
        type: 'userSettings',
        editable: false,
        unique: true
    });

    return {
        changePassword: function (e) {
            if (e && e.preventDefault) e.preventDefault();
            require(['io.ox/core/capabilities'], function (capabilities) {
                if (capabilities.has('edit_password')) changePassword();
            });
        }
    };
});
