/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2011 Open-Xchange Inc., Tarrytown, NY, USA. info@open-xchange.com
 *
 * @author Daniel Dickhaus <daniel.dickhaus@open-xchange.com>
 */

define('plugins/portal/tasks/register',
    ['io.ox/core/extensions',
     'io.ox/tasks/api',
     'gettext!plugins/portal',
     'io.ox/tasks/util'
    ], function (ext, taskAPI, gt, util) {

    'use strict';

    ext.point('io.ox/portal/widget/tasks').extend({

        title: gt('Tasks'),

        initialize: function () {
            taskAPI.on('update create delete', function () {
                require(['io.ox/portal/main'], function (portal) {//refresh portal
                    var portalApp = portal.getApp(),
                        portalModel = portalApp.getWidgetCollection()._byId.tasks_0;
                    if (portalModel) {
                        portalApp.refreshWidget(portalModel, 0);
                    }
                });

            });
        },

        action: function () {
            ox.launch('io.ox/tasks/main');
        },

        load: function (baton) {
            return taskAPI.getAllMyTasks().done(function (data) { // super special getAll method
                baton.data = data;
            });
        },

        preview: function (baton) {

            var content = $('<div class="content">'),
                tasks;

            tasks = _(baton.data).filter(function (task) {
                return task.end_date !== null && task.status !== 3;
            });

            if (tasks.length === 0) {
                this.append(
                    content.text(gt('You don\'t have any tasks that are either due soon or overdue.'))
                );
                return;
            }

            _(tasks.slice(0, 10)).each(function (task) {
                task = util.interpretTask(task);
                content.append(
                    $('<div class="item">').data('item', task).append(
                        $('<span class="bold">').text(gt.noI18n(_.ellipsis(task.title, {max: 50}))), $.txt(' '),
                        task.end_date === '' ? $() :
                            $('<span class="accent">').text(
                                //#. Due on date
                                gt('Due on %1$s', _.noI18n(task.end_date))
                            ),
                        $.txt(' '),
                        $('<span class="gray">').text(gt.noI18n(_.ellipsis(task.note, {max: 100})))
                    )
                );
            });

            this.append(content);
        },

        draw: function (baton) {
            var popup = this.busy();
            require(['io.ox/tasks/view-detail', 'io.ox/tasks/api'], function (view, api) {
                var obj = api.reduce(baton.item);
                api.get(obj).done(function (data) {
                    popup.idle().append(view.draw(data));
                });
            });
        }
    });

    ext.point('io.ox/portal/widget/tasks/settings').extend({
        title: gt('Tasks'),
        type: 'tasks',
        editable: false,
        unique: true
    });
});
