var sys  = require('sys'),
    file = require('./file');

this.name = 'coverage-report-plain';

function lpad(str, width) {
    str = String(str);
    var n = width - str.length;

    if (n < 1) {
        return str;
    }
    
    while (n--) {
        str = ' ' + str;
    }

    return str;
}


this.report = function (coverageMap) {
    for (var filename in coverageMap) {
        if (coverageMap.hasOwnProperty(filename)) {
            var data = file.coverage(filename, coverageMap[filename]);
            
            sys.print(filename + ":\n");
            sys.print("[ hits: " + data.hits + ", misses: " + data.misses);
            sys.print(", sloc: " + data.sloc + ", coverage: " + data.coverage.toFixed(2) + "% ]\n");

            for (var i = 0; i < data.source.length; i++) {
                sys.print(lpad(data.source[i].coverage, 5) + " | " + data.source[i].line + "\n");
            }
            
            sys.print("\n");
        }
    }
};