
# norootforbuild

#!BuildIgnore: post-build-checks
Name:           oxldapsync
BuildArch:	noarch
Version:	1.0.1
%define         ox_release 34
Release:        %{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
License:        GNU General Public License (GPL)
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        OX LDAP Sync
Requires:	perl-Text-CSV_XS, perl-Log-Log4perl, perl-Log-Dispatch, open-xchange-common
%if 0%{?suse_version}
Requires:	perl-ldap, perl-ldap-ssl
%endif
%if 0%{?rhel_version}
Requires:	perl-LDAP
%endif
#

%description

Authors:
--------
    Open-Xchange

Norbert Weinhold <norbert.weinhold@open-xchange.com>

%prep
%setup -q

%build


%install

make DESTDIR=%{buildroot} install

%post

if [ ${1:-0} -eq 2 ]; then
   OXFUNCTIONS=/opt/open-xchange/etc/oxfunctions.sh
   if [ ! -e $OXFUNCTIONS ]; then
      OXFUNCTIONS=/opt/open-xchange/lib/oxfunctions.sh
   fi
   . $OXFUNCTIONS

   for i in /opt/oxldapsync/etc/ldapsync-ads.conf /opt/oxldapsync/etc/ldapsync.conf; do
       ox_update_permissions "$i" root:root 600
   done
fi

%clean
%{__rm} -rf %{buildroot}



%files
%defattr(-,root,root)
%dir /opt/oxldapsync
%dir /opt/oxldapsync/etc
%dir /opt/oxldapsync/sbin
%dir /opt/oxldapsync/lib
%dir /var/opt/oxldapsync
%config(noreplace) %attr(600,root,root) /opt/oxldapsync/etc/ldapsync*
%config(noreplace) /opt/oxldapsync/etc/mapping*
/opt/oxldapsync/sbin/*
/opt/oxldapsync/lib/*
%doc readme
%changelog
* Fri Jan 25 2013 - choeger@open-xchange.com
 - Bugfix #24572 - Not possible to install oxldapsync with >= 6.22.0
* Thu Oct 20 2011 - choeger@open-xchange.com
 - Bugfix #17045 - oxldapsync eats all memory and does not work on SLES 10 SP3
 - Bugfix #18047 - Patch for Decorator.pm: Do not reset user GUI preferences if
   user already exist (when addguipreferences is present in mapping file).
 - Bugfix #20522 - missing ssl package dependency for oxldapsync
* Thu Dec 16 2010 - choeger@open-xchange.com
 - Bugfix: In scenarios with numeric user names, not all users
   will be synched because of a sort/search related bug in the code
* Wed Aug 04 2010 - choeger@open-xchange.com
 - Fixed usemodifytimestamp code, which did not work at all using ads
* Fri Jul 09 2010 - choeger@open-xchange.com
 - Fixed the ignorefilter code which was actually not working at all... :-(
* Fri Jun 25 2010 - choeger@open-xchange.com
 - Fixed a bunch of "uninitialized value in string" in case no admin
 user/password is provided
 - Added handling of aliases in AD proxyAddresses attribute
* Mon Jun 21 2010 - choeger@open-xchange.com
 - Bugfix #14936  - file permissions for ldapsync.conf are too open
* Sun Jun 20 2010 - norbert@sourcegarden.de
 - fixed bug #14490 Added fix when user is more than one in the same group 
 - fixed bug #14939 Patch: added configurable scope for ldap searches by h.pahl@lw-systems.de
 - fixed bug #15888 removed unlovely warning "Use of uninitialized value"
 - added modified patch #14656 groups not created when using memberAttributeIsDN=yes by camigo@aedgency.com
 - added fix for User/Decorator.pm with aliases by ehoffmann (http://www.open-xchange.com/forum/showthread.php?t=4820)
* Sat Apr 24 2010 - choeger@open-xchange.com
 - Fixed lib/OX/User/Helper.pm
   csv fields containing linebreaks will break the entire sync.
   Now using recommended way as documented in Text::CSV_XS
* Tue Feb 16 2010 - choeger@open-xchange.com
 - added anonymous ldap bind support
   contributed by Forum member friess
   http://www.open-xchange.com/forum/member.php?u=5220
* Thu Dec 03 2009 - choeger@open-xchange.com
 - updated access rights in mappings
* Wed May 27 2009 - choeger@open-xchange.com
 - fixed bug #13486 /var/opt/oxldapsync is not contained in package
* Tue May 26 2009 - norbert@sourcegarden.de
 - fixed bug #13417 Keep additional user data in global adressbook after ldap sync
 - fixed bug #13481 No error message when admin daemon is not running 
 - fixed bug #13555 sync does not work with ADS when DN contains special characters
 - added patch: "specify ldap query for users not to delete" by Carsten Hoeger
* Tue Mar 31 2009 - choeger@open-xchange.com
- tell perl to use UTF8 encoding to not break encoding when synching data
* Wed Nov 26 2008 - weinhold@rccsoftware.de
 - Bugfix for bugfix when specifying multiple aliases
* Mon Nov 17 2008 - weinhold@rccsoftware.de
 - Bugfix for bug when specifying multiple aliases
