#################################################
#
#
# User handling Helper
#
#
#################################################



package OX::User::Helper;

use OX::User::Decorator;
use OX::User;
use OX::Config::Reader;
use Text::CSV_XS;
use Data::Dumper;
use Log::Log4perl qw(:easy);

use strict;
use vars qw/ %opt /;
my $oxpath;


sub readMapping()
{
    my $self = shift;
    my $mappingfile = shift;
    
    my %hash = ();

    my $config = OX::Config::Reader::readConfig($mappingfile);

    %{$self->{"mapping_hash"}} = %$config;

    return $config;
}

 
##################


sub new {
	my $object = shift;
	my $self = {
		_contextid => shift,
		_adminuser => shift,
		_adminpass => shift,
		_oxpath => shift,
		_dontmodify => shift,
		_updateAlias => shift,
		_varoptdir => shift,
		_usetimestamp => shift,
		_updateemptyattributes => shift,
	};
	
	bless $self,$object;
	@{$self->{current_users}} = $self->getOXUserList();
	return $self;
} 
####################################################
#
# Process a user (adds or modifies it)
#
####################################################
sub processUser() {
	my $self = shift;
	my $entry = shift;
	my $sourcename = $entry->get_value($self->{mapping_hash}->{username});

	my $element = $self->finduser($sourcename, 'name');

	    
	if (defined($element))
	{
	    $self->{current_users}[$element]->{_touched} = 1;
	    my $modify = 0;

	    if ($self->{_usetimestamp} eq "yes")
	    {
		my $lasttime = $self->getLastUsertime();

		if (defined($lasttime))
		{
		    $lasttime =~ s/\D//g;
		    my $entrytime = $entry->get_value("modifyTimestamp");
		    $entrytime =~ s/^(.{14}).*$/$1/g;
		    if ($entrytime > $lasttime) 
		    {
			$modify = 1;
		    } 
		}
	    } else 
	    { 
		$modify = 1;
	    }

	    if ($modify)
	    {
		my $oxuser = OX::User->new($self->{_contextid},$self->{_adminuser},$self->{_adminpass},$self->{_oxpath},$self->{_updateAlias},$self->{mapping_hash}, $self->{_updateemptyattributes});
		$oxuser->userMod($entry, $self->{current_users}[$element]);
	    }
	}
	else
	{
	    my $oxuser = OX::User->new($self->{_contextid},$self->{_adminuser},$self->{_adminpass},$self->{_oxpath},$self->{_updateAlias},$self->{mapping_hash}, $self->{_updateemptyattributes});
	    $oxuser->userAdd($entry);
	}
}

#########################################################################
#
# Deletes all current OX users which where not touched (tried to modify)
#
#########################################################################

sub deleteNotTouchedUsers()
{
	my $self = shift;
	my $ignore_list = shift;
	
	my @users = @{$self->{current_users}};


	# List of users not to delete

	my @dontmodify = split(/,/,$self->{_dontmodify});

	for (my $i = 0; $dontmodify[$i]; $i++)
	{
	    $dontmodify[$i] =~ s/^\s+//; #remove leading spaces
	    $dontmodify[$i] =~ s/\s+$//; #remove trailing spaces
	}

	my %hash;
	@hash{@dontmodify} = ();

        if( defined($ignore_list) ) {
	    foreach my $user ( @$ignore_list ) {
		$hash{$user} = "";
	    }
	}

	foreach my $user (@users)
	{
	    if (! $user->{_touched} && ! exists($hash{$user->{name}}))
	    {
			my $oxuser = OX::User->new($self->{_contextid},$self->{_adminuser},$self->{_adminpass},$self->{_oxpath},$self->{_updateAlias},$self->{mapping_hash});
			$oxuser->userDelete($user->{name});
	    }
	}
}

####################################################################
#
# Searches index for user with specific name
#
####################################################################

sub finduser()
{
    my($self) = shift; 
    my $searchword = shift;
    my $column = shift;

    my $cnt=0;
    foreach my $user ( @{$self->{current_users}} ) {
	return $cnt if( $user->{$column} eq $searchword );
	$cnt++;
    }
    return undef;
}
################################################################
#
# Updates internal user list
#
################################################################
sub updateOXUserList()
{
    my $self = shift;

    @{$self->{current_users}} = $self->getOXUserList();
}

################################################################
#
# Gets list of current OX users in context
#
################################################################

sub getOXUserList() {
    my($self) = @_; 
    my $cmd = $self->{_oxpath}."/listuser -c ".$self->{_contextid}.((defined($self->{_adminuser}))?(" -A ".$self->{_adminuser}):("")).(defined($self->{_adminpass})?(" -P ".$self->{_adminpass}):(""))." --csv";
    my @users;
    my %columnmap;

    my $csv = Text::CSV_XS->new ({ binary => 1, eol => $/ });
    open my $io, "$cmd|" or die "$!";

    my $cnt=0;
    while (my $row = $csv->getline ($io)) 
    {
	last if ! scalar(@$row);
	my @fields = @$row;
	if( $cnt == 0 ) {
	    for (my $i=0; $fields[$i]; $i++)
	    {
	    	$columnmap{lc($fields[$i])} = $i;
	    }
	} else {
	    foreach my $columnName (keys%columnmap)
	    {
	    	$users[$cnt-1]{$columnName} = $fields[$columnmap{$columnName}];
	    }
        }
	$cnt++;
    }
    return (@users);
}

sub getLastUsertime()
{
    my $self = shift;
    my $vardir = $self->{_varoptdir};
    if (! defined($vardir)) {ERROR ("Var directory not defined! Please check configuration!\n"); die("\n"); }
    if (! -e "$vardir/timestate")
    {
         if (! -w $vardir) {ERROR ("Can not write to $vardir\n"); die("\n");};
    }

    my $timedata = OX::Config::Reader::readConfig($vardir."/timedate");
    $timedata->{usertime} = undef if (!$timedata->{usertime});

    return $timedata->{usertime};
}


1;
