######################################################
#
#
# Generates parameter strings for OX user handling
#
#
######################################################

package OX::User::Decorator;
use strict;
use warnings;
use Data::Dumper;
use Log::Log4perl qw(:easy);

############################################
#
# Well, a constructor
#
############################################

sub new {
	my $object = shift; 
	my $self = {
		   _mapping => shift,
		   _entry   => shift,
		   _updateemptyattributes => shift,
		 };

	bless($self,$object);
	return ($self);
}

###############################################
#
# Make the big user string, depends on mapping
#
###############################################

sub getUserStr() { 
	my $self = shift;
	my $updateAlias = shift;
	my $oldentry = shift;

	my $str = "";

        foreach my $key (keys%{$self->{_mapping}})
	{
	    next if $key eq "aliases";
            # Skip addguipreferences key if user already exists:
            # apply it only on new users. Do not redefine user gui settings if user already exist.
            next if $key eq "addguipreferences" && defined $oldentry;
	    if ($key eq "email")
	    {
		$str .= $self->getAliases($updateAlias, $oldentry)." ";
	    }
	    elsif ($self->{_mapping}->{$key})
	    {
		if ($self->{_mapping}->{$key} =~ m/\"/)
		{
		    $str .= "--$key $self->{_mapping}->{$key} ";	
		} else {
		    if ( $self->{_entry}->get_value($self->{_mapping}->{$key}) ) 
		    {
			$str .= "--$key \"".$self->{_entry}->get_value($self->{_mapping}->{$key})."\" ";
		    } elsif ( $self->{_updateemptyattributes} && $self->{_updateemptyattributes} eq "yes") {
			$str .= "--$key \"\" ";
		    }
		}
	    }
	}
	
	return $str; 
}

##############################################
#
# Aliases need a special handling
#
##############################################


# helper method to clean aliases from junk as used in proxyAddresses when
# using AD
sub cleanAlias() {
	my ($self) = @_;
	my $class = shift;
	my $alias = shift;
	return $alias if ! defined($alias);
	if ( $alias =~ /^(.*:)(.*)$/ ) {
	   my $rest = $2;
	   if( $1 =~ /smtp:/i ) {
		return $rest;
	   } else {
		return undef;
	   }
	}
	return $alias;
}

sub getAliases() {
	my ($self) = @_;
	my $class = shift;
	my $updateAlias = shift;
	my $oldentry = shift;
	my $aliasstr;

	if ($updateAlias)
	{
	    if (defined($oldentry))
	    {
			if ($oldentry->{primaryemail} ne $self->{_entry}->get_value($self->{_mapping}->{email}))
			{
				$aliasstr = "$oldentry->{primaryemail},".$self->{_entry}->get_value($self->{_mapping}->{email});
			}
	    }
	    
	    if ($self->{_mapping}->{'aliases'})
	    {
			my $aliases = $self->{_entry}->get_value($self->{_mapping}->{aliases}, asref => 1);
			my @cleanedAliases;
			if (ref($aliases) eq 'ARRAY'){
			       foreach my $a ( @$aliases ) {
				  my $ret = $self->cleanAlias($a); 
			          push @cleanedAliases, $ret if defined($ret);
			       }
                        } else {
                               my $ret = $self->cleanAlias($aliases);
			       push @cleanedAliases, $ret if defined($ret);
                        }
			$aliasstr = join(',',@cleanedAliases);
	    }
	    if ($aliasstr)
	    {    
		if (defined($oldentry)) {
		    if ($oldentry->{primaryemail} ne $self->{_entry}->get_value($self->{_mapping}->{email}))
		    {
			return "--aliases \"$aliasstr\" --email ".$self->{_entry}->get_value($self->{_mapping}->{email});
		    } else {
			return "--aliases \"$aliasstr\"";
		    }
		} else {
			return "--aliases \"$aliasstr\" --email ".$self->{_entry}->get_value($self->{_mapping}->{email});
		}
	    } else {
		if (! defined($oldentry)) {
			return "--email ".$self->{_entry}->get_value($self->{_mapping}->{email});
		}
	    }
	}
	return "";
}

1;
