####################################################
#
#
# Single OX User processing
#
#
####################################################


package OX::User;

use Log::Log4perl qw(:easy);
use OX::User::Decorator;
use OX::Config::Reader;
use Text::CSV_XS;
use Data::Dumper;

use strict;
use vars qw/ %opt /;
my $logger;


##################


sub new {
	my $object = shift;
	my $self = {
		_contextid => shift,
		_adminuser => shift,
		_adminpass => shift,
		_oxpath => shift,
		_updateAlias => shift,
		_mapping_hash => shift,
		_updateemptyattributes => shift,
	};
	
	bless $self,$object;
	return $self;
} 

#######################################
#
# modifies a user
#
#######################################

sub userMod() {
	my $self = shift; 
	my $entry = shift;
	my $oldentry = shift;

	if (! $self->{_mapping_hash}->{username})    { ERROR("No mapping for username given\n"); die("\n");}
	if (! $self->{_mapping_hash}->{displayname}) { ERROR("No mapping for displayname given\n"); die("\n");}
	if (! $self->{_mapping_hash}->{givenname})   { ERROR("No mapping for givenname given\n"); die("\n");}
	if (! $self->{_mapping_hash}->{surname})     { ERROR("No mapping for surname given\n"); die("\n");}
	if (! $self->{_mapping_hash}->{password})    { ERROR("No mapping for password given\n"); die("\n");}
	if (! $self->{_mapping_hash}->{email})       { ERROR("No mapping for email given\n"); die("\n");}

	my $cmd = $self->{_oxpath}.$self->getActionStringModify($entry, $oldentry);  
	my $success =  $self->exec($cmd);
	if ($success) {
	    return 1;
	}
	else
	{
	    return 0;
	}

}

#######################################
#
# Check if minimum values are set
#
#######################################
sub checkRequisites()
{
	my($self) = @_; 
	my $class = shift;
	my $entry = shift;

	if (! $self->{_mapping_hash}->{username})    { ERROR("No mapping for username given\n"); die("\n");}
	if (! $self->{_mapping_hash}->{displayname}) { ERROR("No mapping for displayname given\n");  die("\n");}
	if (! $self->{_mapping_hash}->{givenname})   { ERROR("No mapping for givenname given\n");  die("\n");}
	if (! $self->{_mapping_hash}->{surname})     { ERROR("No mapping for surname given\n");  die("\n");}
	if (! $self->{_mapping_hash}->{password})    { ERROR("No mapping for password given\n");  die("\n");}
	if (! $self->{_mapping_hash}->{email})       { ERROR("No mapping for email given\n");  die("\n");}

	my $username = $entry->get_value($self->{_mapping_hash}->{username});

        if ( $self->{_mapping_hash}->{displayname} !~ m/\"/ && (! $entry->get_value($self->{_mapping_hash}->{displayname}))) { INFO("User $username has no value for displayname\n"); return 0;}
	if ( $self->{_mapping_hash}->{givenname}   !~ m/\"/ && (! $entry->get_value($self->{_mapping_hash}->{givenname})))   { INFO("User $username has no value for givenname\n"); return 0;}
	if ( $self->{_mapping_hash}->{surname}     !~ m/\"/ && (! $entry->get_value($self->{_mapping_hash}->{surname})))     { INFO("User $username has no value for surname\n"); return 0;}
	if ( $self->{_mapping_hash}->{password}    !~ m/\"/ && (! $entry->get_value($self->{_mapping_hash}->{password})))    { INFO("User $username has no value for password\n"); return 0;}
	if ( $self->{_mapping_hash}->{email}       !~ m/\"/ && (! $entry->get_value($self->{_mapping_hash}->{email})))       { INFO("User $username has no value for email\n"); return 0;}
	
	return 1;
}

#####################################
#
# Add a user to context
#
#####################################

sub userAdd() {
	my($self) = @_; 
	my $class = shift;
	my $entry = shift;

	if (! $self->checkRequisites($entry))
	{
	    return 0;
	}

	my $cmd = $self->{_oxpath}.$self->getActionStringCreate($entry); 
	my $success =  $self->exec($cmd);
	if ($success) 
	{
	    return 1;
    	}
	else
	{
	    return 0;
	}
}

###################################
#
# Deletes a user
#
##################################

sub userDelete()
{
	my $self = shift;
	my $name = shift;

	my $cmd = $self->{_oxpath}.$self->getActionStringDelete($name);
	my $success =  $self->exec($cmd);
	if ($success) {
	    return 1;
	}
	else
	{
	    return 0;
	}
}


############################################
#
# Executes the OX Command
#
############################################

sub exec() { 
    my($self,$cmd) = @_; 

    DEBUG ($cmd);

    my $output = `$cmd 2>&1`;
    DEBUG ( $output);
    if ($? eq "0")
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

###############################################
#
# Gets the action string for modifying a user
#
###############################################
sub getActionStringModify {
	
	my($self) = @_; 
	my $class = shift;
	my $entry = shift;
	my $oldentry = shift;
	my $decorator = new OX::User::Decorator($self->{_mapping_hash}, $entry, $self->{_updateemptyattributes});

	my $adminauth = ""; 
	if( ( defined($self->{_adminuser}) && $self->{_adminuser} ne "" ) &&
	    ( defined($self->{_adminpass}) && $self->{_adminpass} ne "" ) ) { 
	    $adminauth = "-A ".$self->{_adminuser}." -P ".$self->{_adminpass};
	}
	if ($self->{_updateAlias})
	{
	    return "/changeuser -c ".$self->{_contextid}." $adminauth ".$decorator->getUserStr(1, $oldentry);
	} else {
	    return "/changeuser -c ".$self->{_contextid}." $adminauth ".$decorator->getUserStr(0);
	}
}
##############################################
#
# Gets action string for creating a user
#
##############################################
sub getActionStringCreate {
	
	my($self) = @_; 
	my $class = shift;
	my $entry = shift;
	my $decorator = new OX::User::Decorator($self->{_mapping_hash}, $entry, $self->{_updateemptyattributes});

	my $adminauth = "";
	if( ( defined($self->{_adminuser}) && $self->{_adminuser} ne "" ) &&
	    ( defined($self->{_adminpass}) && $self->{_adminpass} ne "" ) ) {
	    $adminauth = "-A ".$self->{_adminuser}." -P ".$self->{_adminpass};
	}
	return "/createuser -c ".$self->{_contextid}." $adminauth ".$decorator->getUserStr(1, undef);
}

#############################################
#
# Gets action string for deleting a user
#
#############################################
sub getActionStringDelete {
	
	my($self) = @_; 
	my $class = shift;
	my $username = shift;

	return "/deleteuser -c ".$self->{_contextid}.(($self->{_adminuser} ne "")?(" -A ".$self->{_adminuser}):("")).(($self->{_adminpass} ne "")?(" -P ".$self->{_adminpass}):(""))." -u \"".$username."\"";
}

1;
