##############################################
#
# Class for openldap handling
#
##############################################

package OX::LDAPConnector::openldap;

use strict;
use warnings;
use Data::Dumper;
use OX::LDAPConnector::ldap;
use Log::Log4perl qw(:easy);
use POSIX qw(strftime);

our @ISA = qw(OX::LDAPConnector::ldap);

############################################
#
# Just add default filter values
#
############################################
sub new()
{
    my ($class, %args) = @_;
    my $this;
    $this = $class->SUPER::new(%args);

    if (! $this->{userfilter})
    {
	$this->{userfilter} = "(objectClass=inetOrgPerson)";
    }

    if (! $this->{groupfilter})
    {
	$this->{groupfilter} = "(objectClass=posixGroup)";
    }

    bless ($this, $class);
    return $this;
}

1;