################################################################
#
#
#  Helper class for modifying groups
#
#
################################################################

package OX::Group::Helper;
 
use Log::Log4perl qw(:easy);
use OX::Group::Decorator;
use Data::Dumper;

use OX::Group;

use strict;
use warnings;

my $oxpath = "/opt/open-xchange/sbin/";

sub new {
	my $object = shift;
	my $self = {
		_contextid => shift,
		_adminuser => shift,
		_adminpass => shift,
		_oxpath => shift,
		_oxUserList => shift,
	}; 

	bless($self,$object);

	@{$self->{current_groups}} = $self->getOXGroupList();
	return ($self);
}

#######################################################
#
#
# Processes a single Group (adding it / modifying it)
#
#
#######################################################

sub processGroup() {
	my($self) = shift;
	my $group = shift;
	my $displayname = shift;
	my @users = @_;

	if (! defined($self->findGroup($group))	)
	{
	    return $self->groupAdd($group, $displayname, @users);
	} else {
	    return $self->groupMod($group, $displayname, @users);
	}

}

##############################################################
#
# Deletes all existing OX groups which have not been touched 
# ( tried to modify) since the last call of getOXGroupList
#
##############################################################

sub deleteNotTouchedGroups()
{
	my $self = shift;
	my @groups = @{$self->{current_groups}};

	foreach my $group (@groups)
	{
	    if (! $group->{'touched'})
	    {
		my $oxgroup;                                                                                                                                            
                                                                                                                                                                
                $oxgroup = OX::Group->new($self->{_contextid},$self->{_adminuser}, $self->{_adminpass}, $self->{_oxpath}, $group->{'name'}, $group->{'displayname'}, ());      
	                                                                                                                                                            
    		$oxgroup->groupDelete();		
	    }
	}
}

###########################################################
#
# Finds the Index for a group with specific name
#
###########################################################

sub findGroup()
{
    my ($self) = @_;
    my $class = shift;
    my $searchword = shift;

    my $column = 'name';
    my $cnt=0;
    foreach my $group ( @{$self->{current_groups}} ) {
        return $cnt if( $group->{$column} eq $searchword );
        $cnt++;
    }
    return undef;
}

###########################################################
#
# Finds the index for a user with specific name
#
###########################################################

sub findUser()
{
    my($self) = shift;
    my $searchword = shift;

    my $column = 'name';
    my $cnt=0;
    foreach my $user ( @{$self->{_oxUserList}} ) {
        return $cnt if( $user->{$column} eq $searchword );
        $cnt++;
    }
    return undef;
}

#########################################################
#
# Adds a new group to OX
#
#########################################################

sub groupAdd() {
#	print Dumper(@_);
	my($self) = shift;
	my $group = shift;
	my $displayname = shift;
	my @members = @_;
	my @users = @{$self->{_oxUserList}};
    
	my @memberuids;
	
	foreach my $member (@members)
	{
	    if (defined(my $uid = $self->findUser($member)))
	    {
		push @memberuids, $users[$uid]{'id'};
	    }
	}

	my $oxgroup;

	if ($displayname)
	{
	    $oxgroup = OX::Group->new($self->{_contextid},$self->{_adminuser}, $self->{_adminpass}, $self->{_oxpath}, $group, $displayname, \@memberuids);
	} else {
	    $oxgroup = OX::Group->new($self->{_contextid},$self->{_adminuser}, $self->{_adminpass}, $self->{_oxpath}, $group, $group, \@memberuids);
	}

	return 1 if ($oxgroup->groupAdd());

	return 0;
	
}


###################################################
#
# Modifies an existing Group
#
##################################################

sub groupMod() {
	my $self = shift;
	
	my $group = shift;
	my $displayname = shift;
	my @members = @_;
	my @users = @{$self->{_oxUserList}};
	my @groups = @{$self->{current_groups}};

	$groups[$self->findGroup($group)]{'touched'} = 1;

	my @currentmembers = split(",",$groups[$self->findGroup($group)]{'members'});

	my @newmemberuids;

	for (my $idx=0;$members[$idx];$idx++) 
	{
	    if (defined(my $uid = $self->findUser($members[$idx])))
	    {	
		if ((my $memidx = $self->isMember($users[$uid]{'id'}, @currentmembers)) > -1 )
		{
		    splice(@currentmembers, $memidx, 1);
		} else {
		    push @newmemberuids, $users[$uid]{'id'};
		}
	    }
	}

	if ($#currentmembers > -1 )
	{
	    my $oxgroup;

	    if ($displayname)
	    {
	        $oxgroup = OX::Group->new($self->{_contextid},$self->{_adminuser}, $self->{_adminpass}, $self->{_oxpath}, $group, $displayname, \@currentmembers);
	    } else {
		$oxgroup = OX::Group->new($self->{_contextid},$self->{_adminuser}, $self->{_adminpass}, $self->{_oxpath}, $group, $group, \@currentmembers);
	    }

	    return 0 if (! $oxgroup->groupDelMembers());
	}

	if ($#newmemberuids > -1 )
	{
	    my $oxgroup;

    	    if ($displayname)
	    {
		$oxgroup = OX::Group->new($self->{_contextid},$self->{_adminuser}, $self->{_adminpass}, $self->{_oxpath}, $group, $displayname, \@newmemberuids);
	    } else {
		$oxgroup = OX::Group->new($self->{_contextid},$self->{_adminuser}, $self->{_adminpass}, $self->{_oxpath}, $group, $group, \@newmemberuids);
	    }

	    return 0 if (! $oxgroup->groupAddMembers());
	}
	

	# Mark groups which had no users and have not new users addes for deletion

	my @oldmembers = split(",",$groups[$self->findGroup($group)]{'members'});
	if ($#oldmembers == -1 && $#newmemberuids == -1)
	{
	    $groups[$self->findGroup($group)]{'touched'} = undef;
	}
	return 1;
}

################################################
#
# Is user member of Group
#
################################################
sub isMember() {
	my $self = shift;
	my $uid = shift;
	my @members = @_;

	for (my $i=0;$members[$i];$i++) {
		if ($members[$i] eq $uid) {
			return $i;
		}
	}	
	return -1;
}

###################################################
#
# Gets a list of OX groups with its actual members
#
###################################################
sub getOXGroupList() {
	my ($self) = @_; 
        my $adminauth = "";
	if( ( defined($self->{_adminuser}) && $self->{_adminuser} ne "" ) &&
	    ( defined($self->{_adminpass}) && $self->{_adminpass} ne "" ) ) {
	    $adminauth = "-A ".$self->{_adminuser}." -P ".$self->{_adminpass};
	}
	my $cmd = $self->{_oxpath}."/listgroup -c ".$self->{_contextid}." $adminauth --csv";
	
	my $output = `$cmd 2>&1`;
#	DEBUG($output);
	LOGDIE ("Could not get current Grouplist! Username and Password correct?\n") if (! $? == 0) ;

        my @lines = split(/\n/,$output); 
        my @groups; 
	my %columnmap;
    

        my $headercsv = Text::CSV_XS->new({binary => 1});
	if ($headercsv->parse($lines[0]))
	{
    	    my @headercolumns = $headercsv->fields();
    	    for (my $i=0; $headercolumns[$i]; $i++)
    	    {
        	$columnmap{lc($headercolumns[$i])} = $i;
    	    }
	}

	for (my $i=1;$lines[$i];$i++)
	{
    	    my $csv = Text::CSV_XS->new({binary => 1});
	    if($csv->parse($lines[$i]))
    	    {
        	my @columns = $csv->fields();
        	foreach my $columnName (keys%columnmap)
        	{
            	    $groups[$i-1]{$columnName} = $columns[$columnmap{$columnName}];
        	}
    	    }
	}


 	return (@groups);
}
 
1;
