#########################################################
#
#
# Generates parameter strings for OX Grouphandling
#
#
#########################################################

package OX::Group::Decorator;
use Log::Log4perl qw(:easy);

my $logger; 

sub new {
	my $object = shift; 
	my $self = {
		_groupname => shift,
		_displayname => shift,
		_memberstr => shift,
		_currentmembers => shift 
	};  
	bless($self,$object);
	return ($self);
}


###########################
#
#  Parameter for groupname
#
###########################
sub getGroupStr() {
	my($self)=@_;
	return " -n \"".$self->{_groupname}."\"";
}


#############################
#
#  Parameter for displayname
#
#############################

sub getGroupDisplayStr() {
	my($self)=@_;
	return " -d \"".$self->{_displayname}."\"";
}

#####################################
#
#  Parameter for adding groupmembers
#
#####################################

sub getAddMember() {
	my ($self)=@_;
	return " -a \"".$self->{_memberstr}."\""; 
}

#######################################
#
#  Parameter for deleting groupmembers
#
#######################################

sub getDelMember() {
	my ($self)=@_;
	return " -r \"".$self->{_memberstr}."\"";
}

1;