##############################################
#
# Single OX Group processing
#
##############################################

package OX::Group;
 
use OX::Group::Decorator;
use Data::Dumper;
use Log::Log4perl qw(:easy);

my $logger;
my $contextid = 456; 
my $oxpath = "/opt/open-xchange/sbin/";

sub new {
	my $object = shift;
	my $self = {
		_contextid => shift,
		_adminuser => shift,
		_adminpass => shift,
		_oxpath => shift,
		_groupname => shift,
		_displayname => shift,
		_members => shift,
	}; 
	$logger = get_logger("OX::CSVGroup"); 
	bless($self,$object);
	return ($self);
}

###########################################
#
# adds a group
#
###########################################
sub groupAdd() {
	my($self) = shift;
	my @members = @{$self->{_members}};

	return 1 if ($self->{'_groupname'} eq "users");

	return 0 if ($#members < 0);

	my $decorator = new OX::Group::Decorator($self->{_groupname},$self->{_displayname},join(",",@members));

	my $adminauth = "";
	if( ( defined($self->{_adminuser}) && $self->{_adminuser} ne "" ) &&
	    ( defined($self->{_adminpass}) && $self->{_adminpass} ne "" ) ) {
	    $adminauth = "-A ".$self->{_adminuser}." -P ".$self->{_adminpass};
	}
	my $cmd = $self->{_oxpath}."/creategroup -c ".$self->{_contextid}." $adminauth ".$decorator->getGroupStr().$decorator->getGroupDisplayStr().$decorator->getAddMember();
	DEBUG ($cmd);
	
	my $success =  $self->exec($cmd);

	return 0 if (! $success);

	return 1;
	
}

#############################################
#
# Adds members to a group
#
#############################################

sub groupAddMembers() {
	my($self) = shift;
	my @members = @{$self->{_members}};

	return 1 if ($self->{'_groupname'} eq "users");

	return 0 if ($#members < 0);

	my $decorator = new OX::Group::Decorator($self->{_groupname},$self->{_displayname},join(",",@members));

	my $cmd = $self->{_oxpath}."/changegroup -c ".$self->{_contextid}.(($self->{_adminuser} ne "")?(" -A ".$self->{_adminuser}):("")).(($self->{_adminpass} ne "")?(" -P ".$self->{_adminpass}):(""))." ".$decorator->getGroupStr().$decorator->getGroupDisplayStr().$decorator->getAddMember();
	DEBUG ($cmd);
	
	my $success =  $self->exec($cmd);

	return 0 if (! $success);
	return 1;
}


#############################################
#
# Deletes members from group
#
#############################################
sub groupDelMembers() {
	my($self) = shift;
	my @members = @{$self->{_members}};

	return 1 if ($self->{'_groupname'} eq "users");

	return 0 if ($#members < 0);

	my $decorator = new OX::Group::Decorator($self->{_groupname},$self->{_displayname},join(",",@members));

	my $cmd = $self->{_oxpath}."/changegroup -c ".$self->{_contextid}.(($self->{_adminuser} ne "")?(" -A ".$self->{_adminuser}):("")).(($self->{_adminpass} ne "")?(" -P ".$self->{_adminpass}):(""))." ".$decorator->getGroupStr().$decorator->getGroupDisplayStr().$decorator->getDelMember();
	DEBUG ($cmd);
	
	my $success =  $self->exec($cmd);
	return 0 if (! $success);
	return 1;
	
}

############################################
#
# Deletes a whole group but not "users"
#
############################################

sub groupDelete() {
	my($self,$oxusers) = @_;

	return 1 if ($self->{'_groupname'} eq "users");

	my $decorator = new OX::Group::Decorator($self->{_groupname});
	my $cmd = $self->{_oxpath}."/deletegroup -c ".$self->{_contextid}.(($self->{_adminuser} ne "")?(" -A ".$self->{_adminuser}):("")).(($self->{_adminpass} ne "")?(" -P ".$self->{_adminpass}):(""))." ".$decorator->getGroupStr();
	DEBUG ($cmd);
	my $success =  $self->exec($cmd);

	return 0 if (! $success);

	return 1;
}


############################################
#
# Executes the OX command
#
############################################
sub exec() { 
	my($self,$cmd) = @_; 
	my $output = `$cmd 2>&1`;

	INFO ($output);

	if ($? eq "0")
	{
    	    return 1;
	}
	else
	{
    	    return 0;
	}
}

1;
