###################################
#
# Just reads a config file
#
###################################

package OX::Config::Reader;

use strict;
use warnings;
use Data::Dumper;

sub readConfig
{
#    my $class = shift;
    my $filename = shift;
    my $lowercase = shift; 

    my $conf;
	
    open(CONFIG, $filename) || die "unable to open $filename: $!";
    while (<CONFIG>) {
	chomp;                  # no newline
	s/#.*//;                # no comments
	s/^\s+//;               # no leading white
	s/\s+$//;               # no trailing white
        next unless length;     # anything left?
	my ($var, $value) = split(/\s*=\s*/, $_, 2);

	if ($lowercase)
	{
	    $conf->{lc($var)} = $value;
	} else {
	    $conf->{$var} = $value;
	}
    }
    close (CONFIG);
    return $conf;
}

1;
